<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Apaga ServiceType
 * @subpackage Services
 */
class Apaga extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ApagaArtigoArmazem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArtigoArmazem $parameters
     * @return \StructType\ApagaArtigoArmazemResponse|bool
     */
    public function ApagaArtigoArmazem(\StructType\ApagaArtigoArmazem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArtigoArmazem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaVendedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaVendedor $parameters
     * @return \StructType\ApagaVendedorResponse|bool
     */
    public function ApagaVendedor(\StructType\ApagaVendedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaVendedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaPais $parameters
     * @return \StructType\ApagaPaisResponse|bool
     */
    public function ApagaPais(\StructType\ApagaPais $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoContacto $parameters
     * @return \StructType\ApagaTipoContactoResponse|bool
     */
    public function ApagaTipoContacto(\StructType\ApagaTipoContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoParceiro $parameters
     * @return \StructType\ApagaTipoParceiroResponse|bool
     */
    public function ApagaTipoParceiro(\StructType\ApagaTipoParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaContacto $parameters
     * @return \StructType\ApagaContactoResponse|bool
     */
    public function ApagaContacto(\StructType\ApagaContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArmazem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArmazem $parameters
     * @return \StructType\ApagaArmazemResponse|bool
     */
    public function ApagaArmazem(\StructType\ApagaArmazem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArmazem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArmazemLocalizacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArmazemLocalizacao $parameters
     * @return \StructType\ApagaArmazemLocalizacaoResponse|bool
     */
    public function ApagaArmazemLocalizacao(\StructType\ApagaArmazemLocalizacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArmazemLocalizacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaMetodoPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaMetodoPagamento $parameters
     * @return \StructType\ApagaMetodoPagamentoResponse|bool
     */
    public function ApagaMetodoPagamento(\StructType\ApagaMetodoPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaMetodoPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaCondicaoPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaCondicaoPagamento $parameters
     * @return \StructType\ApagaCondicaoPagamentoResponse|bool
     */
    public function ApagaCondicaoPagamento(\StructType\ApagaCondicaoPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaCondicaoPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArtigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArtigo $parameters
     * @return \StructType\ApagaArtigoResponse|bool
     */
    public function ApagaArtigo(\StructType\ApagaArtigo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArtigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoDocIdentificacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoDocIdentificacao $parameters
     * @return \StructType\ApagaTipoDocIdentificacaoResponse|bool
     */
    public function ApagaTipoDocIdentificacao(\StructType\ApagaTipoDocIdentificacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoDocIdentificacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArtigoFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArtigoFornecedor $parameters
     * @return \StructType\ApagaArtigoFornecedorResponse|bool
     */
    public function ApagaArtigoFornecedor(\StructType\ApagaArtigoFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArtigoFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArtigoIdioma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArtigoIdioma $parameters
     * @return \StructType\ApagaArtigoIdiomaResponse|bool
     */
    public function ApagaArtigoIdioma(\StructType\ApagaArtigoIdioma $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArtigoIdioma($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArtigoLote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArtigoLote $parameters
     * @return \StructType\ApagaArtigoLoteResponse|bool
     */
    public function ApagaArtigoLote(\StructType\ApagaArtigoLote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArtigoLote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArtigoMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArtigoMoeda $parameters
     * @return \StructType\ApagaArtigoMoedaResponse|bool
     */
    public function ApagaArtigoMoeda(\StructType\ApagaArtigoMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArtigoMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaArtigoUnidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaArtigoUnidade $parameters
     * @return \StructType\ApagaArtigoUnidadeResponse|bool
     */
    public function ApagaArtigoUnidade(\StructType\ApagaArtigoUnidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaArtigoUnidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaDocumentoCompra $parameters
     * @return \StructType\ApagaDocumentoCompraResponse|bool
     */
    public function ApagaDocumentoCompra(\StructType\ApagaDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaDocumentoVenda $parameters
     * @return \StructType\ApagaDocumentoVendaResponse|bool
     */
    public function ApagaDocumentoVenda(\StructType\ApagaDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaParceiro $parameters
     * @return \StructType\ApagaParceiroResponse|bool
     */
    public function ApagaParceiro(\StructType\ApagaParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaDocumentoInterno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaDocumentoInterno $parameters
     * @return \StructType\ApagaDocumentoInternoResponse|bool
     */
    public function ApagaDocumentoInterno(\StructType\ApagaDocumentoInterno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaDocumentoInterno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaDocumentoLiquidacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaDocumentoLiquidacao $parameters
     * @return \StructType\ApagaDocumentoLiquidacaoResponse|bool
     */
    public function ApagaDocumentoLiquidacao(\StructType\ApagaDocumentoLiquidacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaDocumentoLiquidacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaCliente $parameters
     * @return \StructType\ApagaClienteResponse|bool
     */
    public function ApagaCliente(\StructType\ApagaCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaConcelho
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaConcelho $parameters
     * @return \StructType\ApagaConcelhoResponse|bool
     */
    public function ApagaConcelho(\StructType\ApagaConcelho $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaConcelho($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaConfiguracaoEasyPay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaConfiguracaoEasyPay $parameters
     * @return \StructType\ApagaConfiguracaoEasyPayResponse|bool
     */
    public function ApagaConfiguracaoEasyPay(\StructType\ApagaConfiguracaoEasyPay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaConfiguracaoEasyPay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaContaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaContaBancaria $parameters
     * @return \StructType\ApagaContaBancariaResponse|bool
     */
    public function ApagaContaBancaria(\StructType\ApagaContaBancaria $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaContaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaDistrito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaDistrito $parameters
     * @return \StructType\ApagaDistritoResponse|bool
     */
    public function ApagaDistrito(\StructType\ApagaDistrito $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaDistrito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoDocumentoContaCorrente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoDocumentoContaCorrente $parameters
     * @return \StructType\ApagaTipoDocumentoContaCorrenteResponse|bool
     */
    public function ApagaTipoDocumentoContaCorrente(\StructType\ApagaTipoDocumentoContaCorrente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoDocumentoContaCorrente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoDocumentoCompra $parameters
     * @return \StructType\ApagaTipoDocumentoCompraResponse|bool
     */
    public function ApagaTipoDocumentoCompra(\StructType\ApagaTipoDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoDocumentoInterno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoDocumentoInterno $parameters
     * @return \StructType\ApagaTipoDocumentoInternoResponse|bool
     */
    public function ApagaTipoDocumentoInterno(\StructType\ApagaTipoDocumentoInterno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoDocumentoInterno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoDocumentStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoDocumentStock $parameters
     * @return \StructType\ApagaTipoDocumentStockResponse|bool
     */
    public function ApagaTipoDocumentStock(\StructType\ApagaTipoDocumentStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoDocumentStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoDocumentoVenda $parameters
     * @return \StructType\ApagaTipoDocumentoVendaResponse|bool
     */
    public function ApagaTipoDocumentoVenda(\StructType\ApagaTipoDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaFamilia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaFamilia $parameters
     * @return \StructType\ApagaFamiliaResponse|bool
     */
    public function ApagaFamilia(\StructType\ApagaFamilia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaFamilia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaFornecedor $parameters
     * @return \StructType\ApagaFornecedorResponse|bool
     */
    public function ApagaFornecedor(\StructType\ApagaFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaFreguesia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaFreguesia $parameters
     * @return \StructType\ApagaFreguesiaResponse|bool
     */
    public function ApagaFreguesia(\StructType\ApagaFreguesia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaFreguesia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaFuncionario
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaFuncionario $parameters
     * @return \StructType\ApagaFuncionarioResponse|bool
     */
    public function ApagaFuncionario(\StructType\ApagaFuncionario $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaFuncionario($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaIva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaIva $parameters
     * @return \StructType\ApagaIvaResponse|bool
     */
    public function ApagaIva(\StructType\ApagaIva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaIva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaMarca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaMarca $parameters
     * @return \StructType\ApagaMarcaResponse|bool
     */
    public function ApagaMarca(\StructType\ApagaMarca $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaMarca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaModelo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaModelo $parameters
     * @return \StructType\ApagaModeloResponse|bool
     */
    public function ApagaModelo(\StructType\ApagaModelo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaModelo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaMoeda $parameters
     * @return \StructType\ApagaMoedaResponse|bool
     */
    public function ApagaMoeda(\StructType\ApagaMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaMoradaAlternativaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaMoradaAlternativaCliente $parameters
     * @return \StructType\ApagaMoradaAlternativaClienteResponse|bool
     */
    public function ApagaMoradaAlternativaCliente(\StructType\ApagaMoradaAlternativaCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaMoradaAlternativaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaMoradaAlternativaFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaMoradaAlternativaFornecedor $parameters
     * @return \StructType\ApagaMoradaAlternativaFornecedorResponse|bool
     */
    public function ApagaMoradaAlternativaFornecedor(\StructType\ApagaMoradaAlternativaFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaMoradaAlternativaFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaMotivoEstorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaMotivoEstorno $parameters
     * @return \StructType\ApagaMotivoEstornoResponse|bool
     */
    public function ApagaMotivoEstorno(\StructType\ApagaMotivoEstorno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaMotivoEstorno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaOrigemContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaOrigemContacto $parameters
     * @return \StructType\ApagaOrigemContactoResponse|bool
     */
    public function ApagaOrigemContacto(\StructType\ApagaOrigemContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaOrigemContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaOutroTerceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaOutroTerceiro $parameters
     * @return \StructType\ApagaOutroTerceiroResponse|bool
     */
    public function ApagaOutroTerceiro(\StructType\ApagaOutroTerceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaOutroTerceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaPendente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaPendente $parameters
     * @return \StructType\ApagaPendenteResponse|bool
     */
    public function ApagaPendente(\StructType\ApagaPendente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaPendente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaSerieCCT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaSerieCCT $parameters
     * @return \StructType\ApagaSerieCCTResponse|bool
     */
    public function ApagaSerieCCT(\StructType\ApagaSerieCCT $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaSerieCCT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaSerieStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaSerieStock $parameters
     * @return \StructType\ApagaSerieStockResponse|bool
     */
    public function ApagaSerieStock(\StructType\ApagaSerieStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaSerieStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaSerieVendas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaSerieVendas $parameters
     * @return \StructType\ApagaSerieVendasResponse|bool
     */
    public function ApagaSerieVendas(\StructType\ApagaSerieVendas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaSerieVendas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaTipoTerceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaTipoTerceiro $parameters
     * @return \StructType\ApagaTipoTerceiroResponse|bool
     */
    public function ApagaTipoTerceiro(\StructType\ApagaTipoTerceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaTipoTerceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaUnidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaUnidade $parameters
     * @return \StructType\ApagaUnidadeResponse|bool
     */
    public function ApagaUnidade(\StructType\ApagaUnidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaUnidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApagaModoExpedicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApagaModoExpedicao $parameters
     * @return \StructType\ApagaModoExpedicaoResponse|bool
     */
    public function ApagaModoExpedicao(\StructType\ApagaModoExpedicao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ApagaModoExpedicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ApagaArmazemLocalizacaoResponse|\StructType\ApagaArmazemResponse|\StructType\ApagaArtigoArmazemResponse|\StructType\ApagaArtigoFornecedorResponse|\StructType\ApagaArtigoIdiomaResponse|\StructType\ApagaArtigoLoteResponse|\StructType\ApagaArtigoMoedaResponse|\StructType\ApagaArtigoResponse|\StructType\ApagaArtigoUnidadeResponse|\StructType\ApagaClienteResponse|\StructType\ApagaConcelhoResponse|\StructType\ApagaCondicaoPagamentoResponse|\StructType\ApagaConfiguracaoEasyPayResponse|\StructType\ApagaContaBancariaResponse|\StructType\ApagaContactoResponse|\StructType\ApagaDistritoResponse|\StructType\ApagaDocumentoCompraResponse|\StructType\ApagaDocumentoInternoResponse|\StructType\ApagaDocumentoLiquidacaoResponse|\StructType\ApagaDocumentoVendaResponse|\StructType\ApagaFamiliaResponse|\StructType\ApagaFornecedorResponse|\StructType\ApagaFreguesiaResponse|\StructType\ApagaFuncionarioResponse|\StructType\ApagaIvaResponse|\StructType\ApagaMarcaResponse|\StructType\ApagaMetodoPagamentoResponse|\StructType\ApagaModeloResponse|\StructType\ApagaModoExpedicaoResponse|\StructType\ApagaMoedaResponse|\StructType\ApagaMoradaAlternativaClienteResponse|\StructType\ApagaMoradaAlternativaFornecedorResponse|\StructType\ApagaMotivoEstornoResponse|\StructType\ApagaOrigemContactoResponse|\StructType\ApagaOutroTerceiroResponse|\StructType\ApagaPaisResponse|\StructType\ApagaParceiroResponse|\StructType\ApagaPendenteResponse|\StructType\ApagaSerieCCTResponse|\StructType\ApagaSerieStockResponse|\StructType\ApagaSerieVendasResponse|\StructType\ApagaTipoContactoResponse|\StructType\ApagaTipoDocIdentificacaoResponse|\StructType\ApagaTipoDocumentoCompraResponse|\StructType\ApagaTipoDocumentoContaCorrenteResponse|\StructType\ApagaTipoDocumentoInternoResponse|\StructType\ApagaTipoDocumentoVendaResponse|\StructType\ApagaTipoDocumentStockResponse|\StructType\ApagaTipoParceiroResponse|\StructType\ApagaTipoTerceiroResponse|\StructType\ApagaUnidadeResponse|\StructType\ApagaVendedorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
