<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Abre ServiceType
 * @subpackage Services
 */
class Abre extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AbrePlataformaDEBUG
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AbrePlataformaDEBUG $parameters
     * @return \StructType\AbrePlataformaDEBUGResponse|bool
     */
    public function AbrePlataformaDEBUG(\StructType\AbrePlataformaDEBUG $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AbrePlataformaDEBUG($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AbrePlataforma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AbrePlataforma $parameters
     * @return \StructType\AbrePlataformaResponse|bool
     */
    public function AbrePlataforma(\StructType\AbrePlataforma $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AbrePlataforma($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AbreEmpresaPrimavera
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AbreEmpresaPrimavera $parameters
     * @return \StructType\AbreEmpresaPrimaveraResponse|bool
     */
    public function AbreEmpresaPrimavera(\StructType\AbreEmpresaPrimavera $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AbreEmpresaPrimavera($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AbreEmpresaPrimaveraResponse|\StructType\AbrePlataformaDEBUGResponse|\StructType\AbrePlataformaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
