<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVendedoresERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfVendedoresERP
 * @subpackage Arrays
 */
class ArrayOfVendedoresERP extends AbstractStructArrayBase
{
    /**
     * The VendedoresERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VendedoresERP[]
     */
    public $VendedoresERP;
    /**
     * Constructor method for ArrayOfVendedoresERP
     * @uses ArrayOfVendedoresERP::setVendedoresERP()
     * @param \StructType\VendedoresERP[] $vendedoresERP
     */
    public function __construct(array $vendedoresERP = array())
    {
        $this
            ->setVendedoresERP($vendedoresERP);
    }
    /**
     * Get VendedoresERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VendedoresERP[]|null
     */
    public function getVendedoresERP()
    {
        return isset($this->VendedoresERP) ? $this->VendedoresERP : null;
    }
    /**
     * Set VendedoresERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VendedoresERP[] $vendedoresERP
     * @return \ArrayType\ArrayOfVendedoresERP
     */
    public function setVendedoresERP(array $vendedoresERP = array())
    {
        foreach ($vendedoresERP as $arrayOfVendedoresERPVendedoresERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfVendedoresERPVendedoresERPItem instanceof \StructType\VendedoresERP) {
                throw new \InvalidArgumentException(sprintf('The VendedoresERP property can only contain items of \StructType\VendedoresERP, "%s" given', is_object($arrayOfVendedoresERPVendedoresERPItem) ? get_class($arrayOfVendedoresERPVendedoresERPItem) : gettype($arrayOfVendedoresERPVendedoresERPItem)), __LINE__);
            }
        }
        if (is_null($vendedoresERP) || (is_array($vendedoresERP) && empty($vendedoresERP))) {
            unset($this->VendedoresERP);
        } else {
            $this->VendedoresERP = $vendedoresERP;
        }
        return $this;
    }
    /**
     * Add item to VendedoresERP value
     * @throws \InvalidArgumentException
     * @param \StructType\VendedoresERP $item
     * @return \ArrayType\ArrayOfVendedoresERP
     */
    public function addToVendedoresERP(\StructType\VendedoresERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendedoresERP) {
            throw new \InvalidArgumentException(sprintf('The VendedoresERP property can only contain items of \StructType\VendedoresERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendedoresERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VendedoresERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VendedoresERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VendedoresERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VendedoresERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VendedoresERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VendedoresERP
     */
    public function getAttributeName()
    {
        return 'VendedoresERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVendedoresERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
