<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArtigoERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfArtigoERP
 * @subpackage Arrays
 */
class ArrayOfArtigoERP extends AbstractStructArrayBase
{
    /**
     * The ArtigoERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArtigoERP[]
     */
    public $ArtigoERP;
    /**
     * Constructor method for ArrayOfArtigoERP
     * @uses ArrayOfArtigoERP::setArtigoERP()
     * @param \StructType\ArtigoERP[] $artigoERP
     */
    public function __construct(array $artigoERP = array())
    {
        $this
            ->setArtigoERP($artigoERP);
    }
    /**
     * Get ArtigoERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArtigoERP[]|null
     */
    public function getArtigoERP()
    {
        return isset($this->ArtigoERP) ? $this->ArtigoERP : null;
    }
    /**
     * Set ArtigoERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArtigoERP[] $artigoERP
     * @return \ArrayType\ArrayOfArtigoERP
     */
    public function setArtigoERP(array $artigoERP = array())
    {
        foreach ($artigoERP as $arrayOfArtigoERPArtigoERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfArtigoERPArtigoERPItem instanceof \StructType\ArtigoERP) {
                throw new \InvalidArgumentException(sprintf('The ArtigoERP property can only contain items of \StructType\ArtigoERP, "%s" given', is_object($arrayOfArtigoERPArtigoERPItem) ? get_class($arrayOfArtigoERPArtigoERPItem) : gettype($arrayOfArtigoERPArtigoERPItem)), __LINE__);
            }
        }
        if (is_null($artigoERP) || (is_array($artigoERP) && empty($artigoERP))) {
            unset($this->ArtigoERP);
        } else {
            $this->ArtigoERP = $artigoERP;
        }
        return $this;
    }
    /**
     * Add item to ArtigoERP value
     * @throws \InvalidArgumentException
     * @param \StructType\ArtigoERP $item
     * @return \ArrayType\ArrayOfArtigoERP
     */
    public function addToArtigoERP(\StructType\ArtigoERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArtigoERP) {
            throw new \InvalidArgumentException(sprintf('The ArtigoERP property can only contain items of \StructType\ArtigoERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArtigoERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ArtigoERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ArtigoERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ArtigoERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ArtigoERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ArtigoERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArtigoERP
     */
    public function getAttributeName()
    {
        return 'ArtigoERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfArtigoERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
