<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebProduct Struct
 * @subpackage Structs
 */
class WebProduct extends AbstractStructBase
{
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The ProductTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductTypeID;
    /**
     * The ContractPeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractPeriodID;
    /**
     * The ContractLengthTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractLengthTypeID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The DepositModelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepositModelID;
    /**
     * The GreenEnergyPercent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GreenEnergyPercent;
    /**
     * The IsAutopayRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAutopayRequired;
    /**
     * The IsEbillRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEbillRequired;
    /**
     * The EarlyTerminationFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EarlyTerminationFee;
    /**
     * The ContractPeriodNumValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractPeriodNumValue;
    /**
     * The ContractLengthDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractLengthDays;
    /**
     * The ProductDisplayCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDisplayCategoryID;
    /**
     * The IsRecommended
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRecommended;
    /**
     * The IsFeatured
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFeatured;
    /**
     * The Kwh0500Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kwh0500Price;
    /**
     * The Kwh1000Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kwh1000Price;
    /**
     * The Kwh2000Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kwh2000Price;
    /**
     * The KwhAvgPriceTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KwhAvgPriceTypeID;
    /**
     * The KwhAvgPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KwhAvgPrice;
    /**
     * The DisconnectThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DisconnectThreshold;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ContractLengthName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractLengthName;
    /**
     * The ContractPeriodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractPeriodName;
    /**
     * The ProductDisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayName;
    /**
     * The ProductDisplayShortDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayShortDescription;
    /**
     * The ProductDisplayLongDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayLongDescription;
    /**
     * The ProductDisplayCategoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayCategoryName;
    /**
     * The FeaturedImageUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeaturedImageUrl;
    /**
     * The ProductDisplayFeature1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayFeature1;
    /**
     * The ProductDisplayFeature2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayFeature2;
    /**
     * The ProductDisplayFeature3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayFeature3;
    /**
     * The ProductDisplayFeature4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayFeature4;
    /**
     * The ProductDisplayFeature5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayFeature5;
    /**
     * The ProductDisplayPromotion1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayPromotion1;
    /**
     * The ProductDisplayPromotion2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayPromotion2;
    /**
     * The ProductDisplayPromotion3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDisplayPromotion3;
    /**
     * The ProductDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductDocument
     */
    public $ProductDocuments;
    /**
     * Constructor method for WebProduct
     * @uses WebProduct::setProductID()
     * @uses WebProduct::setProductTypeID()
     * @uses WebProduct::setContractPeriodID()
     * @uses WebProduct::setContractLengthTypeID()
     * @uses WebProduct::setActive()
     * @uses WebProduct::setDepositModelID()
     * @uses WebProduct::setGreenEnergyPercent()
     * @uses WebProduct::setIsAutopayRequired()
     * @uses WebProduct::setIsEbillRequired()
     * @uses WebProduct::setEarlyTerminationFee()
     * @uses WebProduct::setContractPeriodNumValue()
     * @uses WebProduct::setContractLengthDays()
     * @uses WebProduct::setProductDisplayCategoryID()
     * @uses WebProduct::setIsRecommended()
     * @uses WebProduct::setIsFeatured()
     * @uses WebProduct::setKwh0500Price()
     * @uses WebProduct::setKwh1000Price()
     * @uses WebProduct::setKwh2000Price()
     * @uses WebProduct::setKwhAvgPriceTypeID()
     * @uses WebProduct::setKwhAvgPrice()
     * @uses WebProduct::setDisconnectThreshold()
     * @uses WebProduct::setName()
     * @uses WebProduct::setDescription()
     * @uses WebProduct::setContractLengthName()
     * @uses WebProduct::setContractPeriodName()
     * @uses WebProduct::setProductDisplayName()
     * @uses WebProduct::setProductDisplayShortDescription()
     * @uses WebProduct::setProductDisplayLongDescription()
     * @uses WebProduct::setProductDisplayCategoryName()
     * @uses WebProduct::setFeaturedImageUrl()
     * @uses WebProduct::setProductDisplayFeature1()
     * @uses WebProduct::setProductDisplayFeature2()
     * @uses WebProduct::setProductDisplayFeature3()
     * @uses WebProduct::setProductDisplayFeature4()
     * @uses WebProduct::setProductDisplayFeature5()
     * @uses WebProduct::setProductDisplayPromotion1()
     * @uses WebProduct::setProductDisplayPromotion2()
     * @uses WebProduct::setProductDisplayPromotion3()
     * @uses WebProduct::setProductDocuments()
     * @param int $productID
     * @param int $productTypeID
     * @param int $contractPeriodID
     * @param int $contractLengthTypeID
     * @param bool $active
     * @param int $depositModelID
     * @param float $greenEnergyPercent
     * @param bool $isAutopayRequired
     * @param bool $isEbillRequired
     * @param float $earlyTerminationFee
     * @param int $contractPeriodNumValue
     * @param int $contractLengthDays
     * @param int $productDisplayCategoryID
     * @param bool $isRecommended
     * @param bool $isFeatured
     * @param float $kwh0500Price
     * @param float $kwh1000Price
     * @param float $kwh2000Price
     * @param int $kwhAvgPriceTypeID
     * @param float $kwhAvgPrice
     * @param float $disconnectThreshold
     * @param string $name
     * @param string $description
     * @param string $contractLengthName
     * @param string $contractPeriodName
     * @param string $productDisplayName
     * @param string $productDisplayShortDescription
     * @param string $productDisplayLongDescription
     * @param string $productDisplayCategoryName
     * @param string $featuredImageUrl
     * @param string $productDisplayFeature1
     * @param string $productDisplayFeature2
     * @param string $productDisplayFeature3
     * @param string $productDisplayFeature4
     * @param string $productDisplayFeature5
     * @param string $productDisplayPromotion1
     * @param string $productDisplayPromotion2
     * @param string $productDisplayPromotion3
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     */
    public function __construct($productID = null, $productTypeID = null, $contractPeriodID = null, $contractLengthTypeID = null, $active = null, $depositModelID = null, $greenEnergyPercent = null, $isAutopayRequired = null, $isEbillRequired = null, $earlyTerminationFee = null, $contractPeriodNumValue = null, $contractLengthDays = null, $productDisplayCategoryID = null, $isRecommended = null, $isFeatured = null, $kwh0500Price = null, $kwh1000Price = null, $kwh2000Price = null, $kwhAvgPriceTypeID = null, $kwhAvgPrice = null, $disconnectThreshold = null, $name = null, $description = null, $contractLengthName = null, $contractPeriodName = null, $productDisplayName = null, $productDisplayShortDescription = null, $productDisplayLongDescription = null, $productDisplayCategoryName = null, $featuredImageUrl = null, $productDisplayFeature1 = null, $productDisplayFeature2 = null, $productDisplayFeature3 = null, $productDisplayFeature4 = null, $productDisplayFeature5 = null, $productDisplayPromotion1 = null, $productDisplayPromotion2 = null, $productDisplayPromotion3 = null, \SGCIS\Array\ArrayOfProductDocument $productDocuments = null)
    {
        $this
            ->setProductID($productID)
            ->setProductTypeID($productTypeID)
            ->setContractPeriodID($contractPeriodID)
            ->setContractLengthTypeID($contractLengthTypeID)
            ->setActive($active)
            ->setDepositModelID($depositModelID)
            ->setGreenEnergyPercent($greenEnergyPercent)
            ->setIsAutopayRequired($isAutopayRequired)
            ->setIsEbillRequired($isEbillRequired)
            ->setEarlyTerminationFee($earlyTerminationFee)
            ->setContractPeriodNumValue($contractPeriodNumValue)
            ->setContractLengthDays($contractLengthDays)
            ->setProductDisplayCategoryID($productDisplayCategoryID)
            ->setIsRecommended($isRecommended)
            ->setIsFeatured($isFeatured)
            ->setKwh0500Price($kwh0500Price)
            ->setKwh1000Price($kwh1000Price)
            ->setKwh2000Price($kwh2000Price)
            ->setKwhAvgPriceTypeID($kwhAvgPriceTypeID)
            ->setKwhAvgPrice($kwhAvgPrice)
            ->setDisconnectThreshold($disconnectThreshold)
            ->setName($name)
            ->setDescription($description)
            ->setContractLengthName($contractLengthName)
            ->setContractPeriodName($contractPeriodName)
            ->setProductDisplayName($productDisplayName)
            ->setProductDisplayShortDescription($productDisplayShortDescription)
            ->setProductDisplayLongDescription($productDisplayLongDescription)
            ->setProductDisplayCategoryName($productDisplayCategoryName)
            ->setFeaturedImageUrl($featuredImageUrl)
            ->setProductDisplayFeature1($productDisplayFeature1)
            ->setProductDisplayFeature2($productDisplayFeature2)
            ->setProductDisplayFeature3($productDisplayFeature3)
            ->setProductDisplayFeature4($productDisplayFeature4)
            ->setProductDisplayFeature5($productDisplayFeature5)
            ->setProductDisplayPromotion1($productDisplayPromotion1)
            ->setProductDisplayPromotion2($productDisplayPromotion2)
            ->setProductDisplayPromotion3($productDisplayPromotion3)
            ->setProductDocuments($productDocuments);
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ProductTypeID value
     * @return int
     */
    public function getProductTypeID()
    {
        return $this->ProductTypeID;
    }
    /**
     * Set ProductTypeID value
     * @param int $productTypeID
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductTypeID($productTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($productTypeID) && !is_numeric($productTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productTypeID)), __LINE__);
        }
        $this->ProductTypeID = $productTypeID;
        return $this;
    }
    /**
     * Get ContractPeriodID value
     * @return int
     */
    public function getContractPeriodID()
    {
        return $this->ContractPeriodID;
    }
    /**
     * Set ContractPeriodID value
     * @param int $contractPeriodID
     * @return \SGCIS\Struct\WebProduct
     */
    public function setContractPeriodID($contractPeriodID = null)
    {
        // validation for constraint: int
        if (!is_null($contractPeriodID) && !is_numeric($contractPeriodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractPeriodID)), __LINE__);
        }
        $this->ContractPeriodID = $contractPeriodID;
        return $this;
    }
    /**
     * Get ContractLengthTypeID value
     * @return int
     */
    public function getContractLengthTypeID()
    {
        return $this->ContractLengthTypeID;
    }
    /**
     * Set ContractLengthTypeID value
     * @param int $contractLengthTypeID
     * @return \SGCIS\Struct\WebProduct
     */
    public function setContractLengthTypeID($contractLengthTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contractLengthTypeID) && !is_numeric($contractLengthTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractLengthTypeID)), __LINE__);
        }
        $this->ContractLengthTypeID = $contractLengthTypeID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\WebProduct
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get DepositModelID value
     * @return int
     */
    public function getDepositModelID()
    {
        return $this->DepositModelID;
    }
    /**
     * Set DepositModelID value
     * @param int $depositModelID
     * @return \SGCIS\Struct\WebProduct
     */
    public function setDepositModelID($depositModelID = null)
    {
        // validation for constraint: int
        if (!is_null($depositModelID) && !is_numeric($depositModelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depositModelID)), __LINE__);
        }
        $this->DepositModelID = $depositModelID;
        return $this;
    }
    /**
     * Get GreenEnergyPercent value
     * @return float
     */
    public function getGreenEnergyPercent()
    {
        return $this->GreenEnergyPercent;
    }
    /**
     * Set GreenEnergyPercent value
     * @param float $greenEnergyPercent
     * @return \SGCIS\Struct\WebProduct
     */
    public function setGreenEnergyPercent($greenEnergyPercent = null)
    {
        $this->GreenEnergyPercent = $greenEnergyPercent;
        return $this;
    }
    /**
     * Get IsAutopayRequired value
     * @return bool
     */
    public function getIsAutopayRequired()
    {
        return $this->IsAutopayRequired;
    }
    /**
     * Set IsAutopayRequired value
     * @param bool $isAutopayRequired
     * @return \SGCIS\Struct\WebProduct
     */
    public function setIsAutopayRequired($isAutopayRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutopayRequired) && !is_bool($isAutopayRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAutopayRequired)), __LINE__);
        }
        $this->IsAutopayRequired = $isAutopayRequired;
        return $this;
    }
    /**
     * Get IsEbillRequired value
     * @return bool
     */
    public function getIsEbillRequired()
    {
        return $this->IsEbillRequired;
    }
    /**
     * Set IsEbillRequired value
     * @param bool $isEbillRequired
     * @return \SGCIS\Struct\WebProduct
     */
    public function setIsEbillRequired($isEbillRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEbillRequired) && !is_bool($isEbillRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEbillRequired)), __LINE__);
        }
        $this->IsEbillRequired = $isEbillRequired;
        return $this;
    }
    /**
     * Get EarlyTerminationFee value
     * @return float
     */
    public function getEarlyTerminationFee()
    {
        return $this->EarlyTerminationFee;
    }
    /**
     * Set EarlyTerminationFee value
     * @param float $earlyTerminationFee
     * @return \SGCIS\Struct\WebProduct
     */
    public function setEarlyTerminationFee($earlyTerminationFee = null)
    {
        $this->EarlyTerminationFee = $earlyTerminationFee;
        return $this;
    }
    /**
     * Get ContractPeriodNumValue value
     * @return int
     */
    public function getContractPeriodNumValue()
    {
        return $this->ContractPeriodNumValue;
    }
    /**
     * Set ContractPeriodNumValue value
     * @param int $contractPeriodNumValue
     * @return \SGCIS\Struct\WebProduct
     */
    public function setContractPeriodNumValue($contractPeriodNumValue = null)
    {
        // validation for constraint: int
        if (!is_null($contractPeriodNumValue) && !is_numeric($contractPeriodNumValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractPeriodNumValue)), __LINE__);
        }
        $this->ContractPeriodNumValue = $contractPeriodNumValue;
        return $this;
    }
    /**
     * Get ContractLengthDays value
     * @return int
     */
    public function getContractLengthDays()
    {
        return $this->ContractLengthDays;
    }
    /**
     * Set ContractLengthDays value
     * @param int $contractLengthDays
     * @return \SGCIS\Struct\WebProduct
     */
    public function setContractLengthDays($contractLengthDays = null)
    {
        // validation for constraint: int
        if (!is_null($contractLengthDays) && !is_numeric($contractLengthDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractLengthDays)), __LINE__);
        }
        $this->ContractLengthDays = $contractLengthDays;
        return $this;
    }
    /**
     * Get ProductDisplayCategoryID value
     * @return int
     */
    public function getProductDisplayCategoryID()
    {
        return $this->ProductDisplayCategoryID;
    }
    /**
     * Set ProductDisplayCategoryID value
     * @param int $productDisplayCategoryID
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayCategoryID($productDisplayCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($productDisplayCategoryID) && !is_numeric($productDisplayCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDisplayCategoryID)), __LINE__);
        }
        $this->ProductDisplayCategoryID = $productDisplayCategoryID;
        return $this;
    }
    /**
     * Get IsRecommended value
     * @return bool
     */
    public function getIsRecommended()
    {
        return $this->IsRecommended;
    }
    /**
     * Set IsRecommended value
     * @param bool $isRecommended
     * @return \SGCIS\Struct\WebProduct
     */
    public function setIsRecommended($isRecommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecommended) && !is_bool($isRecommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRecommended)), __LINE__);
        }
        $this->IsRecommended = $isRecommended;
        return $this;
    }
    /**
     * Get IsFeatured value
     * @return bool
     */
    public function getIsFeatured()
    {
        return $this->IsFeatured;
    }
    /**
     * Set IsFeatured value
     * @param bool $isFeatured
     * @return \SGCIS\Struct\WebProduct
     */
    public function setIsFeatured($isFeatured = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFeatured) && !is_bool($isFeatured)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFeatured)), __LINE__);
        }
        $this->IsFeatured = $isFeatured;
        return $this;
    }
    /**
     * Get Kwh0500Price value
     * @return float
     */
    public function getKwh0500Price()
    {
        return $this->Kwh0500Price;
    }
    /**
     * Set Kwh0500Price value
     * @param float $kwh0500Price
     * @return \SGCIS\Struct\WebProduct
     */
    public function setKwh0500Price($kwh0500Price = null)
    {
        $this->Kwh0500Price = $kwh0500Price;
        return $this;
    }
    /**
     * Get Kwh1000Price value
     * @return float
     */
    public function getKwh1000Price()
    {
        return $this->Kwh1000Price;
    }
    /**
     * Set Kwh1000Price value
     * @param float $kwh1000Price
     * @return \SGCIS\Struct\WebProduct
     */
    public function setKwh1000Price($kwh1000Price = null)
    {
        $this->Kwh1000Price = $kwh1000Price;
        return $this;
    }
    /**
     * Get Kwh2000Price value
     * @return float
     */
    public function getKwh2000Price()
    {
        return $this->Kwh2000Price;
    }
    /**
     * Set Kwh2000Price value
     * @param float $kwh2000Price
     * @return \SGCIS\Struct\WebProduct
     */
    public function setKwh2000Price($kwh2000Price = null)
    {
        $this->Kwh2000Price = $kwh2000Price;
        return $this;
    }
    /**
     * Get KwhAvgPriceTypeID value
     * @return int
     */
    public function getKwhAvgPriceTypeID()
    {
        return $this->KwhAvgPriceTypeID;
    }
    /**
     * Set KwhAvgPriceTypeID value
     * @param int $kwhAvgPriceTypeID
     * @return \SGCIS\Struct\WebProduct
     */
    public function setKwhAvgPriceTypeID($kwhAvgPriceTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($kwhAvgPriceTypeID) && !is_numeric($kwhAvgPriceTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kwhAvgPriceTypeID)), __LINE__);
        }
        $this->KwhAvgPriceTypeID = $kwhAvgPriceTypeID;
        return $this;
    }
    /**
     * Get KwhAvgPrice value
     * @return float
     */
    public function getKwhAvgPrice()
    {
        return $this->KwhAvgPrice;
    }
    /**
     * Set KwhAvgPrice value
     * @param float $kwhAvgPrice
     * @return \SGCIS\Struct\WebProduct
     */
    public function setKwhAvgPrice($kwhAvgPrice = null)
    {
        $this->KwhAvgPrice = $kwhAvgPrice;
        return $this;
    }
    /**
     * Get DisconnectThreshold value
     * @return float
     */
    public function getDisconnectThreshold()
    {
        return $this->DisconnectThreshold;
    }
    /**
     * Set DisconnectThreshold value
     * @param float $disconnectThreshold
     * @return \SGCIS\Struct\WebProduct
     */
    public function setDisconnectThreshold($disconnectThreshold = null)
    {
        $this->DisconnectThreshold = $disconnectThreshold;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\WebProduct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\WebProduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ContractLengthName value
     * @return string|null
     */
    public function getContractLengthName()
    {
        return $this->ContractLengthName;
    }
    /**
     * Set ContractLengthName value
     * @param string $contractLengthName
     * @return \SGCIS\Struct\WebProduct
     */
    public function setContractLengthName($contractLengthName = null)
    {
        // validation for constraint: string
        if (!is_null($contractLengthName) && !is_string($contractLengthName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractLengthName)), __LINE__);
        }
        $this->ContractLengthName = $contractLengthName;
        return $this;
    }
    /**
     * Get ContractPeriodName value
     * @return string|null
     */
    public function getContractPeriodName()
    {
        return $this->ContractPeriodName;
    }
    /**
     * Set ContractPeriodName value
     * @param string $contractPeriodName
     * @return \SGCIS\Struct\WebProduct
     */
    public function setContractPeriodName($contractPeriodName = null)
    {
        // validation for constraint: string
        if (!is_null($contractPeriodName) && !is_string($contractPeriodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractPeriodName)), __LINE__);
        }
        $this->ContractPeriodName = $contractPeriodName;
        return $this;
    }
    /**
     * Get ProductDisplayName value
     * @return string|null
     */
    public function getProductDisplayName()
    {
        return $this->ProductDisplayName;
    }
    /**
     * Set ProductDisplayName value
     * @param string $productDisplayName
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayName($productDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayName) && !is_string($productDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayName)), __LINE__);
        }
        $this->ProductDisplayName = $productDisplayName;
        return $this;
    }
    /**
     * Get ProductDisplayShortDescription value
     * @return string|null
     */
    public function getProductDisplayShortDescription()
    {
        return $this->ProductDisplayShortDescription;
    }
    /**
     * Set ProductDisplayShortDescription value
     * @param string $productDisplayShortDescription
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayShortDescription($productDisplayShortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayShortDescription) && !is_string($productDisplayShortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayShortDescription)), __LINE__);
        }
        $this->ProductDisplayShortDescription = $productDisplayShortDescription;
        return $this;
    }
    /**
     * Get ProductDisplayLongDescription value
     * @return string|null
     */
    public function getProductDisplayLongDescription()
    {
        return $this->ProductDisplayLongDescription;
    }
    /**
     * Set ProductDisplayLongDescription value
     * @param string $productDisplayLongDescription
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayLongDescription($productDisplayLongDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayLongDescription) && !is_string($productDisplayLongDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayLongDescription)), __LINE__);
        }
        $this->ProductDisplayLongDescription = $productDisplayLongDescription;
        return $this;
    }
    /**
     * Get ProductDisplayCategoryName value
     * @return string|null
     */
    public function getProductDisplayCategoryName()
    {
        return $this->ProductDisplayCategoryName;
    }
    /**
     * Set ProductDisplayCategoryName value
     * @param string $productDisplayCategoryName
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayCategoryName($productDisplayCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayCategoryName) && !is_string($productDisplayCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayCategoryName)), __LINE__);
        }
        $this->ProductDisplayCategoryName = $productDisplayCategoryName;
        return $this;
    }
    /**
     * Get FeaturedImageUrl value
     * @return string|null
     */
    public function getFeaturedImageUrl()
    {
        return $this->FeaturedImageUrl;
    }
    /**
     * Set FeaturedImageUrl value
     * @param string $featuredImageUrl
     * @return \SGCIS\Struct\WebProduct
     */
    public function setFeaturedImageUrl($featuredImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($featuredImageUrl) && !is_string($featuredImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($featuredImageUrl)), __LINE__);
        }
        $this->FeaturedImageUrl = $featuredImageUrl;
        return $this;
    }
    /**
     * Get ProductDisplayFeature1 value
     * @return string|null
     */
    public function getProductDisplayFeature1()
    {
        return $this->ProductDisplayFeature1;
    }
    /**
     * Set ProductDisplayFeature1 value
     * @param string $productDisplayFeature1
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayFeature1($productDisplayFeature1 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayFeature1) && !is_string($productDisplayFeature1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayFeature1)), __LINE__);
        }
        $this->ProductDisplayFeature1 = $productDisplayFeature1;
        return $this;
    }
    /**
     * Get ProductDisplayFeature2 value
     * @return string|null
     */
    public function getProductDisplayFeature2()
    {
        return $this->ProductDisplayFeature2;
    }
    /**
     * Set ProductDisplayFeature2 value
     * @param string $productDisplayFeature2
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayFeature2($productDisplayFeature2 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayFeature2) && !is_string($productDisplayFeature2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayFeature2)), __LINE__);
        }
        $this->ProductDisplayFeature2 = $productDisplayFeature2;
        return $this;
    }
    /**
     * Get ProductDisplayFeature3 value
     * @return string|null
     */
    public function getProductDisplayFeature3()
    {
        return $this->ProductDisplayFeature3;
    }
    /**
     * Set ProductDisplayFeature3 value
     * @param string $productDisplayFeature3
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayFeature3($productDisplayFeature3 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayFeature3) && !is_string($productDisplayFeature3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayFeature3)), __LINE__);
        }
        $this->ProductDisplayFeature3 = $productDisplayFeature3;
        return $this;
    }
    /**
     * Get ProductDisplayFeature4 value
     * @return string|null
     */
    public function getProductDisplayFeature4()
    {
        return $this->ProductDisplayFeature4;
    }
    /**
     * Set ProductDisplayFeature4 value
     * @param string $productDisplayFeature4
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayFeature4($productDisplayFeature4 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayFeature4) && !is_string($productDisplayFeature4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayFeature4)), __LINE__);
        }
        $this->ProductDisplayFeature4 = $productDisplayFeature4;
        return $this;
    }
    /**
     * Get ProductDisplayFeature5 value
     * @return string|null
     */
    public function getProductDisplayFeature5()
    {
        return $this->ProductDisplayFeature5;
    }
    /**
     * Set ProductDisplayFeature5 value
     * @param string $productDisplayFeature5
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayFeature5($productDisplayFeature5 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayFeature5) && !is_string($productDisplayFeature5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayFeature5)), __LINE__);
        }
        $this->ProductDisplayFeature5 = $productDisplayFeature5;
        return $this;
    }
    /**
     * Get ProductDisplayPromotion1 value
     * @return string|null
     */
    public function getProductDisplayPromotion1()
    {
        return $this->ProductDisplayPromotion1;
    }
    /**
     * Set ProductDisplayPromotion1 value
     * @param string $productDisplayPromotion1
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayPromotion1($productDisplayPromotion1 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayPromotion1) && !is_string($productDisplayPromotion1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayPromotion1)), __LINE__);
        }
        $this->ProductDisplayPromotion1 = $productDisplayPromotion1;
        return $this;
    }
    /**
     * Get ProductDisplayPromotion2 value
     * @return string|null
     */
    public function getProductDisplayPromotion2()
    {
        return $this->ProductDisplayPromotion2;
    }
    /**
     * Set ProductDisplayPromotion2 value
     * @param string $productDisplayPromotion2
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayPromotion2($productDisplayPromotion2 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayPromotion2) && !is_string($productDisplayPromotion2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayPromotion2)), __LINE__);
        }
        $this->ProductDisplayPromotion2 = $productDisplayPromotion2;
        return $this;
    }
    /**
     * Get ProductDisplayPromotion3 value
     * @return string|null
     */
    public function getProductDisplayPromotion3()
    {
        return $this->ProductDisplayPromotion3;
    }
    /**
     * Set ProductDisplayPromotion3 value
     * @param string $productDisplayPromotion3
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDisplayPromotion3($productDisplayPromotion3 = null)
    {
        // validation for constraint: string
        if (!is_null($productDisplayPromotion3) && !is_string($productDisplayPromotion3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDisplayPromotion3)), __LINE__);
        }
        $this->ProductDisplayPromotion3 = $productDisplayPromotion3;
        return $this;
    }
    /**
     * Get ProductDocuments value
     * @return \SGCIS\Array\ArrayOfProductDocument|null
     */
    public function getProductDocuments()
    {
        return $this->ProductDocuments;
    }
    /**
     * Set ProductDocuments value
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     * @return \SGCIS\Struct\WebProduct
     */
    public function setProductDocuments(\SGCIS\Array\ArrayOfProductDocument $productDocuments = null)
    {
        $this->ProductDocuments = $productDocuments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\WebProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
