<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRequest Struct
 * @subpackage Structs
 */
class UserRequest extends ServiceRequestBase
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The UserAgentCodeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserAgentCodeID;
    /**
     * The UserAgentCompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserAgentCompanyID;
    /**
     * The SalesModelLevelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesModelLevelID;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\User
     */
    public $User;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The UserAgentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\UserAgentCode
     */
    public $UserAgentCode;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The ExternalContactNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalContactNumber;
    /**
     * Constructor method for UserRequest
     * @uses UserRequest::setUserID()
     * @uses UserRequest::setUserAgentCodeID()
     * @uses UserRequest::setUserAgentCompanyID()
     * @uses UserRequest::setSalesModelLevelID()
     * @uses UserRequest::setUserName()
     * @uses UserRequest::setUser()
     * @uses UserRequest::setEmailAddress()
     * @uses UserRequest::setUserAgentCode()
     * @uses UserRequest::setAgentID()
     * @uses UserRequest::setExternalContactNumber()
     * @param int $userID
     * @param int $userAgentCodeID
     * @param int $userAgentCompanyID
     * @param int $salesModelLevelID
     * @param string $userName
     * @param \SGCIS\Struct\User $user
     * @param string $emailAddress
     * @param \SGCIS\Struct\UserAgentCode $userAgentCode
     * @param string $agentID
     * @param string $externalContactNumber
     */
    public function __construct($userID = null, $userAgentCodeID = null, $userAgentCompanyID = null, $salesModelLevelID = null, $userName = null, \SGCIS\Struct\User $user = null, $emailAddress = null, \SGCIS\Struct\UserAgentCode $userAgentCode = null, $agentID = null, $externalContactNumber = null)
    {
        $this
            ->setUserID($userID)
            ->setUserAgentCodeID($userAgentCodeID)
            ->setUserAgentCompanyID($userAgentCompanyID)
            ->setSalesModelLevelID($salesModelLevelID)
            ->setUserName($userName)
            ->setUser($user)
            ->setEmailAddress($emailAddress)
            ->setUserAgentCode($userAgentCode)
            ->setAgentID($agentID)
            ->setExternalContactNumber($externalContactNumber);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\UserRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get UserAgentCodeID value
     * @return int
     */
    public function getUserAgentCodeID()
    {
        return $this->UserAgentCodeID;
    }
    /**
     * Set UserAgentCodeID value
     * @param int $userAgentCodeID
     * @return \SGCIS\Struct\UserRequest
     */
    public function setUserAgentCodeID($userAgentCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($userAgentCodeID) && !is_numeric($userAgentCodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userAgentCodeID)), __LINE__);
        }
        $this->UserAgentCodeID = $userAgentCodeID;
        return $this;
    }
    /**
     * Get UserAgentCompanyID value
     * @return int
     */
    public function getUserAgentCompanyID()
    {
        return $this->UserAgentCompanyID;
    }
    /**
     * Set UserAgentCompanyID value
     * @param int $userAgentCompanyID
     * @return \SGCIS\Struct\UserRequest
     */
    public function setUserAgentCompanyID($userAgentCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($userAgentCompanyID) && !is_numeric($userAgentCompanyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userAgentCompanyID)), __LINE__);
        }
        $this->UserAgentCompanyID = $userAgentCompanyID;
        return $this;
    }
    /**
     * Get SalesModelLevelID value
     * @return int
     */
    public function getSalesModelLevelID()
    {
        return $this->SalesModelLevelID;
    }
    /**
     * Set SalesModelLevelID value
     * @param int $salesModelLevelID
     * @return \SGCIS\Struct\UserRequest
     */
    public function setSalesModelLevelID($salesModelLevelID = null)
    {
        // validation for constraint: int
        if (!is_null($salesModelLevelID) && !is_numeric($salesModelLevelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesModelLevelID)), __LINE__);
        }
        $this->SalesModelLevelID = $salesModelLevelID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\UserRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get User value
     * @return \SGCIS\Struct\User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \SGCIS\Struct\User $user
     * @return \SGCIS\Struct\UserRequest
     */
    public function setUser(\SGCIS\Struct\User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \SGCIS\Struct\UserRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get UserAgentCode value
     * @return \SGCIS\Struct\UserAgentCode|null
     */
    public function getUserAgentCode()
    {
        return $this->UserAgentCode;
    }
    /**
     * Set UserAgentCode value
     * @param \SGCIS\Struct\UserAgentCode $userAgentCode
     * @return \SGCIS\Struct\UserRequest
     */
    public function setUserAgentCode(\SGCIS\Struct\UserAgentCode $userAgentCode = null)
    {
        $this->UserAgentCode = $userAgentCode;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \SGCIS\Struct\UserRequest
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get ExternalContactNumber value
     * @return string|null
     */
    public function getExternalContactNumber()
    {
        return $this->ExternalContactNumber;
    }
    /**
     * Set ExternalContactNumber value
     * @param string $externalContactNumber
     * @return \SGCIS\Struct\UserRequest
     */
    public function setExternalContactNumber($externalContactNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalContactNumber) && !is_string($externalContactNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalContactNumber)), __LINE__);
        }
        $this->ExternalContactNumber = $externalContactNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UserRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
