<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemRoleApplicationExportFunction Struct
 * @subpackage Structs
 */
class SystemRoleApplicationExportFunction extends AbstractStructBase
{
    /**
     * The SystemRoleApplicationExportFunctionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationExportFunctionID;
    /**
     * The SystemRoleApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationID;
    /**
     * The ExportFunctionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExportFunctionID;
    /**
     * The FunctionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FunctionName;
    /**
     * Constructor method for SystemRoleApplicationExportFunction
     * @uses SystemRoleApplicationExportFunction::setSystemRoleApplicationExportFunctionID()
     * @uses SystemRoleApplicationExportFunction::setSystemRoleApplicationID()
     * @uses SystemRoleApplicationExportFunction::setExportFunctionID()
     * @uses SystemRoleApplicationExportFunction::setFunctionName()
     * @param int $systemRoleApplicationExportFunctionID
     * @param int $systemRoleApplicationID
     * @param int $exportFunctionID
     * @param string $functionName
     */
    public function __construct($systemRoleApplicationExportFunctionID = null, $systemRoleApplicationID = null, $exportFunctionID = null, $functionName = null)
    {
        $this
            ->setSystemRoleApplicationExportFunctionID($systemRoleApplicationExportFunctionID)
            ->setSystemRoleApplicationID($systemRoleApplicationID)
            ->setExportFunctionID($exportFunctionID)
            ->setFunctionName($functionName);
    }
    /**
     * Get SystemRoleApplicationExportFunctionID value
     * @return int
     */
    public function getSystemRoleApplicationExportFunctionID()
    {
        return $this->SystemRoleApplicationExportFunctionID;
    }
    /**
     * Set SystemRoleApplicationExportFunctionID value
     * @param int $systemRoleApplicationExportFunctionID
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction
     */
    public function setSystemRoleApplicationExportFunctionID($systemRoleApplicationExportFunctionID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationExportFunctionID) && !is_numeric($systemRoleApplicationExportFunctionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationExportFunctionID)), __LINE__);
        }
        $this->SystemRoleApplicationExportFunctionID = $systemRoleApplicationExportFunctionID;
        return $this;
    }
    /**
     * Get SystemRoleApplicationID value
     * @return int
     */
    public function getSystemRoleApplicationID()
    {
        return $this->SystemRoleApplicationID;
    }
    /**
     * Set SystemRoleApplicationID value
     * @param int $systemRoleApplicationID
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction
     */
    public function setSystemRoleApplicationID($systemRoleApplicationID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationID) && !is_numeric($systemRoleApplicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationID)), __LINE__);
        }
        $this->SystemRoleApplicationID = $systemRoleApplicationID;
        return $this;
    }
    /**
     * Get ExportFunctionID value
     * @return int
     */
    public function getExportFunctionID()
    {
        return $this->ExportFunctionID;
    }
    /**
     * Set ExportFunctionID value
     * @param int $exportFunctionID
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction
     */
    public function setExportFunctionID($exportFunctionID = null)
    {
        // validation for constraint: int
        if (!is_null($exportFunctionID) && !is_numeric($exportFunctionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($exportFunctionID)), __LINE__);
        }
        $this->ExportFunctionID = $exportFunctionID;
        return $this;
    }
    /**
     * Get FunctionName value
     * @return string|null
     */
    public function getFunctionName()
    {
        return $this->FunctionName;
    }
    /**
     * Set FunctionName value
     * @param string $functionName
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction
     */
    public function setFunctionName($functionName = null)
    {
        // validation for constraint: string
        if (!is_null($functionName) && !is_string($functionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($functionName)), __LINE__);
        }
        $this->FunctionName = $functionName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemRoleApplicationExportFunction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
