<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemRoleApplication Struct
 * @subpackage Structs
 */
class SystemRoleApplication extends AbstractStructBase
{
    /**
     * The SystemRoleApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationID;
    /**
     * The SystemRoleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleID;
    /**
     * The ApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApplicationID;
    /**
     * The ApplicationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationName;
    /**
     * The RoleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleName;
    /**
     * The SystemRoleApplicationFunctions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemRoleApplicationFunction
     */
    public $SystemRoleApplicationFunctions;
    /**
     * The SystemRoleApplicationExportFunctions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction
     */
    public $SystemRoleApplicationExportFunctions;
    /**
     * The SystemRoleApplicationSearchEntityViews
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView
     */
    public $SystemRoleApplicationSearchEntityViews;
    /**
     * The SystemRoleApplicationWidgets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemRoleApplicationWidget
     */
    public $SystemRoleApplicationWidgets;
    /**
     * The SearchEntities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSearchEntity
     */
    public $SearchEntities;
    /**
     * The SystemRoleApplicationProducts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemApplicationRoleProduct
     */
    public $SystemRoleApplicationProducts;
    /**
     * Constructor method for SystemRoleApplication
     * @uses SystemRoleApplication::setSystemRoleApplicationID()
     * @uses SystemRoleApplication::setSystemRoleID()
     * @uses SystemRoleApplication::setApplicationID()
     * @uses SystemRoleApplication::setApplicationName()
     * @uses SystemRoleApplication::setRoleName()
     * @uses SystemRoleApplication::setSystemRoleApplicationFunctions()
     * @uses SystemRoleApplication::setSystemRoleApplicationExportFunctions()
     * @uses SystemRoleApplication::setSystemRoleApplicationSearchEntityViews()
     * @uses SystemRoleApplication::setSystemRoleApplicationWidgets()
     * @uses SystemRoleApplication::setSearchEntities()
     * @uses SystemRoleApplication::setSystemRoleApplicationProducts()
     * @param int $systemRoleApplicationID
     * @param int $systemRoleID
     * @param int $applicationID
     * @param string $applicationName
     * @param string $roleName
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationFunction $systemRoleApplicationFunctions
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction $systemRoleApplicationExportFunctions
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView $systemRoleApplicationSearchEntityViews
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationWidget $systemRoleApplicationWidgets
     * @param \SGCIS\Array\ArrayOfSearchEntity $searchEntities
     * @param \SGCIS\Array\ArrayOfSystemApplicationRoleProduct $systemRoleApplicationProducts
     */
    public function __construct($systemRoleApplicationID = null, $systemRoleID = null, $applicationID = null, $applicationName = null, $roleName = null, \SGCIS\Array\ArrayOfSystemRoleApplicationFunction $systemRoleApplicationFunctions = null, \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction $systemRoleApplicationExportFunctions = null, \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView $systemRoleApplicationSearchEntityViews = null, \SGCIS\Array\ArrayOfSystemRoleApplicationWidget $systemRoleApplicationWidgets = null, \SGCIS\Array\ArrayOfSearchEntity $searchEntities = null, \SGCIS\Array\ArrayOfSystemApplicationRoleProduct $systemRoleApplicationProducts = null)
    {
        $this
            ->setSystemRoleApplicationID($systemRoleApplicationID)
            ->setSystemRoleID($systemRoleID)
            ->setApplicationID($applicationID)
            ->setApplicationName($applicationName)
            ->setRoleName($roleName)
            ->setSystemRoleApplicationFunctions($systemRoleApplicationFunctions)
            ->setSystemRoleApplicationExportFunctions($systemRoleApplicationExportFunctions)
            ->setSystemRoleApplicationSearchEntityViews($systemRoleApplicationSearchEntityViews)
            ->setSystemRoleApplicationWidgets($systemRoleApplicationWidgets)
            ->setSearchEntities($searchEntities)
            ->setSystemRoleApplicationProducts($systemRoleApplicationProducts);
    }
    /**
     * Get SystemRoleApplicationID value
     * @return int
     */
    public function getSystemRoleApplicationID()
    {
        return $this->SystemRoleApplicationID;
    }
    /**
     * Set SystemRoleApplicationID value
     * @param int $systemRoleApplicationID
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSystemRoleApplicationID($systemRoleApplicationID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationID) && !is_numeric($systemRoleApplicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationID)), __LINE__);
        }
        $this->SystemRoleApplicationID = $systemRoleApplicationID;
        return $this;
    }
    /**
     * Get SystemRoleID value
     * @return int
     */
    public function getSystemRoleID()
    {
        return $this->SystemRoleID;
    }
    /**
     * Set SystemRoleID value
     * @param int $systemRoleID
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSystemRoleID($systemRoleID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleID) && !is_numeric($systemRoleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleID)), __LINE__);
        }
        $this->SystemRoleID = $systemRoleID;
        return $this;
    }
    /**
     * Get ApplicationID value
     * @return int
     */
    public function getApplicationID()
    {
        return $this->ApplicationID;
    }
    /**
     * Set ApplicationID value
     * @param int $applicationID
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setApplicationID($applicationID = null)
    {
        // validation for constraint: int
        if (!is_null($applicationID) && !is_numeric($applicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($applicationID)), __LINE__);
        }
        $this->ApplicationID = $applicationID;
        return $this;
    }
    /**
     * Get ApplicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->ApplicationName;
    }
    /**
     * Set ApplicationName value
     * @param string $applicationName
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationName)), __LINE__);
        }
        $this->ApplicationName = $applicationName;
        return $this;
    }
    /**
     * Get RoleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->RoleName;
    }
    /**
     * Set RoleName value
     * @param string $roleName
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleName)), __LINE__);
        }
        $this->RoleName = $roleName;
        return $this;
    }
    /**
     * Get SystemRoleApplicationFunctions value
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationFunction|null
     */
    public function getSystemRoleApplicationFunctions()
    {
        return $this->SystemRoleApplicationFunctions;
    }
    /**
     * Set SystemRoleApplicationFunctions value
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationFunction $systemRoleApplicationFunctions
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSystemRoleApplicationFunctions(\SGCIS\Array\ArrayOfSystemRoleApplicationFunction $systemRoleApplicationFunctions = null)
    {
        $this->SystemRoleApplicationFunctions = $systemRoleApplicationFunctions;
        return $this;
    }
    /**
     * Get SystemRoleApplicationExportFunctions value
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction|null
     */
    public function getSystemRoleApplicationExportFunctions()
    {
        return $this->SystemRoleApplicationExportFunctions;
    }
    /**
     * Set SystemRoleApplicationExportFunctions value
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction $systemRoleApplicationExportFunctions
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSystemRoleApplicationExportFunctions(\SGCIS\Array\ArrayOfSystemRoleApplicationExportFunction $systemRoleApplicationExportFunctions = null)
    {
        $this->SystemRoleApplicationExportFunctions = $systemRoleApplicationExportFunctions;
        return $this;
    }
    /**
     * Get SystemRoleApplicationSearchEntityViews value
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView|null
     */
    public function getSystemRoleApplicationSearchEntityViews()
    {
        return $this->SystemRoleApplicationSearchEntityViews;
    }
    /**
     * Set SystemRoleApplicationSearchEntityViews value
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView $systemRoleApplicationSearchEntityViews
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSystemRoleApplicationSearchEntityViews(\SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView $systemRoleApplicationSearchEntityViews = null)
    {
        $this->SystemRoleApplicationSearchEntityViews = $systemRoleApplicationSearchEntityViews;
        return $this;
    }
    /**
     * Get SystemRoleApplicationWidgets value
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationWidget|null
     */
    public function getSystemRoleApplicationWidgets()
    {
        return $this->SystemRoleApplicationWidgets;
    }
    /**
     * Set SystemRoleApplicationWidgets value
     * @param \SGCIS\Array\ArrayOfSystemRoleApplicationWidget $systemRoleApplicationWidgets
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSystemRoleApplicationWidgets(\SGCIS\Array\ArrayOfSystemRoleApplicationWidget $systemRoleApplicationWidgets = null)
    {
        $this->SystemRoleApplicationWidgets = $systemRoleApplicationWidgets;
        return $this;
    }
    /**
     * Get SearchEntities value
     * @return \SGCIS\Array\ArrayOfSearchEntity|null
     */
    public function getSearchEntities()
    {
        return $this->SearchEntities;
    }
    /**
     * Set SearchEntities value
     * @param \SGCIS\Array\ArrayOfSearchEntity $searchEntities
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSearchEntities(\SGCIS\Array\ArrayOfSearchEntity $searchEntities = null)
    {
        $this->SearchEntities = $searchEntities;
        return $this;
    }
    /**
     * Get SystemRoleApplicationProducts value
     * @return \SGCIS\Array\ArrayOfSystemApplicationRoleProduct|null
     */
    public function getSystemRoleApplicationProducts()
    {
        return $this->SystemRoleApplicationProducts;
    }
    /**
     * Set SystemRoleApplicationProducts value
     * @param \SGCIS\Array\ArrayOfSystemApplicationRoleProduct $systemRoleApplicationProducts
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public function setSystemRoleApplicationProducts(\SGCIS\Array\ArrayOfSystemApplicationRoleProduct $systemRoleApplicationProducts = null)
    {
        $this->SystemRoleApplicationProducts = $systemRoleApplicationProducts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemRoleApplication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
