<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemApplicationRoleProduct Struct
 * @subpackage Structs
 */
class SystemApplicationRoleProduct extends AbstractStructBase
{
    /**
     * The SystemApplicationRoleProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemApplicationRoleProductID;
    /**
     * The SystemRoleApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for SystemApplicationRoleProduct
     * @uses SystemApplicationRoleProduct::setSystemApplicationRoleProductID()
     * @uses SystemApplicationRoleProduct::setSystemRoleApplicationID()
     * @uses SystemApplicationRoleProduct::setProductID()
     * @uses SystemApplicationRoleProduct::setName()
     * @uses SystemApplicationRoleProduct::setDescription()
     * @param int $systemApplicationRoleProductID
     * @param int $systemRoleApplicationID
     * @param int $productID
     * @param string $name
     * @param string $description
     */
    public function __construct($systemApplicationRoleProductID = null, $systemRoleApplicationID = null, $productID = null, $name = null, $description = null)
    {
        $this
            ->setSystemApplicationRoleProductID($systemApplicationRoleProductID)
            ->setSystemRoleApplicationID($systemRoleApplicationID)
            ->setProductID($productID)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get SystemApplicationRoleProductID value
     * @return int
     */
    public function getSystemApplicationRoleProductID()
    {
        return $this->SystemApplicationRoleProductID;
    }
    /**
     * Set SystemApplicationRoleProductID value
     * @param int $systemApplicationRoleProductID
     * @return \SGCIS\Struct\SystemApplicationRoleProduct
     */
    public function setSystemApplicationRoleProductID($systemApplicationRoleProductID = null)
    {
        // validation for constraint: int
        if (!is_null($systemApplicationRoleProductID) && !is_numeric($systemApplicationRoleProductID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemApplicationRoleProductID)), __LINE__);
        }
        $this->SystemApplicationRoleProductID = $systemApplicationRoleProductID;
        return $this;
    }
    /**
     * Get SystemRoleApplicationID value
     * @return int
     */
    public function getSystemRoleApplicationID()
    {
        return $this->SystemRoleApplicationID;
    }
    /**
     * Set SystemRoleApplicationID value
     * @param int $systemRoleApplicationID
     * @return \SGCIS\Struct\SystemApplicationRoleProduct
     */
    public function setSystemRoleApplicationID($systemRoleApplicationID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationID) && !is_numeric($systemRoleApplicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationID)), __LINE__);
        }
        $this->SystemRoleApplicationID = $systemRoleApplicationID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\SystemApplicationRoleProduct
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\SystemApplicationRoleProduct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\SystemApplicationRoleProduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemApplicationRoleProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
