<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Stream Struct
 * @subpackage Structs
 */
abstract class Stream extends MarshalByRefObject
{
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Position;
    /**
     * The ReadTimeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReadTimeout;
    /**
     * The WriteTimeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WriteTimeout;
    /**
     * Constructor method for Stream
     * @uses Stream::setPosition()
     * @uses Stream::setReadTimeout()
     * @uses Stream::setWriteTimeout()
     * @param int $position
     * @param int $readTimeout
     * @param int $writeTimeout
     */
    public function __construct($position = null, $readTimeout = null, $writeTimeout = null)
    {
        $this
            ->setPosition($position)
            ->setReadTimeout($readTimeout)
            ->setWriteTimeout($writeTimeout);
    }
    /**
     * Get Position value
     * @return int
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \SGCIS\Struct\Stream
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get ReadTimeout value
     * @return int
     */
    public function getReadTimeout()
    {
        return $this->ReadTimeout;
    }
    /**
     * Set ReadTimeout value
     * @param int $readTimeout
     * @return \SGCIS\Struct\Stream
     */
    public function setReadTimeout($readTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($readTimeout) && !is_numeric($readTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($readTimeout)), __LINE__);
        }
        $this->ReadTimeout = $readTimeout;
        return $this;
    }
    /**
     * Get WriteTimeout value
     * @return int
     */
    public function getWriteTimeout()
    {
        return $this->WriteTimeout;
    }
    /**
     * Set WriteTimeout value
     * @param int $writeTimeout
     * @return \SGCIS\Struct\Stream
     */
    public function setWriteTimeout($writeTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($writeTimeout) && !is_numeric($writeTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($writeTimeout)), __LINE__);
        }
        $this->WriteTimeout = $writeTimeout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Stream
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
