<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SnapshotARReport Struct
 * @subpackage Structs
 */
class SnapshotARReport extends AbstractStructBase
{
    /**
     * The SnapshotARReportID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SnapshotARReportID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The CurrentDueAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentDueAmount;
    /**
     * The Days_0_10
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Days_0_10;
    /**
     * The Days_11_30
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Days_11_30;
    /**
     * The Days_31_60
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Days_31_60;
    /**
     * The Days_61_90
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Days_61_90;
    /**
     * The Days_91_120
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Days_91_120;
    /**
     * The Days_121
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Days_121;
    /**
     * The DaysPastDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DaysPastDue;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The Unbilled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Unbilled;
    /**
     * The WriteOff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WriteOff;
    /**
     * Constructor method for SnapshotARReport
     * @uses SnapshotARReport::setSnapshotARReportID()
     * @uses SnapshotARReport::setAccountID()
     * @uses SnapshotARReport::setCurrentDueAmount()
     * @uses SnapshotARReport::setDays_0_10()
     * @uses SnapshotARReport::setDays_11_30()
     * @uses SnapshotARReport::setDays_31_60()
     * @uses SnapshotARReport::setDays_61_90()
     * @uses SnapshotARReport::setDays_91_120()
     * @uses SnapshotARReport::setDays_121()
     * @uses SnapshotARReport::setDaysPastDue()
     * @uses SnapshotARReport::setCreateDate()
     * @uses SnapshotARReport::setUnbilled()
     * @uses SnapshotARReport::setWriteOff()
     * @param int $snapshotARReportID
     * @param int $accountID
     * @param float $currentDueAmount
     * @param float $days_0_10
     * @param float $days_11_30
     * @param float $days_31_60
     * @param float $days_61_90
     * @param float $days_91_120
     * @param float $days_121
     * @param int $daysPastDue
     * @param string $createDate
     * @param float $unbilled
     * @param float $writeOff
     */
    public function __construct($snapshotARReportID = null, $accountID = null, $currentDueAmount = null, $days_0_10 = null, $days_11_30 = null, $days_31_60 = null, $days_61_90 = null, $days_91_120 = null, $days_121 = null, $daysPastDue = null, $createDate = null, $unbilled = null, $writeOff = null)
    {
        $this
            ->setSnapshotARReportID($snapshotARReportID)
            ->setAccountID($accountID)
            ->setCurrentDueAmount($currentDueAmount)
            ->setDays_0_10($days_0_10)
            ->setDays_11_30($days_11_30)
            ->setDays_31_60($days_31_60)
            ->setDays_61_90($days_61_90)
            ->setDays_91_120($days_91_120)
            ->setDays_121($days_121)
            ->setDaysPastDue($daysPastDue)
            ->setCreateDate($createDate)
            ->setUnbilled($unbilled)
            ->setWriteOff($writeOff);
    }
    /**
     * Get SnapshotARReportID value
     * @return int
     */
    public function getSnapshotARReportID()
    {
        return $this->SnapshotARReportID;
    }
    /**
     * Set SnapshotARReportID value
     * @param int $snapshotARReportID
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setSnapshotARReportID($snapshotARReportID = null)
    {
        // validation for constraint: int
        if (!is_null($snapshotARReportID) && !is_numeric($snapshotARReportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($snapshotARReportID)), __LINE__);
        }
        $this->SnapshotARReportID = $snapshotARReportID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get CurrentDueAmount value
     * @return float
     */
    public function getCurrentDueAmount()
    {
        return $this->CurrentDueAmount;
    }
    /**
     * Set CurrentDueAmount value
     * @param float $currentDueAmount
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setCurrentDueAmount($currentDueAmount = null)
    {
        $this->CurrentDueAmount = $currentDueAmount;
        return $this;
    }
    /**
     * Get Days_0_10 value
     * @return float
     */
    public function getDays_0_10()
    {
        return $this->Days_0_10;
    }
    /**
     * Set Days_0_10 value
     * @param float $days_0_10
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setDays_0_10($days_0_10 = null)
    {
        $this->Days_0_10 = $days_0_10;
        return $this;
    }
    /**
     * Get Days_11_30 value
     * @return float
     */
    public function getDays_11_30()
    {
        return $this->Days_11_30;
    }
    /**
     * Set Days_11_30 value
     * @param float $days_11_30
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setDays_11_30($days_11_30 = null)
    {
        $this->Days_11_30 = $days_11_30;
        return $this;
    }
    /**
     * Get Days_31_60 value
     * @return float
     */
    public function getDays_31_60()
    {
        return $this->Days_31_60;
    }
    /**
     * Set Days_31_60 value
     * @param float $days_31_60
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setDays_31_60($days_31_60 = null)
    {
        $this->Days_31_60 = $days_31_60;
        return $this;
    }
    /**
     * Get Days_61_90 value
     * @return float
     */
    public function getDays_61_90()
    {
        return $this->Days_61_90;
    }
    /**
     * Set Days_61_90 value
     * @param float $days_61_90
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setDays_61_90($days_61_90 = null)
    {
        $this->Days_61_90 = $days_61_90;
        return $this;
    }
    /**
     * Get Days_91_120 value
     * @return float
     */
    public function getDays_91_120()
    {
        return $this->Days_91_120;
    }
    /**
     * Set Days_91_120 value
     * @param float $days_91_120
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setDays_91_120($days_91_120 = null)
    {
        $this->Days_91_120 = $days_91_120;
        return $this;
    }
    /**
     * Get Days_121 value
     * @return float
     */
    public function getDays_121()
    {
        return $this->Days_121;
    }
    /**
     * Set Days_121 value
     * @param float $days_121
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setDays_121($days_121 = null)
    {
        $this->Days_121 = $days_121;
        return $this;
    }
    /**
     * Get DaysPastDue value
     * @return int
     */
    public function getDaysPastDue()
    {
        return $this->DaysPastDue;
    }
    /**
     * Set DaysPastDue value
     * @param int $daysPastDue
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setDaysPastDue($daysPastDue = null)
    {
        // validation for constraint: int
        if (!is_null($daysPastDue) && !is_numeric($daysPastDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($daysPastDue)), __LINE__);
        }
        $this->DaysPastDue = $daysPastDue;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get Unbilled value
     * @return float
     */
    public function getUnbilled()
    {
        return $this->Unbilled;
    }
    /**
     * Set Unbilled value
     * @param float $unbilled
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setUnbilled($unbilled = null)
    {
        $this->Unbilled = $unbilled;
        return $this;
    }
    /**
     * Get WriteOff value
     * @return float
     */
    public function getWriteOff()
    {
        return $this->WriteOff;
    }
    /**
     * Set WriteOff value
     * @param float $writeOff
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public function setWriteOff($writeOff = null)
    {
        $this->WriteOff = $writeOff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SnapshotARReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
