<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePointMeterGroup Struct
 * @subpackage Structs
 */
class ServicePointMeterGroup extends AbstractStructBase
{
    /**
     * The ServicePointMeterGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterGroupID;
    /**
     * The ServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointID;
    /**
     * The MeterGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterGroupID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for ServicePointMeterGroup
     * @uses ServicePointMeterGroup::setServicePointMeterGroupID()
     * @uses ServicePointMeterGroup::setServicePointID()
     * @uses ServicePointMeterGroup::setMeterGroupID()
     * @uses ServicePointMeterGroup::setCreateDate()
     * @param int $servicePointMeterGroupID
     * @param int $servicePointID
     * @param int $meterGroupID
     * @param string $createDate
     */
    public function __construct($servicePointMeterGroupID = null, $servicePointID = null, $meterGroupID = null, $createDate = null)
    {
        $this
            ->setServicePointMeterGroupID($servicePointMeterGroupID)
            ->setServicePointID($servicePointID)
            ->setMeterGroupID($meterGroupID)
            ->setCreateDate($createDate);
    }
    /**
     * Get ServicePointMeterGroupID value
     * @return int
     */
    public function getServicePointMeterGroupID()
    {
        return $this->ServicePointMeterGroupID;
    }
    /**
     * Set ServicePointMeterGroupID value
     * @param int $servicePointMeterGroupID
     * @return \SGCIS\Struct\ServicePointMeterGroup
     */
    public function setServicePointMeterGroupID($servicePointMeterGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterGroupID) && !is_numeric($servicePointMeterGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterGroupID)), __LINE__);
        }
        $this->ServicePointMeterGroupID = $servicePointMeterGroupID;
        return $this;
    }
    /**
     * Get ServicePointID value
     * @return int
     */
    public function getServicePointID()
    {
        return $this->ServicePointID;
    }
    /**
     * Set ServicePointID value
     * @param int $servicePointID
     * @return \SGCIS\Struct\ServicePointMeterGroup
     */
    public function setServicePointID($servicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointID) && !is_numeric($servicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointID)), __LINE__);
        }
        $this->ServicePointID = $servicePointID;
        return $this;
    }
    /**
     * Get MeterGroupID value
     * @return int
     */
    public function getMeterGroupID()
    {
        return $this->MeterGroupID;
    }
    /**
     * Set MeterGroupID value
     * @param int $meterGroupID
     * @return \SGCIS\Struct\ServicePointMeterGroup
     */
    public function setMeterGroupID($meterGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($meterGroupID) && !is_numeric($meterGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterGroupID)), __LINE__);
        }
        $this->MeterGroupID = $meterGroupID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ServicePointMeterGroup
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServicePointMeterGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
