<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOrder Struct
 * @subpackage Structs
 */
class ServiceOrder extends BaseDTO
{
    /**
     * The ServiceOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AccountBalance;
    /**
     * The AccountBillingTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountBillingTypeID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The ServiceOrderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderTypeID;
    /**
     * The ServiceOrderStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderStatusID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The DistributionPointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionPointID;
    /**
     * The OpenDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OpenDate;
    /**
     * The ServiceRequestedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceRequestedDate;
    /**
     * The ActualServiceDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ActualServiceDate;
    /**
     * The NotBeforeDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NotBeforeDate;
    /**
     * The NotBeforeTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NotBeforeTime;
    /**
     * The CycleServiceLocationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CycleServiceLocationStatus;
    /**
     * The PremiumDisconnectLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PremiumDisconnectLocationID;
    /**
     * The IsNewService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNewService;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The AccountDepositID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDepositID;
    /**
     * The PaymentArrangementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementID;
    /**
     * The ServiceOrderPriorityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderPriorityID;
    /**
     * The IsSpecialNeeds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSpecialNeeds;
    /**
     * The IsCallAhead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCallAhead;
    /**
     * The IsFridayDisconnect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFridayDisconnect;
    /**
     * The IsNotificationWaiverOptOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNotificationWaiverOptOut;
    /**
     * The IsOnEnergyCreditProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOnEnergyCreditProgram;
    /**
     * The ServiceOrderPurposeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderPurposeID;
    /**
     * The ServiceOrderSubPurposeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderSubPurposeID;
    /**
     * The ServiceOrderReasonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderReasonID;
    /**
     * The ServiceOrderChangeReasonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderChangeReasonID;
    /**
     * The ScheduledDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ScheduledDate;
    /**
     * The LastPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LastPaymentAmount;
    /**
     * The LastPaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastPaymentDate;
    /**
     * The PastDueBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PastDueBalance;
    /**
     * The IsInWeatherMoratorium
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInWeatherMoratorium;
    /**
     * The IsOnPaymentArrangement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOnPaymentArrangement;
    /**
     * The IsOnDPP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOnDPP;
    /**
     * The IsOnPaymentExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOnPaymentExtension;
    /**
     * The IsAccountProtection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAccountProtection;
    /**
     * The PreferedLanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PreferedLanguageID;
    /**
     * The AccountBillingTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountBillingTypeName;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The LineOfBusiness
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineOfBusiness;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The OpenedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpenedByUserName;
    /**
     * The SourceServiceOrderTrackingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceServiceOrderTrackingNumber;
    /**
     * The TrackingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The ContactPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPhone;
    /**
     * The CustomerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The PremiumDisconnectLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PremiumDisconnectLocation;
    /**
     * The MeterNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterNumber;
    /**
     * The ServiceOrderPurposeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceOrderPurposeName;
    /**
     * The ServiceOrderSubPurposeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceOrderSubPurposeName;
    /**
     * The ServiceOrderReasonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceOrderReasonName;
    /**
     * The ServiceOrderChangeReasonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceOrderChangeReasonName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ServiceOrderTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceOrderTypeName;
    /**
     * The ServiceOrderStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceOrderStatusName;
    /**
     * The ServiceOrderPriorityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceOrderPriorityName;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The ServicePointStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServicePointStatusName;
    /**
     * The DNPNoticeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DNPNoticeType;
    /**
     * The PersonPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonPhone;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServiceOrderNote
     */
    public $Notes;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The PreferedLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreferedLanguage;
    /**
     * Constructor method for ServiceOrder
     * @uses ServiceOrder::setServiceOrderID()
     * @uses ServiceOrder::setAccountID()
     * @uses ServiceOrder::setAccountBalance()
     * @uses ServiceOrder::setAccountBillingTypeID()
     * @uses ServiceOrder::setAccountServicePointID()
     * @uses ServiceOrder::setServiceOrderTypeID()
     * @uses ServiceOrder::setServiceOrderStatusID()
     * @uses ServiceOrder::setDistributionServiceProviderID()
     * @uses ServiceOrder::setDistributionPointID()
     * @uses ServiceOrder::setOpenDate()
     * @uses ServiceOrder::setServiceRequestedDate()
     * @uses ServiceOrder::setActualServiceDate()
     * @uses ServiceOrder::setNotBeforeDate()
     * @uses ServiceOrder::setNotBeforeTime()
     * @uses ServiceOrder::setCycleServiceLocationStatus()
     * @uses ServiceOrder::setPremiumDisconnectLocationID()
     * @uses ServiceOrder::setIsNewService()
     * @uses ServiceOrder::setBillID()
     * @uses ServiceOrder::setAccountDepositID()
     * @uses ServiceOrder::setPaymentArrangementID()
     * @uses ServiceOrder::setServiceOrderPriorityID()
     * @uses ServiceOrder::setIsSpecialNeeds()
     * @uses ServiceOrder::setIsCallAhead()
     * @uses ServiceOrder::setIsFridayDisconnect()
     * @uses ServiceOrder::setIsNotificationWaiverOptOut()
     * @uses ServiceOrder::setIsOnEnergyCreditProgram()
     * @uses ServiceOrder::setServiceOrderPurposeID()
     * @uses ServiceOrder::setServiceOrderSubPurposeID()
     * @uses ServiceOrder::setServiceOrderReasonID()
     * @uses ServiceOrder::setServiceOrderChangeReasonID()
     * @uses ServiceOrder::setScheduledDate()
     * @uses ServiceOrder::setLastPaymentAmount()
     * @uses ServiceOrder::setLastPaymentDate()
     * @uses ServiceOrder::setPastDueBalance()
     * @uses ServiceOrder::setIsInWeatherMoratorium()
     * @uses ServiceOrder::setIsOnPaymentArrangement()
     * @uses ServiceOrder::setIsOnDPP()
     * @uses ServiceOrder::setIsOnPaymentExtension()
     * @uses ServiceOrder::setIsAccountProtection()
     * @uses ServiceOrder::setPreferedLanguageID()
     * @uses ServiceOrder::setAccountBillingTypeName()
     * @uses ServiceOrder::setProductName()
     * @uses ServiceOrder::setLineOfBusiness()
     * @uses ServiceOrder::setText()
     * @uses ServiceOrder::setOpenedByUserName()
     * @uses ServiceOrder::setSourceServiceOrderTrackingNumber()
     * @uses ServiceOrder::setTrackingNumber()
     * @uses ServiceOrder::setContactName()
     * @uses ServiceOrder::setContactPhone()
     * @uses ServiceOrder::setCustomerName()
     * @uses ServiceOrder::setPremiumDisconnectLocation()
     * @uses ServiceOrder::setMeterNumber()
     * @uses ServiceOrder::setServiceOrderPurposeName()
     * @uses ServiceOrder::setServiceOrderSubPurposeName()
     * @uses ServiceOrder::setServiceOrderReasonName()
     * @uses ServiceOrder::setServiceOrderChangeReasonName()
     * @uses ServiceOrder::setAccountNumber()
     * @uses ServiceOrder::setServiceOrderTypeName()
     * @uses ServiceOrder::setServiceOrderStatusName()
     * @uses ServiceOrder::setServiceOrderPriorityName()
     * @uses ServiceOrder::setDistributionServiceProviderName()
     * @uses ServiceOrder::setServiceProviderIdentifier()
     * @uses ServiceOrder::setServicePointStatusName()
     * @uses ServiceOrder::setDNPNoticeType()
     * @uses ServiceOrder::setPersonPhone()
     * @uses ServiceOrder::setNotes()
     * @uses ServiceOrder::setAccountStatusName()
     * @uses ServiceOrder::setAddress1()
     * @uses ServiceOrder::setCity()
     * @uses ServiceOrder::setState()
     * @uses ServiceOrder::setZipCode()
     * @uses ServiceOrder::setPreferedLanguage()
     * @param int $serviceOrderID
     * @param int $accountID
     * @param float $accountBalance
     * @param int $accountBillingTypeID
     * @param int $accountServicePointID
     * @param int $serviceOrderTypeID
     * @param int $serviceOrderStatusID
     * @param int $distributionServiceProviderID
     * @param int $distributionPointID
     * @param string $openDate
     * @param string $serviceRequestedDate
     * @param string $actualServiceDate
     * @param string $notBeforeDate
     * @param int $notBeforeTime
     * @param bool $cycleServiceLocationStatus
     * @param int $premiumDisconnectLocationID
     * @param bool $isNewService
     * @param int $billID
     * @param int $accountDepositID
     * @param int $paymentArrangementID
     * @param int $serviceOrderPriorityID
     * @param bool $isSpecialNeeds
     * @param bool $isCallAhead
     * @param bool $isFridayDisconnect
     * @param bool $isNotificationWaiverOptOut
     * @param bool $isOnEnergyCreditProgram
     * @param int $serviceOrderPurposeID
     * @param int $serviceOrderSubPurposeID
     * @param int $serviceOrderReasonID
     * @param int $serviceOrderChangeReasonID
     * @param string $scheduledDate
     * @param float $lastPaymentAmount
     * @param string $lastPaymentDate
     * @param float $pastDueBalance
     * @param bool $isInWeatherMoratorium
     * @param bool $isOnPaymentArrangement
     * @param bool $isOnDPP
     * @param bool $isOnPaymentExtension
     * @param bool $isAccountProtection
     * @param int $preferedLanguageID
     * @param string $accountBillingTypeName
     * @param string $productName
     * @param string $lineOfBusiness
     * @param string $text
     * @param string $openedByUserName
     * @param string $sourceServiceOrderTrackingNumber
     * @param string $trackingNumber
     * @param string $contactName
     * @param string $contactPhone
     * @param string $customerName
     * @param string $premiumDisconnectLocation
     * @param string $meterNumber
     * @param string $serviceOrderPurposeName
     * @param string $serviceOrderSubPurposeName
     * @param string $serviceOrderReasonName
     * @param string $serviceOrderChangeReasonName
     * @param string $accountNumber
     * @param string $serviceOrderTypeName
     * @param string $serviceOrderStatusName
     * @param string $serviceOrderPriorityName
     * @param string $distributionServiceProviderName
     * @param string $serviceProviderIdentifier
     * @param string $servicePointStatusName
     * @param string $dNPNoticeType
     * @param string $personPhone
     * @param \SGCIS\Array\ArrayOfServiceOrderNote $notes
     * @param string $accountStatusName
     * @param string $address1
     * @param string $city
     * @param string $state
     * @param string $zipCode
     * @param string $preferedLanguage
     */
    public function __construct($serviceOrderID = null, $accountID = null, $accountBalance = null, $accountBillingTypeID = null, $accountServicePointID = null, $serviceOrderTypeID = null, $serviceOrderStatusID = null, $distributionServiceProviderID = null, $distributionPointID = null, $openDate = null, $serviceRequestedDate = null, $actualServiceDate = null, $notBeforeDate = null, $notBeforeTime = null, $cycleServiceLocationStatus = null, $premiumDisconnectLocationID = null, $isNewService = null, $billID = null, $accountDepositID = null, $paymentArrangementID = null, $serviceOrderPriorityID = null, $isSpecialNeeds = null, $isCallAhead = null, $isFridayDisconnect = null, $isNotificationWaiverOptOut = null, $isOnEnergyCreditProgram = null, $serviceOrderPurposeID = null, $serviceOrderSubPurposeID = null, $serviceOrderReasonID = null, $serviceOrderChangeReasonID = null, $scheduledDate = null, $lastPaymentAmount = null, $lastPaymentDate = null, $pastDueBalance = null, $isInWeatherMoratorium = null, $isOnPaymentArrangement = null, $isOnDPP = null, $isOnPaymentExtension = null, $isAccountProtection = null, $preferedLanguageID = null, $accountBillingTypeName = null, $productName = null, $lineOfBusiness = null, $text = null, $openedByUserName = null, $sourceServiceOrderTrackingNumber = null, $trackingNumber = null, $contactName = null, $contactPhone = null, $customerName = null, $premiumDisconnectLocation = null, $meterNumber = null, $serviceOrderPurposeName = null, $serviceOrderSubPurposeName = null, $serviceOrderReasonName = null, $serviceOrderChangeReasonName = null, $accountNumber = null, $serviceOrderTypeName = null, $serviceOrderStatusName = null, $serviceOrderPriorityName = null, $distributionServiceProviderName = null, $serviceProviderIdentifier = null, $servicePointStatusName = null, $dNPNoticeType = null, $personPhone = null, \SGCIS\Array\ArrayOfServiceOrderNote $notes = null, $accountStatusName = null, $address1 = null, $city = null, $state = null, $zipCode = null, $preferedLanguage = null)
    {
        $this
            ->setServiceOrderID($serviceOrderID)
            ->setAccountID($accountID)
            ->setAccountBalance($accountBalance)
            ->setAccountBillingTypeID($accountBillingTypeID)
            ->setAccountServicePointID($accountServicePointID)
            ->setServiceOrderTypeID($serviceOrderTypeID)
            ->setServiceOrderStatusID($serviceOrderStatusID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setDistributionPointID($distributionPointID)
            ->setOpenDate($openDate)
            ->setServiceRequestedDate($serviceRequestedDate)
            ->setActualServiceDate($actualServiceDate)
            ->setNotBeforeDate($notBeforeDate)
            ->setNotBeforeTime($notBeforeTime)
            ->setCycleServiceLocationStatus($cycleServiceLocationStatus)
            ->setPremiumDisconnectLocationID($premiumDisconnectLocationID)
            ->setIsNewService($isNewService)
            ->setBillID($billID)
            ->setAccountDepositID($accountDepositID)
            ->setPaymentArrangementID($paymentArrangementID)
            ->setServiceOrderPriorityID($serviceOrderPriorityID)
            ->setIsSpecialNeeds($isSpecialNeeds)
            ->setIsCallAhead($isCallAhead)
            ->setIsFridayDisconnect($isFridayDisconnect)
            ->setIsNotificationWaiverOptOut($isNotificationWaiverOptOut)
            ->setIsOnEnergyCreditProgram($isOnEnergyCreditProgram)
            ->setServiceOrderPurposeID($serviceOrderPurposeID)
            ->setServiceOrderSubPurposeID($serviceOrderSubPurposeID)
            ->setServiceOrderReasonID($serviceOrderReasonID)
            ->setServiceOrderChangeReasonID($serviceOrderChangeReasonID)
            ->setScheduledDate($scheduledDate)
            ->setLastPaymentAmount($lastPaymentAmount)
            ->setLastPaymentDate($lastPaymentDate)
            ->setPastDueBalance($pastDueBalance)
            ->setIsInWeatherMoratorium($isInWeatherMoratorium)
            ->setIsOnPaymentArrangement($isOnPaymentArrangement)
            ->setIsOnDPP($isOnDPP)
            ->setIsOnPaymentExtension($isOnPaymentExtension)
            ->setIsAccountProtection($isAccountProtection)
            ->setPreferedLanguageID($preferedLanguageID)
            ->setAccountBillingTypeName($accountBillingTypeName)
            ->setProductName($productName)
            ->setLineOfBusiness($lineOfBusiness)
            ->setText($text)
            ->setOpenedByUserName($openedByUserName)
            ->setSourceServiceOrderTrackingNumber($sourceServiceOrderTrackingNumber)
            ->setTrackingNumber($trackingNumber)
            ->setContactName($contactName)
            ->setContactPhone($contactPhone)
            ->setCustomerName($customerName)
            ->setPremiumDisconnectLocation($premiumDisconnectLocation)
            ->setMeterNumber($meterNumber)
            ->setServiceOrderPurposeName($serviceOrderPurposeName)
            ->setServiceOrderSubPurposeName($serviceOrderSubPurposeName)
            ->setServiceOrderReasonName($serviceOrderReasonName)
            ->setServiceOrderChangeReasonName($serviceOrderChangeReasonName)
            ->setAccountNumber($accountNumber)
            ->setServiceOrderTypeName($serviceOrderTypeName)
            ->setServiceOrderStatusName($serviceOrderStatusName)
            ->setServiceOrderPriorityName($serviceOrderPriorityName)
            ->setDistributionServiceProviderName($distributionServiceProviderName)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setServicePointStatusName($servicePointStatusName)
            ->setDNPNoticeType($dNPNoticeType)
            ->setPersonPhone($personPhone)
            ->setNotes($notes)
            ->setAccountStatusName($accountStatusName)
            ->setAddress1($address1)
            ->setCity($city)
            ->setState($state)
            ->setZipCode($zipCode)
            ->setPreferedLanguage($preferedLanguage);
    }
    /**
     * Get ServiceOrderID value
     * @return int
     */
    public function getServiceOrderID()
    {
        return $this->ServiceOrderID;
    }
    /**
     * Set ServiceOrderID value
     * @param int $serviceOrderID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderID($serviceOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderID) && !is_numeric($serviceOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderID)), __LINE__);
        }
        $this->ServiceOrderID = $serviceOrderID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get AccountBillingTypeID value
     * @return int
     */
    public function getAccountBillingTypeID()
    {
        return $this->AccountBillingTypeID;
    }
    /**
     * Set AccountBillingTypeID value
     * @param int $accountBillingTypeID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountBillingTypeID($accountBillingTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountBillingTypeID) && !is_numeric($accountBillingTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountBillingTypeID)), __LINE__);
        }
        $this->AccountBillingTypeID = $accountBillingTypeID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get ServiceOrderTypeID value
     * @return int
     */
    public function getServiceOrderTypeID()
    {
        return $this->ServiceOrderTypeID;
    }
    /**
     * Set ServiceOrderTypeID value
     * @param int $serviceOrderTypeID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderTypeID($serviceOrderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderTypeID) && !is_numeric($serviceOrderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderTypeID)), __LINE__);
        }
        $this->ServiceOrderTypeID = $serviceOrderTypeID;
        return $this;
    }
    /**
     * Get ServiceOrderStatusID value
     * @return int
     */
    public function getServiceOrderStatusID()
    {
        return $this->ServiceOrderStatusID;
    }
    /**
     * Set ServiceOrderStatusID value
     * @param int $serviceOrderStatusID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderStatusID($serviceOrderStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderStatusID) && !is_numeric($serviceOrderStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderStatusID)), __LINE__);
        }
        $this->ServiceOrderStatusID = $serviceOrderStatusID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get DistributionPointID value
     * @return int
     */
    public function getDistributionPointID()
    {
        return $this->DistributionPointID;
    }
    /**
     * Set DistributionPointID value
     * @param int $distributionPointID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setDistributionPointID($distributionPointID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPointID) && !is_numeric($distributionPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionPointID)), __LINE__);
        }
        $this->DistributionPointID = $distributionPointID;
        return $this;
    }
    /**
     * Get OpenDate value
     * @return string
     */
    public function getOpenDate()
    {
        return $this->OpenDate;
    }
    /**
     * Set OpenDate value
     * @param string $openDate
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setOpenDate($openDate = null)
    {
        // validation for constraint: string
        if (!is_null($openDate) && !is_string($openDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openDate)), __LINE__);
        }
        $this->OpenDate = $openDate;
        return $this;
    }
    /**
     * Get ServiceRequestedDate value
     * @return string
     */
    public function getServiceRequestedDate()
    {
        return $this->ServiceRequestedDate;
    }
    /**
     * Set ServiceRequestedDate value
     * @param string $serviceRequestedDate
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceRequestedDate($serviceRequestedDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestedDate) && !is_string($serviceRequestedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceRequestedDate)), __LINE__);
        }
        $this->ServiceRequestedDate = $serviceRequestedDate;
        return $this;
    }
    /**
     * Get ActualServiceDate value
     * @return string
     */
    public function getActualServiceDate()
    {
        return $this->ActualServiceDate;
    }
    /**
     * Set ActualServiceDate value
     * @param string $actualServiceDate
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setActualServiceDate($actualServiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualServiceDate) && !is_string($actualServiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualServiceDate)), __LINE__);
        }
        $this->ActualServiceDate = $actualServiceDate;
        return $this;
    }
    /**
     * Get NotBeforeDate value
     * @return string
     */
    public function getNotBeforeDate()
    {
        return $this->NotBeforeDate;
    }
    /**
     * Set NotBeforeDate value
     * @param string $notBeforeDate
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setNotBeforeDate($notBeforeDate = null)
    {
        // validation for constraint: string
        if (!is_null($notBeforeDate) && !is_string($notBeforeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notBeforeDate)), __LINE__);
        }
        $this->NotBeforeDate = $notBeforeDate;
        return $this;
    }
    /**
     * Get NotBeforeTime value
     * @return int
     */
    public function getNotBeforeTime()
    {
        return $this->NotBeforeTime;
    }
    /**
     * Set NotBeforeTime value
     * @param int $notBeforeTime
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setNotBeforeTime($notBeforeTime = null)
    {
        // validation for constraint: int
        if (!is_null($notBeforeTime) && !is_numeric($notBeforeTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notBeforeTime)), __LINE__);
        }
        $this->NotBeforeTime = $notBeforeTime;
        return $this;
    }
    /**
     * Get CycleServiceLocationStatus value
     * @return bool
     */
    public function getCycleServiceLocationStatus()
    {
        return $this->CycleServiceLocationStatus;
    }
    /**
     * Set CycleServiceLocationStatus value
     * @param bool $cycleServiceLocationStatus
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setCycleServiceLocationStatus($cycleServiceLocationStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($cycleServiceLocationStatus) && !is_bool($cycleServiceLocationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cycleServiceLocationStatus)), __LINE__);
        }
        $this->CycleServiceLocationStatus = $cycleServiceLocationStatus;
        return $this;
    }
    /**
     * Get PremiumDisconnectLocationID value
     * @return int
     */
    public function getPremiumDisconnectLocationID()
    {
        return $this->PremiumDisconnectLocationID;
    }
    /**
     * Set PremiumDisconnectLocationID value
     * @param int $premiumDisconnectLocationID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setPremiumDisconnectLocationID($premiumDisconnectLocationID = null)
    {
        // validation for constraint: int
        if (!is_null($premiumDisconnectLocationID) && !is_numeric($premiumDisconnectLocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($premiumDisconnectLocationID)), __LINE__);
        }
        $this->PremiumDisconnectLocationID = $premiumDisconnectLocationID;
        return $this;
    }
    /**
     * Get IsNewService value
     * @return bool
     */
    public function getIsNewService()
    {
        return $this->IsNewService;
    }
    /**
     * Set IsNewService value
     * @param bool $isNewService
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsNewService($isNewService = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewService) && !is_bool($isNewService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNewService)), __LINE__);
        }
        $this->IsNewService = $isNewService;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get AccountDepositID value
     * @return int
     */
    public function getAccountDepositID()
    {
        return $this->AccountDepositID;
    }
    /**
     * Set AccountDepositID value
     * @param int $accountDepositID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountDepositID($accountDepositID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDepositID) && !is_numeric($accountDepositID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDepositID)), __LINE__);
        }
        $this->AccountDepositID = $accountDepositID;
        return $this;
    }
    /**
     * Get PaymentArrangementID value
     * @return int
     */
    public function getPaymentArrangementID()
    {
        return $this->PaymentArrangementID;
    }
    /**
     * Set PaymentArrangementID value
     * @param int $paymentArrangementID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setPaymentArrangementID($paymentArrangementID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementID) && !is_numeric($paymentArrangementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementID)), __LINE__);
        }
        $this->PaymentArrangementID = $paymentArrangementID;
        return $this;
    }
    /**
     * Get ServiceOrderPriorityID value
     * @return int
     */
    public function getServiceOrderPriorityID()
    {
        return $this->ServiceOrderPriorityID;
    }
    /**
     * Set ServiceOrderPriorityID value
     * @param int $serviceOrderPriorityID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderPriorityID($serviceOrderPriorityID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderPriorityID) && !is_numeric($serviceOrderPriorityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderPriorityID)), __LINE__);
        }
        $this->ServiceOrderPriorityID = $serviceOrderPriorityID;
        return $this;
    }
    /**
     * Get IsSpecialNeeds value
     * @return bool
     */
    public function getIsSpecialNeeds()
    {
        return $this->IsSpecialNeeds;
    }
    /**
     * Set IsSpecialNeeds value
     * @param bool $isSpecialNeeds
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsSpecialNeeds($isSpecialNeeds = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSpecialNeeds) && !is_bool($isSpecialNeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSpecialNeeds)), __LINE__);
        }
        $this->IsSpecialNeeds = $isSpecialNeeds;
        return $this;
    }
    /**
     * Get IsCallAhead value
     * @return bool
     */
    public function getIsCallAhead()
    {
        return $this->IsCallAhead;
    }
    /**
     * Set IsCallAhead value
     * @param bool $isCallAhead
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsCallAhead($isCallAhead = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCallAhead) && !is_bool($isCallAhead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCallAhead)), __LINE__);
        }
        $this->IsCallAhead = $isCallAhead;
        return $this;
    }
    /**
     * Get IsFridayDisconnect value
     * @return bool
     */
    public function getIsFridayDisconnect()
    {
        return $this->IsFridayDisconnect;
    }
    /**
     * Set IsFridayDisconnect value
     * @param bool $isFridayDisconnect
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsFridayDisconnect($isFridayDisconnect = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFridayDisconnect) && !is_bool($isFridayDisconnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFridayDisconnect)), __LINE__);
        }
        $this->IsFridayDisconnect = $isFridayDisconnect;
        return $this;
    }
    /**
     * Get IsNotificationWaiverOptOut value
     * @return bool
     */
    public function getIsNotificationWaiverOptOut()
    {
        return $this->IsNotificationWaiverOptOut;
    }
    /**
     * Set IsNotificationWaiverOptOut value
     * @param bool $isNotificationWaiverOptOut
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsNotificationWaiverOptOut($isNotificationWaiverOptOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNotificationWaiverOptOut) && !is_bool($isNotificationWaiverOptOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNotificationWaiverOptOut)), __LINE__);
        }
        $this->IsNotificationWaiverOptOut = $isNotificationWaiverOptOut;
        return $this;
    }
    /**
     * Get IsOnEnergyCreditProgram value
     * @return bool
     */
    public function getIsOnEnergyCreditProgram()
    {
        return $this->IsOnEnergyCreditProgram;
    }
    /**
     * Set IsOnEnergyCreditProgram value
     * @param bool $isOnEnergyCreditProgram
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsOnEnergyCreditProgram($isOnEnergyCreditProgram = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnEnergyCreditProgram) && !is_bool($isOnEnergyCreditProgram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOnEnergyCreditProgram)), __LINE__);
        }
        $this->IsOnEnergyCreditProgram = $isOnEnergyCreditProgram;
        return $this;
    }
    /**
     * Get ServiceOrderPurposeID value
     * @return int
     */
    public function getServiceOrderPurposeID()
    {
        return $this->ServiceOrderPurposeID;
    }
    /**
     * Set ServiceOrderPurposeID value
     * @param int $serviceOrderPurposeID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderPurposeID($serviceOrderPurposeID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderPurposeID) && !is_numeric($serviceOrderPurposeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderPurposeID)), __LINE__);
        }
        $this->ServiceOrderPurposeID = $serviceOrderPurposeID;
        return $this;
    }
    /**
     * Get ServiceOrderSubPurposeID value
     * @return int
     */
    public function getServiceOrderSubPurposeID()
    {
        return $this->ServiceOrderSubPurposeID;
    }
    /**
     * Set ServiceOrderSubPurposeID value
     * @param int $serviceOrderSubPurposeID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderSubPurposeID($serviceOrderSubPurposeID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderSubPurposeID) && !is_numeric($serviceOrderSubPurposeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderSubPurposeID)), __LINE__);
        }
        $this->ServiceOrderSubPurposeID = $serviceOrderSubPurposeID;
        return $this;
    }
    /**
     * Get ServiceOrderReasonID value
     * @return int
     */
    public function getServiceOrderReasonID()
    {
        return $this->ServiceOrderReasonID;
    }
    /**
     * Set ServiceOrderReasonID value
     * @param int $serviceOrderReasonID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderReasonID($serviceOrderReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderReasonID) && !is_numeric($serviceOrderReasonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderReasonID)), __LINE__);
        }
        $this->ServiceOrderReasonID = $serviceOrderReasonID;
        return $this;
    }
    /**
     * Get ServiceOrderChangeReasonID value
     * @return int
     */
    public function getServiceOrderChangeReasonID()
    {
        return $this->ServiceOrderChangeReasonID;
    }
    /**
     * Set ServiceOrderChangeReasonID value
     * @param int $serviceOrderChangeReasonID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderChangeReasonID($serviceOrderChangeReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderChangeReasonID) && !is_numeric($serviceOrderChangeReasonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderChangeReasonID)), __LINE__);
        }
        $this->ServiceOrderChangeReasonID = $serviceOrderChangeReasonID;
        return $this;
    }
    /**
     * Get ScheduledDate value
     * @return string
     */
    public function getScheduledDate()
    {
        return $this->ScheduledDate;
    }
    /**
     * Set ScheduledDate value
     * @param string $scheduledDate
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setScheduledDate($scheduledDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDate) && !is_string($scheduledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledDate)), __LINE__);
        }
        $this->ScheduledDate = $scheduledDate;
        return $this;
    }
    /**
     * Get LastPaymentAmount value
     * @return float
     */
    public function getLastPaymentAmount()
    {
        return $this->LastPaymentAmount;
    }
    /**
     * Set LastPaymentAmount value
     * @param float $lastPaymentAmount
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setLastPaymentAmount($lastPaymentAmount = null)
    {
        $this->LastPaymentAmount = $lastPaymentAmount;
        return $this;
    }
    /**
     * Get LastPaymentDate value
     * @return string
     */
    public function getLastPaymentDate()
    {
        return $this->LastPaymentDate;
    }
    /**
     * Set LastPaymentDate value
     * @param string $lastPaymentDate
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setLastPaymentDate($lastPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPaymentDate) && !is_string($lastPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastPaymentDate)), __LINE__);
        }
        $this->LastPaymentDate = $lastPaymentDate;
        return $this;
    }
    /**
     * Get PastDueBalance value
     * @return float
     */
    public function getPastDueBalance()
    {
        return $this->PastDueBalance;
    }
    /**
     * Set PastDueBalance value
     * @param float $pastDueBalance
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setPastDueBalance($pastDueBalance = null)
    {
        $this->PastDueBalance = $pastDueBalance;
        return $this;
    }
    /**
     * Get IsInWeatherMoratorium value
     * @return bool
     */
    public function getIsInWeatherMoratorium()
    {
        return $this->IsInWeatherMoratorium;
    }
    /**
     * Set IsInWeatherMoratorium value
     * @param bool $isInWeatherMoratorium
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsInWeatherMoratorium($isInWeatherMoratorium = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInWeatherMoratorium) && !is_bool($isInWeatherMoratorium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isInWeatherMoratorium)), __LINE__);
        }
        $this->IsInWeatherMoratorium = $isInWeatherMoratorium;
        return $this;
    }
    /**
     * Get IsOnPaymentArrangement value
     * @return bool
     */
    public function getIsOnPaymentArrangement()
    {
        return $this->IsOnPaymentArrangement;
    }
    /**
     * Set IsOnPaymentArrangement value
     * @param bool $isOnPaymentArrangement
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsOnPaymentArrangement($isOnPaymentArrangement = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnPaymentArrangement) && !is_bool($isOnPaymentArrangement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOnPaymentArrangement)), __LINE__);
        }
        $this->IsOnPaymentArrangement = $isOnPaymentArrangement;
        return $this;
    }
    /**
     * Get IsOnDPP value
     * @return bool
     */
    public function getIsOnDPP()
    {
        return $this->IsOnDPP;
    }
    /**
     * Set IsOnDPP value
     * @param bool $isOnDPP
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsOnDPP($isOnDPP = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnDPP) && !is_bool($isOnDPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOnDPP)), __LINE__);
        }
        $this->IsOnDPP = $isOnDPP;
        return $this;
    }
    /**
     * Get IsOnPaymentExtension value
     * @return bool
     */
    public function getIsOnPaymentExtension()
    {
        return $this->IsOnPaymentExtension;
    }
    /**
     * Set IsOnPaymentExtension value
     * @param bool $isOnPaymentExtension
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsOnPaymentExtension($isOnPaymentExtension = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnPaymentExtension) && !is_bool($isOnPaymentExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOnPaymentExtension)), __LINE__);
        }
        $this->IsOnPaymentExtension = $isOnPaymentExtension;
        return $this;
    }
    /**
     * Get IsAccountProtection value
     * @return bool
     */
    public function getIsAccountProtection()
    {
        return $this->IsAccountProtection;
    }
    /**
     * Set IsAccountProtection value
     * @param bool $isAccountProtection
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setIsAccountProtection($isAccountProtection = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccountProtection) && !is_bool($isAccountProtection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAccountProtection)), __LINE__);
        }
        $this->IsAccountProtection = $isAccountProtection;
        return $this;
    }
    /**
     * Get PreferedLanguageID value
     * @return int
     */
    public function getPreferedLanguageID()
    {
        return $this->PreferedLanguageID;
    }
    /**
     * Set PreferedLanguageID value
     * @param int $preferedLanguageID
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setPreferedLanguageID($preferedLanguageID = null)
    {
        // validation for constraint: int
        if (!is_null($preferedLanguageID) && !is_numeric($preferedLanguageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($preferedLanguageID)), __LINE__);
        }
        $this->PreferedLanguageID = $preferedLanguageID;
        return $this;
    }
    /**
     * Get AccountBillingTypeName value
     * @return string|null
     */
    public function getAccountBillingTypeName()
    {
        return $this->AccountBillingTypeName;
    }
    /**
     * Set AccountBillingTypeName value
     * @param string $accountBillingTypeName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountBillingTypeName($accountBillingTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($accountBillingTypeName) && !is_string($accountBillingTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountBillingTypeName)), __LINE__);
        }
        $this->AccountBillingTypeName = $accountBillingTypeName;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get LineOfBusiness value
     * @return string|null
     */
    public function getLineOfBusiness()
    {
        return $this->LineOfBusiness;
    }
    /**
     * Set LineOfBusiness value
     * @param string $lineOfBusiness
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setLineOfBusiness($lineOfBusiness = null)
    {
        // validation for constraint: string
        if (!is_null($lineOfBusiness) && !is_string($lineOfBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineOfBusiness)), __LINE__);
        }
        $this->LineOfBusiness = $lineOfBusiness;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get OpenedByUserName value
     * @return string|null
     */
    public function getOpenedByUserName()
    {
        return $this->OpenedByUserName;
    }
    /**
     * Set OpenedByUserName value
     * @param string $openedByUserName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setOpenedByUserName($openedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($openedByUserName) && !is_string($openedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openedByUserName)), __LINE__);
        }
        $this->OpenedByUserName = $openedByUserName;
        return $this;
    }
    /**
     * Get SourceServiceOrderTrackingNumber value
     * @return string|null
     */
    public function getSourceServiceOrderTrackingNumber()
    {
        return $this->SourceServiceOrderTrackingNumber;
    }
    /**
     * Set SourceServiceOrderTrackingNumber value
     * @param string $sourceServiceOrderTrackingNumber
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setSourceServiceOrderTrackingNumber($sourceServiceOrderTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sourceServiceOrderTrackingNumber) && !is_string($sourceServiceOrderTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceServiceOrderTrackingNumber)), __LINE__);
        }
        $this->SourceServiceOrderTrackingNumber = $sourceServiceOrderTrackingNumber;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get ContactPhone value
     * @return string|null
     */
    public function getContactPhone()
    {
        return $this->ContactPhone;
    }
    /**
     * Set ContactPhone value
     * @param string $contactPhone
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactPhone)), __LINE__);
        }
        $this->ContactPhone = $contactPhone;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get PremiumDisconnectLocation value
     * @return string|null
     */
    public function getPremiumDisconnectLocation()
    {
        return $this->PremiumDisconnectLocation;
    }
    /**
     * Set PremiumDisconnectLocation value
     * @param string $premiumDisconnectLocation
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setPremiumDisconnectLocation($premiumDisconnectLocation = null)
    {
        // validation for constraint: string
        if (!is_null($premiumDisconnectLocation) && !is_string($premiumDisconnectLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($premiumDisconnectLocation)), __LINE__);
        }
        $this->PremiumDisconnectLocation = $premiumDisconnectLocation;
        return $this;
    }
    /**
     * Get MeterNumber value
     * @return string|null
     */
    public function getMeterNumber()
    {
        return $this->MeterNumber;
    }
    /**
     * Set MeterNumber value
     * @param string $meterNumber
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setMeterNumber($meterNumber = null)
    {
        // validation for constraint: string
        if (!is_null($meterNumber) && !is_string($meterNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterNumber)), __LINE__);
        }
        $this->MeterNumber = $meterNumber;
        return $this;
    }
    /**
     * Get ServiceOrderPurposeName value
     * @return string|null
     */
    public function getServiceOrderPurposeName()
    {
        return $this->ServiceOrderPurposeName;
    }
    /**
     * Set ServiceOrderPurposeName value
     * @param string $serviceOrderPurposeName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderPurposeName($serviceOrderPurposeName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceOrderPurposeName) && !is_string($serviceOrderPurposeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceOrderPurposeName)), __LINE__);
        }
        $this->ServiceOrderPurposeName = $serviceOrderPurposeName;
        return $this;
    }
    /**
     * Get ServiceOrderSubPurposeName value
     * @return string|null
     */
    public function getServiceOrderSubPurposeName()
    {
        return $this->ServiceOrderSubPurposeName;
    }
    /**
     * Set ServiceOrderSubPurposeName value
     * @param string $serviceOrderSubPurposeName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderSubPurposeName($serviceOrderSubPurposeName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceOrderSubPurposeName) && !is_string($serviceOrderSubPurposeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceOrderSubPurposeName)), __LINE__);
        }
        $this->ServiceOrderSubPurposeName = $serviceOrderSubPurposeName;
        return $this;
    }
    /**
     * Get ServiceOrderReasonName value
     * @return string|null
     */
    public function getServiceOrderReasonName()
    {
        return $this->ServiceOrderReasonName;
    }
    /**
     * Set ServiceOrderReasonName value
     * @param string $serviceOrderReasonName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderReasonName($serviceOrderReasonName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceOrderReasonName) && !is_string($serviceOrderReasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceOrderReasonName)), __LINE__);
        }
        $this->ServiceOrderReasonName = $serviceOrderReasonName;
        return $this;
    }
    /**
     * Get ServiceOrderChangeReasonName value
     * @return string|null
     */
    public function getServiceOrderChangeReasonName()
    {
        return $this->ServiceOrderChangeReasonName;
    }
    /**
     * Set ServiceOrderChangeReasonName value
     * @param string $serviceOrderChangeReasonName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderChangeReasonName($serviceOrderChangeReasonName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceOrderChangeReasonName) && !is_string($serviceOrderChangeReasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceOrderChangeReasonName)), __LINE__);
        }
        $this->ServiceOrderChangeReasonName = $serviceOrderChangeReasonName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ServiceOrderTypeName value
     * @return string|null
     */
    public function getServiceOrderTypeName()
    {
        return $this->ServiceOrderTypeName;
    }
    /**
     * Set ServiceOrderTypeName value
     * @param string $serviceOrderTypeName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderTypeName($serviceOrderTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceOrderTypeName) && !is_string($serviceOrderTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceOrderTypeName)), __LINE__);
        }
        $this->ServiceOrderTypeName = $serviceOrderTypeName;
        return $this;
    }
    /**
     * Get ServiceOrderStatusName value
     * @return string|null
     */
    public function getServiceOrderStatusName()
    {
        return $this->ServiceOrderStatusName;
    }
    /**
     * Set ServiceOrderStatusName value
     * @param string $serviceOrderStatusName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderStatusName($serviceOrderStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceOrderStatusName) && !is_string($serviceOrderStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceOrderStatusName)), __LINE__);
        }
        $this->ServiceOrderStatusName = $serviceOrderStatusName;
        return $this;
    }
    /**
     * Get ServiceOrderPriorityName value
     * @return string|null
     */
    public function getServiceOrderPriorityName()
    {
        return $this->ServiceOrderPriorityName;
    }
    /**
     * Set ServiceOrderPriorityName value
     * @param string $serviceOrderPriorityName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceOrderPriorityName($serviceOrderPriorityName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceOrderPriorityName) && !is_string($serviceOrderPriorityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceOrderPriorityName)), __LINE__);
        }
        $this->ServiceOrderPriorityName = $serviceOrderPriorityName;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get ServicePointStatusName value
     * @return string|null
     */
    public function getServicePointStatusName()
    {
        return $this->ServicePointStatusName;
    }
    /**
     * Set ServicePointStatusName value
     * @param string $servicePointStatusName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setServicePointStatusName($servicePointStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($servicePointStatusName) && !is_string($servicePointStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePointStatusName)), __LINE__);
        }
        $this->ServicePointStatusName = $servicePointStatusName;
        return $this;
    }
    /**
     * Get DNPNoticeType value
     * @return string|null
     */
    public function getDNPNoticeType()
    {
        return $this->DNPNoticeType;
    }
    /**
     * Set DNPNoticeType value
     * @param string $dNPNoticeType
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setDNPNoticeType($dNPNoticeType = null)
    {
        // validation for constraint: string
        if (!is_null($dNPNoticeType) && !is_string($dNPNoticeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dNPNoticeType)), __LINE__);
        }
        $this->DNPNoticeType = $dNPNoticeType;
        return $this;
    }
    /**
     * Get PersonPhone value
     * @return string|null
     */
    public function getPersonPhone()
    {
        return $this->PersonPhone;
    }
    /**
     * Set PersonPhone value
     * @param string $personPhone
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setPersonPhone($personPhone = null)
    {
        // validation for constraint: string
        if (!is_null($personPhone) && !is_string($personPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personPhone)), __LINE__);
        }
        $this->PersonPhone = $personPhone;
        return $this;
    }
    /**
     * Get Notes value
     * @return \SGCIS\Array\ArrayOfServiceOrderNote|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \SGCIS\Array\ArrayOfServiceOrderNote $notes
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setNotes(\SGCIS\Array\ArrayOfServiceOrderNote $notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get PreferedLanguage value
     * @return string|null
     */
    public function getPreferedLanguage()
    {
        return $this->PreferedLanguage;
    }
    /**
     * Set PreferedLanguage value
     * @param string $preferedLanguage
     * @return \SGCIS\Struct\ServiceOrder
     */
    public function setPreferedLanguage($preferedLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($preferedLanguage) && !is_string($preferedLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferedLanguage)), __LINE__);
        }
        $this->PreferedLanguage = $preferedLanguage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServiceOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
