<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceAgreement Struct
 * @subpackage Structs
 */
class ServiceAgreement extends AbstractStructBase
{
    /**
     * The ServiceAgreementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The ServiceAgreementStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementStatusID;
    /**
     * The CommodityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommodityID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CreatedByUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatedByUserID;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The LastUpdateUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LastUpdateUserID;
    /**
     * The SalesPersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesPersonID;
    /**
     * The ThirdPartyVerificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ThirdPartyVerificationID;
    /**
     * The RateUsageChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateUsageChargeID;
    /**
     * The EarlyTerminationFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EarlyTerminationFee;
    /**
     * The PaymentDayOfWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentDayOfWeek;
    /**
     * The PaymentDayOfMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentDayOfMonth;
    /**
     * The ServiceAgreementActionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementActionID;
    /**
     * The ServiceAgreementCommissionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementCommissionID;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The ServiceAgreementStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAgreementStatusName;
    /**
     * The CommodityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommodityName;
    /**
     * The ThirdPartyVerificationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThirdPartyVerificationCode;
    /**
     * The PromotionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionCode;
    /**
     * The LegacyContractID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LegacyContractID;
    /**
     * The LegacyContractNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LegacyContractNo;
    /**
     * The ProductDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductDocument
     */
    public $ProductDocuments;
    /**
     * The ServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServicePoint
     */
    public $ServicePoint;
    /**
     * Constructor method for ServiceAgreement
     * @uses ServiceAgreement::setServiceAgreementID()
     * @uses ServiceAgreement::setAccountServicePointID()
     * @uses ServiceAgreement::setProductID()
     * @uses ServiceAgreement::setStartDate()
     * @uses ServiceAgreement::setEndDate()
     * @uses ServiceAgreement::setServiceAgreementStatusID()
     * @uses ServiceAgreement::setCommodityID()
     * @uses ServiceAgreement::setCreateDate()
     * @uses ServiceAgreement::setCreatedByUserID()
     * @uses ServiceAgreement::setLastUpdateDate()
     * @uses ServiceAgreement::setLastUpdateUserID()
     * @uses ServiceAgreement::setSalesPersonID()
     * @uses ServiceAgreement::setThirdPartyVerificationID()
     * @uses ServiceAgreement::setRateUsageChargeID()
     * @uses ServiceAgreement::setEarlyTerminationFee()
     * @uses ServiceAgreement::setPaymentDayOfWeek()
     * @uses ServiceAgreement::setPaymentDayOfMonth()
     * @uses ServiceAgreement::setServiceAgreementActionID()
     * @uses ServiceAgreement::setServiceAgreementCommissionID()
     * @uses ServiceAgreement::setProductName()
     * @uses ServiceAgreement::setServiceAgreementStatusName()
     * @uses ServiceAgreement::setCommodityName()
     * @uses ServiceAgreement::setThirdPartyVerificationCode()
     * @uses ServiceAgreement::setPromotionCode()
     * @uses ServiceAgreement::setLegacyContractID()
     * @uses ServiceAgreement::setLegacyContractNo()
     * @uses ServiceAgreement::setProductDocuments()
     * @uses ServiceAgreement::setServicePoint()
     * @param int $serviceAgreementID
     * @param int $accountServicePointID
     * @param int $productID
     * @param string $startDate
     * @param string $endDate
     * @param int $serviceAgreementStatusID
     * @param int $commodityID
     * @param string $createDate
     * @param int $createdByUserID
     * @param string $lastUpdateDate
     * @param int $lastUpdateUserID
     * @param int $salesPersonID
     * @param int $thirdPartyVerificationID
     * @param int $rateUsageChargeID
     * @param bool $earlyTerminationFee
     * @param int $paymentDayOfWeek
     * @param int $paymentDayOfMonth
     * @param int $serviceAgreementActionID
     * @param int $serviceAgreementCommissionID
     * @param string $productName
     * @param string $serviceAgreementStatusName
     * @param string $commodityName
     * @param string $thirdPartyVerificationCode
     * @param string $promotionCode
     * @param string $legacyContractID
     * @param string $legacyContractNo
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     */
    public function __construct($serviceAgreementID = null, $accountServicePointID = null, $productID = null, $startDate = null, $endDate = null, $serviceAgreementStatusID = null, $commodityID = null, $createDate = null, $createdByUserID = null, $lastUpdateDate = null, $lastUpdateUserID = null, $salesPersonID = null, $thirdPartyVerificationID = null, $rateUsageChargeID = null, $earlyTerminationFee = null, $paymentDayOfWeek = null, $paymentDayOfMonth = null, $serviceAgreementActionID = null, $serviceAgreementCommissionID = null, $productName = null, $serviceAgreementStatusName = null, $commodityName = null, $thirdPartyVerificationCode = null, $promotionCode = null, $legacyContractID = null, $legacyContractNo = null, \SGCIS\Array\ArrayOfProductDocument $productDocuments = null, \SGCIS\Struct\ServicePoint $servicePoint = null)
    {
        $this
            ->setServiceAgreementID($serviceAgreementID)
            ->setAccountServicePointID($accountServicePointID)
            ->setProductID($productID)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setServiceAgreementStatusID($serviceAgreementStatusID)
            ->setCommodityID($commodityID)
            ->setCreateDate($createDate)
            ->setCreatedByUserID($createdByUserID)
            ->setLastUpdateDate($lastUpdateDate)
            ->setLastUpdateUserID($lastUpdateUserID)
            ->setSalesPersonID($salesPersonID)
            ->setThirdPartyVerificationID($thirdPartyVerificationID)
            ->setRateUsageChargeID($rateUsageChargeID)
            ->setEarlyTerminationFee($earlyTerminationFee)
            ->setPaymentDayOfWeek($paymentDayOfWeek)
            ->setPaymentDayOfMonth($paymentDayOfMonth)
            ->setServiceAgreementActionID($serviceAgreementActionID)
            ->setServiceAgreementCommissionID($serviceAgreementCommissionID)
            ->setProductName($productName)
            ->setServiceAgreementStatusName($serviceAgreementStatusName)
            ->setCommodityName($commodityName)
            ->setThirdPartyVerificationCode($thirdPartyVerificationCode)
            ->setPromotionCode($promotionCode)
            ->setLegacyContractID($legacyContractID)
            ->setLegacyContractNo($legacyContractNo)
            ->setProductDocuments($productDocuments)
            ->setServicePoint($servicePoint);
    }
    /**
     * Get ServiceAgreementID value
     * @return int
     */
    public function getServiceAgreementID()
    {
        return $this->ServiceAgreementID;
    }
    /**
     * Set ServiceAgreementID value
     * @param int $serviceAgreementID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setServiceAgreementID($serviceAgreementID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementID) && !is_numeric($serviceAgreementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementID)), __LINE__);
        }
        $this->ServiceAgreementID = $serviceAgreementID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ServiceAgreementStatusID value
     * @return int
     */
    public function getServiceAgreementStatusID()
    {
        return $this->ServiceAgreementStatusID;
    }
    /**
     * Set ServiceAgreementStatusID value
     * @param int $serviceAgreementStatusID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setServiceAgreementStatusID($serviceAgreementStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementStatusID) && !is_numeric($serviceAgreementStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementStatusID)), __LINE__);
        }
        $this->ServiceAgreementStatusID = $serviceAgreementStatusID;
        return $this;
    }
    /**
     * Get CommodityID value
     * @return int
     */
    public function getCommodityID()
    {
        return $this->CommodityID;
    }
    /**
     * Set CommodityID value
     * @param int $commodityID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setCommodityID($commodityID = null)
    {
        // validation for constraint: int
        if (!is_null($commodityID) && !is_numeric($commodityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($commodityID)), __LINE__);
        }
        $this->CommodityID = $commodityID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreatedByUserID value
     * @return int
     */
    public function getCreatedByUserID()
    {
        return $this->CreatedByUserID;
    }
    /**
     * Set CreatedByUserID value
     * @param int $createdByUserID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setCreatedByUserID($createdByUserID = null)
    {
        // validation for constraint: int
        if (!is_null($createdByUserID) && !is_numeric($createdByUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByUserID)), __LINE__);
        }
        $this->CreatedByUserID = $createdByUserID;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get LastUpdateUserID value
     * @return int
     */
    public function getLastUpdateUserID()
    {
        return $this->LastUpdateUserID;
    }
    /**
     * Set LastUpdateUserID value
     * @param int $lastUpdateUserID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setLastUpdateUserID($lastUpdateUserID = null)
    {
        // validation for constraint: int
        if (!is_null($lastUpdateUserID) && !is_numeric($lastUpdateUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastUpdateUserID)), __LINE__);
        }
        $this->LastUpdateUserID = $lastUpdateUserID;
        return $this;
    }
    /**
     * Get SalesPersonID value
     * @return int
     */
    public function getSalesPersonID()
    {
        return $this->SalesPersonID;
    }
    /**
     * Set SalesPersonID value
     * @param int $salesPersonID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setSalesPersonID($salesPersonID = null)
    {
        // validation for constraint: int
        if (!is_null($salesPersonID) && !is_numeric($salesPersonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesPersonID)), __LINE__);
        }
        $this->SalesPersonID = $salesPersonID;
        return $this;
    }
    /**
     * Get ThirdPartyVerificationID value
     * @return int
     */
    public function getThirdPartyVerificationID()
    {
        return $this->ThirdPartyVerificationID;
    }
    /**
     * Set ThirdPartyVerificationID value
     * @param int $thirdPartyVerificationID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setThirdPartyVerificationID($thirdPartyVerificationID = null)
    {
        // validation for constraint: int
        if (!is_null($thirdPartyVerificationID) && !is_numeric($thirdPartyVerificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($thirdPartyVerificationID)), __LINE__);
        }
        $this->ThirdPartyVerificationID = $thirdPartyVerificationID;
        return $this;
    }
    /**
     * Get RateUsageChargeID value
     * @return int
     */
    public function getRateUsageChargeID()
    {
        return $this->RateUsageChargeID;
    }
    /**
     * Set RateUsageChargeID value
     * @param int $rateUsageChargeID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setRateUsageChargeID($rateUsageChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($rateUsageChargeID) && !is_numeric($rateUsageChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateUsageChargeID)), __LINE__);
        }
        $this->RateUsageChargeID = $rateUsageChargeID;
        return $this;
    }
    /**
     * Get EarlyTerminationFee value
     * @return bool
     */
    public function getEarlyTerminationFee()
    {
        return $this->EarlyTerminationFee;
    }
    /**
     * Set EarlyTerminationFee value
     * @param bool $earlyTerminationFee
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setEarlyTerminationFee($earlyTerminationFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($earlyTerminationFee) && !is_bool($earlyTerminationFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($earlyTerminationFee)), __LINE__);
        }
        $this->EarlyTerminationFee = $earlyTerminationFee;
        return $this;
    }
    /**
     * Get PaymentDayOfWeek value
     * @return int
     */
    public function getPaymentDayOfWeek()
    {
        return $this->PaymentDayOfWeek;
    }
    /**
     * Set PaymentDayOfWeek value
     * @param int $paymentDayOfWeek
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setPaymentDayOfWeek($paymentDayOfWeek = null)
    {
        // validation for constraint: int
        if (!is_null($paymentDayOfWeek) && !is_numeric($paymentDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentDayOfWeek)), __LINE__);
        }
        $this->PaymentDayOfWeek = $paymentDayOfWeek;
        return $this;
    }
    /**
     * Get PaymentDayOfMonth value
     * @return int
     */
    public function getPaymentDayOfMonth()
    {
        return $this->PaymentDayOfMonth;
    }
    /**
     * Set PaymentDayOfMonth value
     * @param int $paymentDayOfMonth
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setPaymentDayOfMonth($paymentDayOfMonth = null)
    {
        // validation for constraint: int
        if (!is_null($paymentDayOfMonth) && !is_numeric($paymentDayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentDayOfMonth)), __LINE__);
        }
        $this->PaymentDayOfMonth = $paymentDayOfMonth;
        return $this;
    }
    /**
     * Get ServiceAgreementActionID value
     * @return int
     */
    public function getServiceAgreementActionID()
    {
        return $this->ServiceAgreementActionID;
    }
    /**
     * Set ServiceAgreementActionID value
     * @param int $serviceAgreementActionID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setServiceAgreementActionID($serviceAgreementActionID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementActionID) && !is_numeric($serviceAgreementActionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementActionID)), __LINE__);
        }
        $this->ServiceAgreementActionID = $serviceAgreementActionID;
        return $this;
    }
    /**
     * Get ServiceAgreementCommissionID value
     * @return int
     */
    public function getServiceAgreementCommissionID()
    {
        return $this->ServiceAgreementCommissionID;
    }
    /**
     * Set ServiceAgreementCommissionID value
     * @param int $serviceAgreementCommissionID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setServiceAgreementCommissionID($serviceAgreementCommissionID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementCommissionID) && !is_numeric($serviceAgreementCommissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementCommissionID)), __LINE__);
        }
        $this->ServiceAgreementCommissionID = $serviceAgreementCommissionID;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ServiceAgreementStatusName value
     * @return string|null
     */
    public function getServiceAgreementStatusName()
    {
        return $this->ServiceAgreementStatusName;
    }
    /**
     * Set ServiceAgreementStatusName value
     * @param string $serviceAgreementStatusName
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setServiceAgreementStatusName($serviceAgreementStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAgreementStatusName) && !is_string($serviceAgreementStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAgreementStatusName)), __LINE__);
        }
        $this->ServiceAgreementStatusName = $serviceAgreementStatusName;
        return $this;
    }
    /**
     * Get CommodityName value
     * @return string|null
     */
    public function getCommodityName()
    {
        return $this->CommodityName;
    }
    /**
     * Set CommodityName value
     * @param string $commodityName
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setCommodityName($commodityName = null)
    {
        // validation for constraint: string
        if (!is_null($commodityName) && !is_string($commodityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commodityName)), __LINE__);
        }
        $this->CommodityName = $commodityName;
        return $this;
    }
    /**
     * Get ThirdPartyVerificationCode value
     * @return string|null
     */
    public function getThirdPartyVerificationCode()
    {
        return $this->ThirdPartyVerificationCode;
    }
    /**
     * Set ThirdPartyVerificationCode value
     * @param string $thirdPartyVerificationCode
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setThirdPartyVerificationCode($thirdPartyVerificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyVerificationCode) && !is_string($thirdPartyVerificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirdPartyVerificationCode)), __LINE__);
        }
        $this->ThirdPartyVerificationCode = $thirdPartyVerificationCode;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get LegacyContractID value
     * @return string|null
     */
    public function getLegacyContractID()
    {
        return $this->LegacyContractID;
    }
    /**
     * Set LegacyContractID value
     * @param string $legacyContractID
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setLegacyContractID($legacyContractID = null)
    {
        // validation for constraint: string
        if (!is_null($legacyContractID) && !is_string($legacyContractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legacyContractID)), __LINE__);
        }
        $this->LegacyContractID = $legacyContractID;
        return $this;
    }
    /**
     * Get LegacyContractNo value
     * @return string|null
     */
    public function getLegacyContractNo()
    {
        return $this->LegacyContractNo;
    }
    /**
     * Set LegacyContractNo value
     * @param string $legacyContractNo
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setLegacyContractNo($legacyContractNo = null)
    {
        // validation for constraint: string
        if (!is_null($legacyContractNo) && !is_string($legacyContractNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legacyContractNo)), __LINE__);
        }
        $this->LegacyContractNo = $legacyContractNo;
        return $this;
    }
    /**
     * Get ProductDocuments value
     * @return \SGCIS\Array\ArrayOfProductDocument|null
     */
    public function getProductDocuments()
    {
        return $this->ProductDocuments;
    }
    /**
     * Set ProductDocuments value
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setProductDocuments(\SGCIS\Array\ArrayOfProductDocument $productDocuments = null)
    {
        $this->ProductDocuments = $productDocuments;
        return $this;
    }
    /**
     * Get ServicePoint value
     * @return \SGCIS\Struct\ServicePoint|null
     */
    public function getServicePoint()
    {
        return $this->ServicePoint;
    }
    /**
     * Set ServicePoint value
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public function setServicePoint(\SGCIS\Struct\ServicePoint $servicePoint = null)
    {
        $this->ServicePoint = $servicePoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServiceAgreement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
