<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateLookupResponse Struct
 * @subpackage Structs
 */
class RateLookupResponse extends ServiceResponseBase
{
    /**
     * The IsValidZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsValidZipCode;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProduct
     */
    public $Products;
    /**
     * The ProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileName;
    /**
     * The kWhEnergyPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kWhEnergyPurchased;
    /**
     * The DaysEnergyPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DaysEnergyPurchased;
    /**
     * The MonthlyCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthlyCost;
    /**
     * The DistributionServiceProviders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDistributionServiceProvider
     */
    public $DistributionServiceProviders;
    /**
     * Constructor method for RateLookupResponse
     * @uses RateLookupResponse::setIsValidZipCode()
     * @uses RateLookupResponse::setProducts()
     * @uses RateLookupResponse::setProfileName()
     * @uses RateLookupResponse::setKWhEnergyPurchased()
     * @uses RateLookupResponse::setDaysEnergyPurchased()
     * @uses RateLookupResponse::setMonthlyCost()
     * @uses RateLookupResponse::setDistributionServiceProviders()
     * @param bool $isValidZipCode
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @param string $profileName
     * @param string $kWhEnergyPurchased
     * @param string $daysEnergyPurchased
     * @param string $monthlyCost
     * @param \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders
     */
    public function __construct($isValidZipCode = null, \SGCIS\Array\ArrayOfProduct $products = null, $profileName = null, $kWhEnergyPurchased = null, $daysEnergyPurchased = null, $monthlyCost = null, \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders = null)
    {
        $this
            ->setIsValidZipCode($isValidZipCode)
            ->setProducts($products)
            ->setProfileName($profileName)
            ->setKWhEnergyPurchased($kWhEnergyPurchased)
            ->setDaysEnergyPurchased($daysEnergyPurchased)
            ->setMonthlyCost($monthlyCost)
            ->setDistributionServiceProviders($distributionServiceProviders);
    }
    /**
     * Get IsValidZipCode value
     * @return bool
     */
    public function getIsValidZipCode()
    {
        return $this->IsValidZipCode;
    }
    /**
     * Set IsValidZipCode value
     * @param bool $isValidZipCode
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public function setIsValidZipCode($isValidZipCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValidZipCode) && !is_bool($isValidZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isValidZipCode)), __LINE__);
        }
        $this->IsValidZipCode = $isValidZipCode;
        return $this;
    }
    /**
     * Get Products value
     * @return \SGCIS\Array\ArrayOfProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public function setProducts(\SGCIS\Array\ArrayOfProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get ProfileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->ProfileName;
    }
    /**
     * Set ProfileName value
     * @param string $profileName
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileName)), __LINE__);
        }
        $this->ProfileName = $profileName;
        return $this;
    }
    /**
     * Get kWhEnergyPurchased value
     * @return string|null
     */
    public function getKWhEnergyPurchased()
    {
        return $this->kWhEnergyPurchased;
    }
    /**
     * Set kWhEnergyPurchased value
     * @param string $kWhEnergyPurchased
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public function setKWhEnergyPurchased($kWhEnergyPurchased = null)
    {
        // validation for constraint: string
        if (!is_null($kWhEnergyPurchased) && !is_string($kWhEnergyPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kWhEnergyPurchased)), __LINE__);
        }
        $this->kWhEnergyPurchased = $kWhEnergyPurchased;
        return $this;
    }
    /**
     * Get DaysEnergyPurchased value
     * @return string|null
     */
    public function getDaysEnergyPurchased()
    {
        return $this->DaysEnergyPurchased;
    }
    /**
     * Set DaysEnergyPurchased value
     * @param string $daysEnergyPurchased
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public function setDaysEnergyPurchased($daysEnergyPurchased = null)
    {
        // validation for constraint: string
        if (!is_null($daysEnergyPurchased) && !is_string($daysEnergyPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($daysEnergyPurchased)), __LINE__);
        }
        $this->DaysEnergyPurchased = $daysEnergyPurchased;
        return $this;
    }
    /**
     * Get MonthlyCost value
     * @return string|null
     */
    public function getMonthlyCost()
    {
        return $this->MonthlyCost;
    }
    /**
     * Set MonthlyCost value
     * @param string $monthlyCost
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public function setMonthlyCost($monthlyCost = null)
    {
        // validation for constraint: string
        if (!is_null($monthlyCost) && !is_string($monthlyCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monthlyCost)), __LINE__);
        }
        $this->MonthlyCost = $monthlyCost;
        return $this;
    }
    /**
     * Get DistributionServiceProviders value
     * @return \SGCIS\Array\ArrayOfDistributionServiceProvider|null
     */
    public function getDistributionServiceProviders()
    {
        return $this->DistributionServiceProviders;
    }
    /**
     * Set DistributionServiceProviders value
     * @param \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public function setDistributionServiceProviders(\SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders = null)
    {
        $this->DistributionServiceProviders = $distributionServiceProviders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RateLookupResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
