<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductRequest Struct
 * @subpackage Structs
 */
class ProductRequest extends ServiceRequestBase
{
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The ProductDocumentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDocumentID;
    /**
     * The ServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceProviderID;
    /**
     * The LineOfBusinessID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineOfBusinessID;
    /**
     * The ProductFamilyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductFamilyID;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Product
     */
    public $Product;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProduct
     */
    public $Products;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The LineOfBussiness
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\LineOfBusiness
     */
    public $LineOfBussiness;
    /**
     * The ProductFamily
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ProductFamily
     */
    public $ProductFamily;
    /**
     * The ProductDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ProductDocument
     */
    public $ProductDocument;
    /**
     * The ProductDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ProductDisplay
     */
    public $ProductDisplay;
    /**
     * Constructor method for ProductRequest
     * @uses ProductRequest::setProductID()
     * @uses ProductRequest::setUserID()
     * @uses ProductRequest::setProductDocumentID()
     * @uses ProductRequest::setServiceProviderID()
     * @uses ProductRequest::setLineOfBusinessID()
     * @uses ProductRequest::setProductFamilyID()
     * @uses ProductRequest::setProduct()
     * @uses ProductRequest::setProducts()
     * @uses ProductRequest::setZipCode()
     * @uses ProductRequest::setLineOfBussiness()
     * @uses ProductRequest::setProductFamily()
     * @uses ProductRequest::setProductDocument()
     * @uses ProductRequest::setProductDisplay()
     * @param int $productID
     * @param int $userID
     * @param int $productDocumentID
     * @param int $serviceProviderID
     * @param int $lineOfBusinessID
     * @param int $productFamilyID
     * @param \SGCIS\Struct\Product $product
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @param string $zipCode
     * @param \SGCIS\Struct\LineOfBusiness $lineOfBussiness
     * @param \SGCIS\Struct\ProductFamily $productFamily
     * @param \SGCIS\Struct\ProductDocument $productDocument
     * @param \SGCIS\Struct\ProductDisplay $productDisplay
     */
    public function __construct($productID = null, $userID = null, $productDocumentID = null, $serviceProviderID = null, $lineOfBusinessID = null, $productFamilyID = null, \SGCIS\Struct\Product $product = null, \SGCIS\Array\ArrayOfProduct $products = null, $zipCode = null, \SGCIS\Struct\LineOfBusiness $lineOfBussiness = null, \SGCIS\Struct\ProductFamily $productFamily = null, \SGCIS\Struct\ProductDocument $productDocument = null, \SGCIS\Struct\ProductDisplay $productDisplay = null)
    {
        $this
            ->setProductID($productID)
            ->setUserID($userID)
            ->setProductDocumentID($productDocumentID)
            ->setServiceProviderID($serviceProviderID)
            ->setLineOfBusinessID($lineOfBusinessID)
            ->setProductFamilyID($productFamilyID)
            ->setProduct($product)
            ->setProducts($products)
            ->setZipCode($zipCode)
            ->setLineOfBussiness($lineOfBussiness)
            ->setProductFamily($productFamily)
            ->setProductDocument($productDocument)
            ->setProductDisplay($productDisplay);
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get ProductDocumentID value
     * @return int
     */
    public function getProductDocumentID()
    {
        return $this->ProductDocumentID;
    }
    /**
     * Set ProductDocumentID value
     * @param int $productDocumentID
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProductDocumentID($productDocumentID = null)
    {
        // validation for constraint: int
        if (!is_null($productDocumentID) && !is_numeric($productDocumentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDocumentID)), __LINE__);
        }
        $this->ProductDocumentID = $productDocumentID;
        return $this;
    }
    /**
     * Get ServiceProviderID value
     * @return int
     */
    public function getServiceProviderID()
    {
        return $this->ServiceProviderID;
    }
    /**
     * Set ServiceProviderID value
     * @param int $serviceProviderID
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setServiceProviderID($serviceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceProviderID) && !is_numeric($serviceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceProviderID)), __LINE__);
        }
        $this->ServiceProviderID = $serviceProviderID;
        return $this;
    }
    /**
     * Get LineOfBusinessID value
     * @return int
     */
    public function getLineOfBusinessID()
    {
        return $this->LineOfBusinessID;
    }
    /**
     * Set LineOfBusinessID value
     * @param int $lineOfBusinessID
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setLineOfBusinessID($lineOfBusinessID = null)
    {
        // validation for constraint: int
        if (!is_null($lineOfBusinessID) && !is_numeric($lineOfBusinessID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineOfBusinessID)), __LINE__);
        }
        $this->LineOfBusinessID = $lineOfBusinessID;
        return $this;
    }
    /**
     * Get ProductFamilyID value
     * @return int
     */
    public function getProductFamilyID()
    {
        return $this->ProductFamilyID;
    }
    /**
     * Set ProductFamilyID value
     * @param int $productFamilyID
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProductFamilyID($productFamilyID = null)
    {
        // validation for constraint: int
        if (!is_null($productFamilyID) && !is_numeric($productFamilyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productFamilyID)), __LINE__);
        }
        $this->ProductFamilyID = $productFamilyID;
        return $this;
    }
    /**
     * Get Product value
     * @return \SGCIS\Struct\Product|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \SGCIS\Struct\Product $product
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProduct(\SGCIS\Struct\Product $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Products value
     * @return \SGCIS\Array\ArrayOfProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProducts(\SGCIS\Array\ArrayOfProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get LineOfBussiness value
     * @return \SGCIS\Struct\LineOfBusiness|null
     */
    public function getLineOfBussiness()
    {
        return $this->LineOfBussiness;
    }
    /**
     * Set LineOfBussiness value
     * @param \SGCIS\Struct\LineOfBusiness $lineOfBussiness
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setLineOfBussiness(\SGCIS\Struct\LineOfBusiness $lineOfBussiness = null)
    {
        $this->LineOfBussiness = $lineOfBussiness;
        return $this;
    }
    /**
     * Get ProductFamily value
     * @return \SGCIS\Struct\ProductFamily|null
     */
    public function getProductFamily()
    {
        return $this->ProductFamily;
    }
    /**
     * Set ProductFamily value
     * @param \SGCIS\Struct\ProductFamily $productFamily
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProductFamily(\SGCIS\Struct\ProductFamily $productFamily = null)
    {
        $this->ProductFamily = $productFamily;
        return $this;
    }
    /**
     * Get ProductDocument value
     * @return \SGCIS\Struct\ProductDocument|null
     */
    public function getProductDocument()
    {
        return $this->ProductDocument;
    }
    /**
     * Set ProductDocument value
     * @param \SGCIS\Struct\ProductDocument $productDocument
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProductDocument(\SGCIS\Struct\ProductDocument $productDocument = null)
    {
        $this->ProductDocument = $productDocument;
        return $this;
    }
    /**
     * Get ProductDisplay value
     * @return \SGCIS\Struct\ProductDisplay|null
     */
    public function getProductDisplay()
    {
        return $this->ProductDisplay;
    }
    /**
     * Set ProductDisplay value
     * @param \SGCIS\Struct\ProductDisplay $productDisplay
     * @return \SGCIS\Struct\ProductRequest
     */
    public function setProductDisplay(\SGCIS\Struct\ProductDisplay $productDisplay = null)
    {
        $this->ProductDisplay = $productDisplay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
