<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductRate Struct
 * @subpackage Structs
 */
class ProductRate extends BaseDTO
{
    /**
     * The ProductRateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductRateID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The MarketPricingNodeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MarketPricingNodeID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The AvgRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AvgRate;
    /**
     * The ProductRateStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductRateStatusID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The RateTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateTypeID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The MarketPricingNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketPricingNodeName;
    /**
     * The TDSP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TDSP;
    /**
     * The ProductRateStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductRateStatus;
    /**
     * The RateTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateTypeName;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The UsageTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsageTypeName;
    /**
     * Constructor method for ProductRate
     * @uses ProductRate::setProductRateID()
     * @uses ProductRate::setProductID()
     * @uses ProductRate::setMarketPricingNodeID()
     * @uses ProductRate::setDistributionServiceProviderID()
     * @uses ProductRate::setAvgRate()
     * @uses ProductRate::setProductRateStatusID()
     * @uses ProductRate::setRateID()
     * @uses ProductRate::setRateTypeID()
     * @uses ProductRate::setActive()
     * @uses ProductRate::setStartDate()
     * @uses ProductRate::setEndDate()
     * @uses ProductRate::setName()
     * @uses ProductRate::setMarketPricingNodeName()
     * @uses ProductRate::setTDSP()
     * @uses ProductRate::setProductRateStatus()
     * @uses ProductRate::setRateTypeName()
     * @uses ProductRate::setProductName()
     * @uses ProductRate::setUsageTypeName()
     * @param int $productRateID
     * @param int $productID
     * @param int $marketPricingNodeID
     * @param int $distributionServiceProviderID
     * @param float $avgRate
     * @param int $productRateStatusID
     * @param int $rateID
     * @param int $rateTypeID
     * @param bool $active
     * @param string $startDate
     * @param string $endDate
     * @param string $name
     * @param string $marketPricingNodeName
     * @param string $tDSP
     * @param string $productRateStatus
     * @param string $rateTypeName
     * @param string $productName
     * @param string $usageTypeName
     */
    public function __construct($productRateID = null, $productID = null, $marketPricingNodeID = null, $distributionServiceProviderID = null, $avgRate = null, $productRateStatusID = null, $rateID = null, $rateTypeID = null, $active = null, $startDate = null, $endDate = null, $name = null, $marketPricingNodeName = null, $tDSP = null, $productRateStatus = null, $rateTypeName = null, $productName = null, $usageTypeName = null)
    {
        $this
            ->setProductRateID($productRateID)
            ->setProductID($productID)
            ->setMarketPricingNodeID($marketPricingNodeID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setAvgRate($avgRate)
            ->setProductRateStatusID($productRateStatusID)
            ->setRateID($rateID)
            ->setRateTypeID($rateTypeID)
            ->setActive($active)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setName($name)
            ->setMarketPricingNodeName($marketPricingNodeName)
            ->setTDSP($tDSP)
            ->setProductRateStatus($productRateStatus)
            ->setRateTypeName($rateTypeName)
            ->setProductName($productName)
            ->setUsageTypeName($usageTypeName);
    }
    /**
     * Get ProductRateID value
     * @return int
     */
    public function getProductRateID()
    {
        return $this->ProductRateID;
    }
    /**
     * Set ProductRateID value
     * @param int $productRateID
     * @return \SGCIS\Struct\ProductRate
     */
    public function setProductRateID($productRateID = null)
    {
        // validation for constraint: int
        if (!is_null($productRateID) && !is_numeric($productRateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productRateID)), __LINE__);
        }
        $this->ProductRateID = $productRateID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductRate
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get MarketPricingNodeID value
     * @return int
     */
    public function getMarketPricingNodeID()
    {
        return $this->MarketPricingNodeID;
    }
    /**
     * Set MarketPricingNodeID value
     * @param int $marketPricingNodeID
     * @return \SGCIS\Struct\ProductRate
     */
    public function setMarketPricingNodeID($marketPricingNodeID = null)
    {
        // validation for constraint: int
        if (!is_null($marketPricingNodeID) && !is_numeric($marketPricingNodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marketPricingNodeID)), __LINE__);
        }
        $this->MarketPricingNodeID = $marketPricingNodeID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\ProductRate
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get AvgRate value
     * @return float
     */
    public function getAvgRate()
    {
        return $this->AvgRate;
    }
    /**
     * Set AvgRate value
     * @param float $avgRate
     * @return \SGCIS\Struct\ProductRate
     */
    public function setAvgRate($avgRate = null)
    {
        $this->AvgRate = $avgRate;
        return $this;
    }
    /**
     * Get ProductRateStatusID value
     * @return int
     */
    public function getProductRateStatusID()
    {
        return $this->ProductRateStatusID;
    }
    /**
     * Set ProductRateStatusID value
     * @param int $productRateStatusID
     * @return \SGCIS\Struct\ProductRate
     */
    public function setProductRateStatusID($productRateStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($productRateStatusID) && !is_numeric($productRateStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productRateStatusID)), __LINE__);
        }
        $this->ProductRateStatusID = $productRateStatusID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\ProductRate
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get RateTypeID value
     * @return int
     */
    public function getRateTypeID()
    {
        return $this->RateTypeID;
    }
    /**
     * Set RateTypeID value
     * @param int $rateTypeID
     * @return \SGCIS\Struct\ProductRate
     */
    public function setRateTypeID($rateTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($rateTypeID) && !is_numeric($rateTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateTypeID)), __LINE__);
        }
        $this->RateTypeID = $rateTypeID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\ProductRate
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\ProductRate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \SGCIS\Struct\ProductRate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\ProductRate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get MarketPricingNodeName value
     * @return string|null
     */
    public function getMarketPricingNodeName()
    {
        return $this->MarketPricingNodeName;
    }
    /**
     * Set MarketPricingNodeName value
     * @param string $marketPricingNodeName
     * @return \SGCIS\Struct\ProductRate
     */
    public function setMarketPricingNodeName($marketPricingNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($marketPricingNodeName) && !is_string($marketPricingNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketPricingNodeName)), __LINE__);
        }
        $this->MarketPricingNodeName = $marketPricingNodeName;
        return $this;
    }
    /**
     * Get TDSP value
     * @return string|null
     */
    public function getTDSP()
    {
        return $this->TDSP;
    }
    /**
     * Set TDSP value
     * @param string $tDSP
     * @return \SGCIS\Struct\ProductRate
     */
    public function setTDSP($tDSP = null)
    {
        // validation for constraint: string
        if (!is_null($tDSP) && !is_string($tDSP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tDSP)), __LINE__);
        }
        $this->TDSP = $tDSP;
        return $this;
    }
    /**
     * Get ProductRateStatus value
     * @return string|null
     */
    public function getProductRateStatus()
    {
        return $this->ProductRateStatus;
    }
    /**
     * Set ProductRateStatus value
     * @param string $productRateStatus
     * @return \SGCIS\Struct\ProductRate
     */
    public function setProductRateStatus($productRateStatus = null)
    {
        // validation for constraint: string
        if (!is_null($productRateStatus) && !is_string($productRateStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productRateStatus)), __LINE__);
        }
        $this->ProductRateStatus = $productRateStatus;
        return $this;
    }
    /**
     * Get RateTypeName value
     * @return string|null
     */
    public function getRateTypeName()
    {
        return $this->RateTypeName;
    }
    /**
     * Set RateTypeName value
     * @param string $rateTypeName
     * @return \SGCIS\Struct\ProductRate
     */
    public function setRateTypeName($rateTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($rateTypeName) && !is_string($rateTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateTypeName)), __LINE__);
        }
        $this->RateTypeName = $rateTypeName;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\ProductRate
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get UsageTypeName value
     * @return string|null
     */
    public function getUsageTypeName()
    {
        return $this->UsageTypeName;
    }
    /**
     * Set UsageTypeName value
     * @param string $usageTypeName
     * @return \SGCIS\Struct\ProductRate
     */
    public function setUsageTypeName($usageTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($usageTypeName) && !is_string($usageTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageTypeName)), __LINE__);
        }
        $this->UsageTypeName = $usageTypeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
