<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDisplay Struct
 * @subpackage Structs
 */
class ProductDisplay extends AbstractStructBase
{
    /**
     * The ProductDisplayID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDisplayID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The ProductCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductCategoryID;
    /**
     * The IsRecommended
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRecommended;
    /**
     * The IsFeatured
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFeatured;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CreatedByUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatedByUserID;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The LastUpdateUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LastUpdateUserID;
    /**
     * The KwhAvgPriceTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KwhAvgPriceTypeID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ShortDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortDescription;
    /**
     * The LongDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LongDescription;
    /**
     * The MarketingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketingCode;
    /**
     * The BaseCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaseCharge;
    /**
     * The AveragePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AveragePrice;
    /**
     * The AveragePriceDisclaimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AveragePriceDisclaimer;
    /**
     * The EnergyCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnergyCharge;
    /**
     * The ProductTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductTag;
    /**
     * The Feature1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature1;
    /**
     * The Feature2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature2;
    /**
     * The Feature3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature3;
    /**
     * The Feature4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature4;
    /**
     * The Feature5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature5;
    /**
     * The Promotion1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Promotion1;
    /**
     * The Promotion2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Promotion2;
    /**
     * The Promotion3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Promotion3;
    /**
     * The PromotionDisclaimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionDisclaimer;
    /**
     * The DocumentEFL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentEFL;
    /**
     * The DocumentTOS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTOS;
    /**
     * The DocumentYRAC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentYRAC;
    /**
     * The DocumentPDS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentPDS;
    /**
     * The FeaturedImageUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeaturedImageUrl;
    /**
     * The ProductDisplayTDSP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductDisplayTDSP
     */
    public $ProductDisplayTDSP;
    /**
     * Constructor method for ProductDisplay
     * @uses ProductDisplay::setProductDisplayID()
     * @uses ProductDisplay::setProductID()
     * @uses ProductDisplay::setProductCategoryID()
     * @uses ProductDisplay::setIsRecommended()
     * @uses ProductDisplay::setIsFeatured()
     * @uses ProductDisplay::setCreateDate()
     * @uses ProductDisplay::setCreatedByUserID()
     * @uses ProductDisplay::setLastUpdateDate()
     * @uses ProductDisplay::setLastUpdateUserID()
     * @uses ProductDisplay::setKwhAvgPriceTypeID()
     * @uses ProductDisplay::setName()
     * @uses ProductDisplay::setShortDescription()
     * @uses ProductDisplay::setLongDescription()
     * @uses ProductDisplay::setMarketingCode()
     * @uses ProductDisplay::setBaseCharge()
     * @uses ProductDisplay::setAveragePrice()
     * @uses ProductDisplay::setAveragePriceDisclaimer()
     * @uses ProductDisplay::setEnergyCharge()
     * @uses ProductDisplay::setProductTag()
     * @uses ProductDisplay::setFeature1()
     * @uses ProductDisplay::setFeature2()
     * @uses ProductDisplay::setFeature3()
     * @uses ProductDisplay::setFeature4()
     * @uses ProductDisplay::setFeature5()
     * @uses ProductDisplay::setPromotion1()
     * @uses ProductDisplay::setPromotion2()
     * @uses ProductDisplay::setPromotion3()
     * @uses ProductDisplay::setPromotionDisclaimer()
     * @uses ProductDisplay::setDocumentEFL()
     * @uses ProductDisplay::setDocumentTOS()
     * @uses ProductDisplay::setDocumentYRAC()
     * @uses ProductDisplay::setDocumentPDS()
     * @uses ProductDisplay::setFeaturedImageUrl()
     * @uses ProductDisplay::setProductDisplayTDSP()
     * @param int $productDisplayID
     * @param int $productID
     * @param int $productCategoryID
     * @param bool $isRecommended
     * @param bool $isFeatured
     * @param string $createDate
     * @param int $createdByUserID
     * @param string $lastUpdateDate
     * @param int $lastUpdateUserID
     * @param int $kwhAvgPriceTypeID
     * @param string $name
     * @param string $shortDescription
     * @param string $longDescription
     * @param string $marketingCode
     * @param string $baseCharge
     * @param string $averagePrice
     * @param string $averagePriceDisclaimer
     * @param string $energyCharge
     * @param string $productTag
     * @param string $feature1
     * @param string $feature2
     * @param string $feature3
     * @param string $feature4
     * @param string $feature5
     * @param string $promotion1
     * @param string $promotion2
     * @param string $promotion3
     * @param string $promotionDisclaimer
     * @param string $documentEFL
     * @param string $documentTOS
     * @param string $documentYRAC
     * @param string $documentPDS
     * @param string $featuredImageUrl
     * @param \SGCIS\Array\ArrayOfProductDisplayTDSP $productDisplayTDSP
     */
    public function __construct($productDisplayID = null, $productID = null, $productCategoryID = null, $isRecommended = null, $isFeatured = null, $createDate = null, $createdByUserID = null, $lastUpdateDate = null, $lastUpdateUserID = null, $kwhAvgPriceTypeID = null, $name = null, $shortDescription = null, $longDescription = null, $marketingCode = null, $baseCharge = null, $averagePrice = null, $averagePriceDisclaimer = null, $energyCharge = null, $productTag = null, $feature1 = null, $feature2 = null, $feature3 = null, $feature4 = null, $feature5 = null, $promotion1 = null, $promotion2 = null, $promotion3 = null, $promotionDisclaimer = null, $documentEFL = null, $documentTOS = null, $documentYRAC = null, $documentPDS = null, $featuredImageUrl = null, \SGCIS\Array\ArrayOfProductDisplayTDSP $productDisplayTDSP = null)
    {
        $this
            ->setProductDisplayID($productDisplayID)
            ->setProductID($productID)
            ->setProductCategoryID($productCategoryID)
            ->setIsRecommended($isRecommended)
            ->setIsFeatured($isFeatured)
            ->setCreateDate($createDate)
            ->setCreatedByUserID($createdByUserID)
            ->setLastUpdateDate($lastUpdateDate)
            ->setLastUpdateUserID($lastUpdateUserID)
            ->setKwhAvgPriceTypeID($kwhAvgPriceTypeID)
            ->setName($name)
            ->setShortDescription($shortDescription)
            ->setLongDescription($longDescription)
            ->setMarketingCode($marketingCode)
            ->setBaseCharge($baseCharge)
            ->setAveragePrice($averagePrice)
            ->setAveragePriceDisclaimer($averagePriceDisclaimer)
            ->setEnergyCharge($energyCharge)
            ->setProductTag($productTag)
            ->setFeature1($feature1)
            ->setFeature2($feature2)
            ->setFeature3($feature3)
            ->setFeature4($feature4)
            ->setFeature5($feature5)
            ->setPromotion1($promotion1)
            ->setPromotion2($promotion2)
            ->setPromotion3($promotion3)
            ->setPromotionDisclaimer($promotionDisclaimer)
            ->setDocumentEFL($documentEFL)
            ->setDocumentTOS($documentTOS)
            ->setDocumentYRAC($documentYRAC)
            ->setDocumentPDS($documentPDS)
            ->setFeaturedImageUrl($featuredImageUrl)
            ->setProductDisplayTDSP($productDisplayTDSP);
    }
    /**
     * Get ProductDisplayID value
     * @return int
     */
    public function getProductDisplayID()
    {
        return $this->ProductDisplayID;
    }
    /**
     * Set ProductDisplayID value
     * @param int $productDisplayID
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setProductDisplayID($productDisplayID = null)
    {
        // validation for constraint: int
        if (!is_null($productDisplayID) && !is_numeric($productDisplayID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDisplayID)), __LINE__);
        }
        $this->ProductDisplayID = $productDisplayID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ProductCategoryID value
     * @return int
     */
    public function getProductCategoryID()
    {
        return $this->ProductCategoryID;
    }
    /**
     * Set ProductCategoryID value
     * @param int $productCategoryID
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setProductCategoryID($productCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($productCategoryID) && !is_numeric($productCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productCategoryID)), __LINE__);
        }
        $this->ProductCategoryID = $productCategoryID;
        return $this;
    }
    /**
     * Get IsRecommended value
     * @return bool
     */
    public function getIsRecommended()
    {
        return $this->IsRecommended;
    }
    /**
     * Set IsRecommended value
     * @param bool $isRecommended
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setIsRecommended($isRecommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecommended) && !is_bool($isRecommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRecommended)), __LINE__);
        }
        $this->IsRecommended = $isRecommended;
        return $this;
    }
    /**
     * Get IsFeatured value
     * @return bool
     */
    public function getIsFeatured()
    {
        return $this->IsFeatured;
    }
    /**
     * Set IsFeatured value
     * @param bool $isFeatured
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setIsFeatured($isFeatured = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFeatured) && !is_bool($isFeatured)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFeatured)), __LINE__);
        }
        $this->IsFeatured = $isFeatured;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreatedByUserID value
     * @return int
     */
    public function getCreatedByUserID()
    {
        return $this->CreatedByUserID;
    }
    /**
     * Set CreatedByUserID value
     * @param int $createdByUserID
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setCreatedByUserID($createdByUserID = null)
    {
        // validation for constraint: int
        if (!is_null($createdByUserID) && !is_numeric($createdByUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByUserID)), __LINE__);
        }
        $this->CreatedByUserID = $createdByUserID;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get LastUpdateUserID value
     * @return int
     */
    public function getLastUpdateUserID()
    {
        return $this->LastUpdateUserID;
    }
    /**
     * Set LastUpdateUserID value
     * @param int $lastUpdateUserID
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setLastUpdateUserID($lastUpdateUserID = null)
    {
        // validation for constraint: int
        if (!is_null($lastUpdateUserID) && !is_numeric($lastUpdateUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastUpdateUserID)), __LINE__);
        }
        $this->LastUpdateUserID = $lastUpdateUserID;
        return $this;
    }
    /**
     * Get KwhAvgPriceTypeID value
     * @return int
     */
    public function getKwhAvgPriceTypeID()
    {
        return $this->KwhAvgPriceTypeID;
    }
    /**
     * Set KwhAvgPriceTypeID value
     * @param int $kwhAvgPriceTypeID
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setKwhAvgPriceTypeID($kwhAvgPriceTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($kwhAvgPriceTypeID) && !is_numeric($kwhAvgPriceTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kwhAvgPriceTypeID)), __LINE__);
        }
        $this->KwhAvgPriceTypeID = $kwhAvgPriceTypeID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param string $longDescription
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get MarketingCode value
     * @return string|null
     */
    public function getMarketingCode()
    {
        return $this->MarketingCode;
    }
    /**
     * Set MarketingCode value
     * @param string $marketingCode
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setMarketingCode($marketingCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCode) && !is_string($marketingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketingCode)), __LINE__);
        }
        $this->MarketingCode = $marketingCode;
        return $this;
    }
    /**
     * Get BaseCharge value
     * @return string|null
     */
    public function getBaseCharge()
    {
        return $this->BaseCharge;
    }
    /**
     * Set BaseCharge value
     * @param string $baseCharge
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setBaseCharge($baseCharge = null)
    {
        // validation for constraint: string
        if (!is_null($baseCharge) && !is_string($baseCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseCharge)), __LINE__);
        }
        $this->BaseCharge = $baseCharge;
        return $this;
    }
    /**
     * Get AveragePrice value
     * @return string|null
     */
    public function getAveragePrice()
    {
        return $this->AveragePrice;
    }
    /**
     * Set AveragePrice value
     * @param string $averagePrice
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setAveragePrice($averagePrice = null)
    {
        // validation for constraint: string
        if (!is_null($averagePrice) && !is_string($averagePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($averagePrice)), __LINE__);
        }
        $this->AveragePrice = $averagePrice;
        return $this;
    }
    /**
     * Get AveragePriceDisclaimer value
     * @return string|null
     */
    public function getAveragePriceDisclaimer()
    {
        return $this->AveragePriceDisclaimer;
    }
    /**
     * Set AveragePriceDisclaimer value
     * @param string $averagePriceDisclaimer
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setAveragePriceDisclaimer($averagePriceDisclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($averagePriceDisclaimer) && !is_string($averagePriceDisclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($averagePriceDisclaimer)), __LINE__);
        }
        $this->AveragePriceDisclaimer = $averagePriceDisclaimer;
        return $this;
    }
    /**
     * Get EnergyCharge value
     * @return string|null
     */
    public function getEnergyCharge()
    {
        return $this->EnergyCharge;
    }
    /**
     * Set EnergyCharge value
     * @param string $energyCharge
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setEnergyCharge($energyCharge = null)
    {
        // validation for constraint: string
        if (!is_null($energyCharge) && !is_string($energyCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($energyCharge)), __LINE__);
        }
        $this->EnergyCharge = $energyCharge;
        return $this;
    }
    /**
     * Get ProductTag value
     * @return string|null
     */
    public function getProductTag()
    {
        return $this->ProductTag;
    }
    /**
     * Set ProductTag value
     * @param string $productTag
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setProductTag($productTag = null)
    {
        // validation for constraint: string
        if (!is_null($productTag) && !is_string($productTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productTag)), __LINE__);
        }
        $this->ProductTag = $productTag;
        return $this;
    }
    /**
     * Get Feature1 value
     * @return string|null
     */
    public function getFeature1()
    {
        return $this->Feature1;
    }
    /**
     * Set Feature1 value
     * @param string $feature1
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setFeature1($feature1 = null)
    {
        // validation for constraint: string
        if (!is_null($feature1) && !is_string($feature1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feature1)), __LINE__);
        }
        $this->Feature1 = $feature1;
        return $this;
    }
    /**
     * Get Feature2 value
     * @return string|null
     */
    public function getFeature2()
    {
        return $this->Feature2;
    }
    /**
     * Set Feature2 value
     * @param string $feature2
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setFeature2($feature2 = null)
    {
        // validation for constraint: string
        if (!is_null($feature2) && !is_string($feature2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feature2)), __LINE__);
        }
        $this->Feature2 = $feature2;
        return $this;
    }
    /**
     * Get Feature3 value
     * @return string|null
     */
    public function getFeature3()
    {
        return $this->Feature3;
    }
    /**
     * Set Feature3 value
     * @param string $feature3
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setFeature3($feature3 = null)
    {
        // validation for constraint: string
        if (!is_null($feature3) && !is_string($feature3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feature3)), __LINE__);
        }
        $this->Feature3 = $feature3;
        return $this;
    }
    /**
     * Get Feature4 value
     * @return string|null
     */
    public function getFeature4()
    {
        return $this->Feature4;
    }
    /**
     * Set Feature4 value
     * @param string $feature4
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setFeature4($feature4 = null)
    {
        // validation for constraint: string
        if (!is_null($feature4) && !is_string($feature4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feature4)), __LINE__);
        }
        $this->Feature4 = $feature4;
        return $this;
    }
    /**
     * Get Feature5 value
     * @return string|null
     */
    public function getFeature5()
    {
        return $this->Feature5;
    }
    /**
     * Set Feature5 value
     * @param string $feature5
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setFeature5($feature5 = null)
    {
        // validation for constraint: string
        if (!is_null($feature5) && !is_string($feature5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feature5)), __LINE__);
        }
        $this->Feature5 = $feature5;
        return $this;
    }
    /**
     * Get Promotion1 value
     * @return string|null
     */
    public function getPromotion1()
    {
        return $this->Promotion1;
    }
    /**
     * Set Promotion1 value
     * @param string $promotion1
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setPromotion1($promotion1 = null)
    {
        // validation for constraint: string
        if (!is_null($promotion1) && !is_string($promotion1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotion1)), __LINE__);
        }
        $this->Promotion1 = $promotion1;
        return $this;
    }
    /**
     * Get Promotion2 value
     * @return string|null
     */
    public function getPromotion2()
    {
        return $this->Promotion2;
    }
    /**
     * Set Promotion2 value
     * @param string $promotion2
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setPromotion2($promotion2 = null)
    {
        // validation for constraint: string
        if (!is_null($promotion2) && !is_string($promotion2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotion2)), __LINE__);
        }
        $this->Promotion2 = $promotion2;
        return $this;
    }
    /**
     * Get Promotion3 value
     * @return string|null
     */
    public function getPromotion3()
    {
        return $this->Promotion3;
    }
    /**
     * Set Promotion3 value
     * @param string $promotion3
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setPromotion3($promotion3 = null)
    {
        // validation for constraint: string
        if (!is_null($promotion3) && !is_string($promotion3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotion3)), __LINE__);
        }
        $this->Promotion3 = $promotion3;
        return $this;
    }
    /**
     * Get PromotionDisclaimer value
     * @return string|null
     */
    public function getPromotionDisclaimer()
    {
        return $this->PromotionDisclaimer;
    }
    /**
     * Set PromotionDisclaimer value
     * @param string $promotionDisclaimer
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setPromotionDisclaimer($promotionDisclaimer = null)
    {
        // validation for constraint: string
        if (!is_null($promotionDisclaimer) && !is_string($promotionDisclaimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionDisclaimer)), __LINE__);
        }
        $this->PromotionDisclaimer = $promotionDisclaimer;
        return $this;
    }
    /**
     * Get DocumentEFL value
     * @return string|null
     */
    public function getDocumentEFL()
    {
        return $this->DocumentEFL;
    }
    /**
     * Set DocumentEFL value
     * @param string $documentEFL
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setDocumentEFL($documentEFL = null)
    {
        // validation for constraint: string
        if (!is_null($documentEFL) && !is_string($documentEFL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentEFL)), __LINE__);
        }
        $this->DocumentEFL = $documentEFL;
        return $this;
    }
    /**
     * Get DocumentTOS value
     * @return string|null
     */
    public function getDocumentTOS()
    {
        return $this->DocumentTOS;
    }
    /**
     * Set DocumentTOS value
     * @param string $documentTOS
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setDocumentTOS($documentTOS = null)
    {
        // validation for constraint: string
        if (!is_null($documentTOS) && !is_string($documentTOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTOS)), __LINE__);
        }
        $this->DocumentTOS = $documentTOS;
        return $this;
    }
    /**
     * Get DocumentYRAC value
     * @return string|null
     */
    public function getDocumentYRAC()
    {
        return $this->DocumentYRAC;
    }
    /**
     * Set DocumentYRAC value
     * @param string $documentYRAC
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setDocumentYRAC($documentYRAC = null)
    {
        // validation for constraint: string
        if (!is_null($documentYRAC) && !is_string($documentYRAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentYRAC)), __LINE__);
        }
        $this->DocumentYRAC = $documentYRAC;
        return $this;
    }
    /**
     * Get DocumentPDS value
     * @return string|null
     */
    public function getDocumentPDS()
    {
        return $this->DocumentPDS;
    }
    /**
     * Set DocumentPDS value
     * @param string $documentPDS
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setDocumentPDS($documentPDS = null)
    {
        // validation for constraint: string
        if (!is_null($documentPDS) && !is_string($documentPDS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentPDS)), __LINE__);
        }
        $this->DocumentPDS = $documentPDS;
        return $this;
    }
    /**
     * Get FeaturedImageUrl value
     * @return string|null
     */
    public function getFeaturedImageUrl()
    {
        return $this->FeaturedImageUrl;
    }
    /**
     * Set FeaturedImageUrl value
     * @param string $featuredImageUrl
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setFeaturedImageUrl($featuredImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($featuredImageUrl) && !is_string($featuredImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($featuredImageUrl)), __LINE__);
        }
        $this->FeaturedImageUrl = $featuredImageUrl;
        return $this;
    }
    /**
     * Get ProductDisplayTDSP value
     * @return \SGCIS\Array\ArrayOfProductDisplayTDSP|null
     */
    public function getProductDisplayTDSP()
    {
        return $this->ProductDisplayTDSP;
    }
    /**
     * Set ProductDisplayTDSP value
     * @param \SGCIS\Array\ArrayOfProductDisplayTDSP $productDisplayTDSP
     * @return \SGCIS\Struct\ProductDisplay
     */
    public function setProductDisplayTDSP(\SGCIS\Array\ArrayOfProductDisplayTDSP $productDisplayTDSP = null)
    {
        $this->ProductDisplayTDSP = $productDisplayTDSP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductDisplay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
