<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAudit Struct
 * @subpackage Structs
 */
class ProductAudit extends AbstractStructBase
{
    /**
     * The ProductAuditID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductAuditID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The ItemChanged
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemChanged;
    /**
     * The BeforeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BeforeValue;
    /**
     * The AfterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AfterValue;
    /**
     * Constructor method for ProductAudit
     * @uses ProductAudit::setProductAuditID()
     * @uses ProductAudit::setProductID()
     * @uses ProductAudit::setCreateDate()
     * @uses ProductAudit::setUserName()
     * @uses ProductAudit::setItemChanged()
     * @uses ProductAudit::setBeforeValue()
     * @uses ProductAudit::setAfterValue()
     * @param int $productAuditID
     * @param int $productID
     * @param string $createDate
     * @param string $userName
     * @param string $itemChanged
     * @param string $beforeValue
     * @param string $afterValue
     */
    public function __construct($productAuditID = null, $productID = null, $createDate = null, $userName = null, $itemChanged = null, $beforeValue = null, $afterValue = null)
    {
        $this
            ->setProductAuditID($productAuditID)
            ->setProductID($productID)
            ->setCreateDate($createDate)
            ->setUserName($userName)
            ->setItemChanged($itemChanged)
            ->setBeforeValue($beforeValue)
            ->setAfterValue($afterValue);
    }
    /**
     * Get ProductAuditID value
     * @return int
     */
    public function getProductAuditID()
    {
        return $this->ProductAuditID;
    }
    /**
     * Set ProductAuditID value
     * @param int $productAuditID
     * @return \SGCIS\Struct\ProductAudit
     */
    public function setProductAuditID($productAuditID = null)
    {
        // validation for constraint: int
        if (!is_null($productAuditID) && !is_numeric($productAuditID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productAuditID)), __LINE__);
        }
        $this->ProductAuditID = $productAuditID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductAudit
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ProductAudit
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\ProductAudit
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get ItemChanged value
     * @return string|null
     */
    public function getItemChanged()
    {
        return $this->ItemChanged;
    }
    /**
     * Set ItemChanged value
     * @param string $itemChanged
     * @return \SGCIS\Struct\ProductAudit
     */
    public function setItemChanged($itemChanged = null)
    {
        // validation for constraint: string
        if (!is_null($itemChanged) && !is_string($itemChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemChanged)), __LINE__);
        }
        $this->ItemChanged = $itemChanged;
        return $this;
    }
    /**
     * Get BeforeValue value
     * @return string|null
     */
    public function getBeforeValue()
    {
        return $this->BeforeValue;
    }
    /**
     * Set BeforeValue value
     * @param string $beforeValue
     * @return \SGCIS\Struct\ProductAudit
     */
    public function setBeforeValue($beforeValue = null)
    {
        // validation for constraint: string
        if (!is_null($beforeValue) && !is_string($beforeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beforeValue)), __LINE__);
        }
        $this->BeforeValue = $beforeValue;
        return $this;
    }
    /**
     * Get AfterValue value
     * @return string|null
     */
    public function getAfterValue()
    {
        return $this->AfterValue;
    }
    /**
     * Set AfterValue value
     * @param string $afterValue
     * @return \SGCIS\Struct\ProductAudit
     */
    public function setAfterValue($afterValue = null)
    {
        // validation for constraint: string
        if (!is_null($afterValue) && !is_string($afterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($afterValue)), __LINE__);
        }
        $this->AfterValue = $afterValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductAudit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
