<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonIDType Struct
 * @subpackage Structs
 */
class PersonIDType extends AbstractStructBase
{
    /**
     * The PersonIDTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonIDTypeID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PersonIDType
     * @uses PersonIDType::setPersonIDTypeID()
     * @uses PersonIDType::setName()
     * @uses PersonIDType::setDescription()
     * @param int $personIDTypeID
     * @param string $name
     * @param string $description
     */
    public function __construct($personIDTypeID = null, $name = null, $description = null)
    {
        $this
            ->setPersonIDTypeID($personIDTypeID)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get PersonIDTypeID value
     * @return int
     */
    public function getPersonIDTypeID()
    {
        return $this->PersonIDTypeID;
    }
    /**
     * Set PersonIDTypeID value
     * @param int $personIDTypeID
     * @return \SGCIS\Struct\PersonIDType
     */
    public function setPersonIDTypeID($personIDTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($personIDTypeID) && !is_numeric($personIDTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personIDTypeID)), __LINE__);
        }
        $this->PersonIDTypeID = $personIDTypeID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\PersonIDType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\PersonIDType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PersonIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
