<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentLocation Struct
 * @subpackage Structs
 */
class PaymentLocation extends BaseDAO
{
    /**
     * The PaymentLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentLocationID;
    /**
     * The PaymentLocationTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentLocationTypeID;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Distance;
    /**
     * The StoreName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreName;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateCode;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for PaymentLocation
     * @uses PaymentLocation::setPaymentLocationID()
     * @uses PaymentLocation::setPaymentLocationTypeID()
     * @uses PaymentLocation::setLongitude()
     * @uses PaymentLocation::setLatitude()
     * @uses PaymentLocation::setDistance()
     * @uses PaymentLocation::setStoreName()
     * @uses PaymentLocation::setAddress1()
     * @uses PaymentLocation::setAddress2()
     * @uses PaymentLocation::setCity()
     * @uses PaymentLocation::setStateCode()
     * @uses PaymentLocation::setZipCode()
     * @uses PaymentLocation::setPhoneNumber()
     * @param int $paymentLocationID
     * @param int $paymentLocationTypeID
     * @param float $longitude
     * @param float $latitude
     * @param float $distance
     * @param string $storeName
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $stateCode
     * @param string $zipCode
     * @param string $phoneNumber
     */
    public function __construct($paymentLocationID = null, $paymentLocationTypeID = null, $longitude = null, $latitude = null, $distance = null, $storeName = null, $address1 = null, $address2 = null, $city = null, $stateCode = null, $zipCode = null, $phoneNumber = null)
    {
        $this
            ->setPaymentLocationID($paymentLocationID)
            ->setPaymentLocationTypeID($paymentLocationTypeID)
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setDistance($distance)
            ->setStoreName($storeName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setStateCode($stateCode)
            ->setZipCode($zipCode)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get PaymentLocationID value
     * @return int
     */
    public function getPaymentLocationID()
    {
        return $this->PaymentLocationID;
    }
    /**
     * Set PaymentLocationID value
     * @param int $paymentLocationID
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setPaymentLocationID($paymentLocationID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentLocationID) && !is_numeric($paymentLocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentLocationID)), __LINE__);
        }
        $this->PaymentLocationID = $paymentLocationID;
        return $this;
    }
    /**
     * Get PaymentLocationTypeID value
     * @return int
     */
    public function getPaymentLocationTypeID()
    {
        return $this->PaymentLocationTypeID;
    }
    /**
     * Set PaymentLocationTypeID value
     * @param int $paymentLocationTypeID
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setPaymentLocationTypeID($paymentLocationTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentLocationTypeID) && !is_numeric($paymentLocationTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentLocationTypeID)), __LINE__);
        }
        $this->PaymentLocationTypeID = $paymentLocationTypeID;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Distance value
     * @return float
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setDistance($distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get StoreName value
     * @return string|null
     */
    public function getStoreName()
    {
        return $this->StoreName;
    }
    /**
     * Set StoreName value
     * @param string $storeName
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setStoreName($storeName = null)
    {
        // validation for constraint: string
        if (!is_null($storeName) && !is_string($storeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeName)), __LINE__);
        }
        $this->StoreName = $storeName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \SGCIS\Struct\PaymentLocation
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
