<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentArrangementSchedule Struct
 * @subpackage Structs
 */
class PaymentArrangementSchedule extends AbstractStructBase
{
    /**
     * The PaymentArrangementScheduleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementScheduleID;
    /**
     * The PaymentArrangementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementID;
    /**
     * The AmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountDue;
    /**
     * The PaymentDueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDueDate;
    /**
     * The PaymentProcessed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PaymentProcessed;
    /**
     * The PaymentSweepDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentSweepDate;
    /**
     * The PctOfTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PctOfTotal;
    /**
     * The PaymentRatioPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentRatioPct;
    /**
     * The BalanceOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceOwed;
    /**
     * The BalanceAfterPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceAfterPayment;
    /**
     * The PaymentAmountReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentAmountReceived;
    /**
     * The PaymentToAccelerate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PaymentToAccelerate;
    /**
     * The SystemNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemNotes;
    /**
     * Constructor method for PaymentArrangementSchedule
     * @uses PaymentArrangementSchedule::setPaymentArrangementScheduleID()
     * @uses PaymentArrangementSchedule::setPaymentArrangementID()
     * @uses PaymentArrangementSchedule::setAmountDue()
     * @uses PaymentArrangementSchedule::setPaymentDueDate()
     * @uses PaymentArrangementSchedule::setPaymentProcessed()
     * @uses PaymentArrangementSchedule::setPaymentSweepDate()
     * @uses PaymentArrangementSchedule::setPctOfTotal()
     * @uses PaymentArrangementSchedule::setPaymentRatioPct()
     * @uses PaymentArrangementSchedule::setBalanceOwed()
     * @uses PaymentArrangementSchedule::setBalanceAfterPayment()
     * @uses PaymentArrangementSchedule::setPaymentAmountReceived()
     * @uses PaymentArrangementSchedule::setPaymentToAccelerate()
     * @uses PaymentArrangementSchedule::setSystemNotes()
     * @param int $paymentArrangementScheduleID
     * @param int $paymentArrangementID
     * @param float $amountDue
     * @param string $paymentDueDate
     * @param bool $paymentProcessed
     * @param string $paymentSweepDate
     * @param float $pctOfTotal
     * @param float $paymentRatioPct
     * @param float $balanceOwed
     * @param float $balanceAfterPayment
     * @param float $paymentAmountReceived
     * @param bool $paymentToAccelerate
     * @param string $systemNotes
     */
    public function __construct($paymentArrangementScheduleID = null, $paymentArrangementID = null, $amountDue = null, $paymentDueDate = null, $paymentProcessed = null, $paymentSweepDate = null, $pctOfTotal = null, $paymentRatioPct = null, $balanceOwed = null, $balanceAfterPayment = null, $paymentAmountReceived = null, $paymentToAccelerate = null, $systemNotes = null)
    {
        $this
            ->setPaymentArrangementScheduleID($paymentArrangementScheduleID)
            ->setPaymentArrangementID($paymentArrangementID)
            ->setAmountDue($amountDue)
            ->setPaymentDueDate($paymentDueDate)
            ->setPaymentProcessed($paymentProcessed)
            ->setPaymentSweepDate($paymentSweepDate)
            ->setPctOfTotal($pctOfTotal)
            ->setPaymentRatioPct($paymentRatioPct)
            ->setBalanceOwed($balanceOwed)
            ->setBalanceAfterPayment($balanceAfterPayment)
            ->setPaymentAmountReceived($paymentAmountReceived)
            ->setPaymentToAccelerate($paymentToAccelerate)
            ->setSystemNotes($systemNotes);
    }
    /**
     * Get PaymentArrangementScheduleID value
     * @return int
     */
    public function getPaymentArrangementScheduleID()
    {
        return $this->PaymentArrangementScheduleID;
    }
    /**
     * Set PaymentArrangementScheduleID value
     * @param int $paymentArrangementScheduleID
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentArrangementScheduleID($paymentArrangementScheduleID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementScheduleID) && !is_numeric($paymentArrangementScheduleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementScheduleID)), __LINE__);
        }
        $this->PaymentArrangementScheduleID = $paymentArrangementScheduleID;
        return $this;
    }
    /**
     * Get PaymentArrangementID value
     * @return int
     */
    public function getPaymentArrangementID()
    {
        return $this->PaymentArrangementID;
    }
    /**
     * Set PaymentArrangementID value
     * @param int $paymentArrangementID
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentArrangementID($paymentArrangementID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementID) && !is_numeric($paymentArrangementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementID)), __LINE__);
        }
        $this->PaymentArrangementID = $paymentArrangementID;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setAmountDue($amountDue = null)
    {
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return string
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param string $paymentDueDate
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentDueDate($paymentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDueDate) && !is_string($paymentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDueDate)), __LINE__);
        }
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get PaymentProcessed value
     * @return bool
     */
    public function getPaymentProcessed()
    {
        return $this->PaymentProcessed;
    }
    /**
     * Set PaymentProcessed value
     * @param bool $paymentProcessed
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentProcessed($paymentProcessed = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentProcessed) && !is_bool($paymentProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentProcessed)), __LINE__);
        }
        $this->PaymentProcessed = $paymentProcessed;
        return $this;
    }
    /**
     * Get PaymentSweepDate value
     * @return string
     */
    public function getPaymentSweepDate()
    {
        return $this->PaymentSweepDate;
    }
    /**
     * Set PaymentSweepDate value
     * @param string $paymentSweepDate
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentSweepDate($paymentSweepDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSweepDate) && !is_string($paymentSweepDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentSweepDate)), __LINE__);
        }
        $this->PaymentSweepDate = $paymentSweepDate;
        return $this;
    }
    /**
     * Get PctOfTotal value
     * @return float
     */
    public function getPctOfTotal()
    {
        return $this->PctOfTotal;
    }
    /**
     * Set PctOfTotal value
     * @param float $pctOfTotal
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPctOfTotal($pctOfTotal = null)
    {
        $this->PctOfTotal = $pctOfTotal;
        return $this;
    }
    /**
     * Get PaymentRatioPct value
     * @return float
     */
    public function getPaymentRatioPct()
    {
        return $this->PaymentRatioPct;
    }
    /**
     * Set PaymentRatioPct value
     * @param float $paymentRatioPct
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentRatioPct($paymentRatioPct = null)
    {
        $this->PaymentRatioPct = $paymentRatioPct;
        return $this;
    }
    /**
     * Get BalanceOwed value
     * @return float
     */
    public function getBalanceOwed()
    {
        return $this->BalanceOwed;
    }
    /**
     * Set BalanceOwed value
     * @param float $balanceOwed
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setBalanceOwed($balanceOwed = null)
    {
        $this->BalanceOwed = $balanceOwed;
        return $this;
    }
    /**
     * Get BalanceAfterPayment value
     * @return float
     */
    public function getBalanceAfterPayment()
    {
        return $this->BalanceAfterPayment;
    }
    /**
     * Set BalanceAfterPayment value
     * @param float $balanceAfterPayment
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setBalanceAfterPayment($balanceAfterPayment = null)
    {
        $this->BalanceAfterPayment = $balanceAfterPayment;
        return $this;
    }
    /**
     * Get PaymentAmountReceived value
     * @return float
     */
    public function getPaymentAmountReceived()
    {
        return $this->PaymentAmountReceived;
    }
    /**
     * Set PaymentAmountReceived value
     * @param float $paymentAmountReceived
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentAmountReceived($paymentAmountReceived = null)
    {
        $this->PaymentAmountReceived = $paymentAmountReceived;
        return $this;
    }
    /**
     * Get PaymentToAccelerate value
     * @return bool
     */
    public function getPaymentToAccelerate()
    {
        return $this->PaymentToAccelerate;
    }
    /**
     * Set PaymentToAccelerate value
     * @param bool $paymentToAccelerate
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setPaymentToAccelerate($paymentToAccelerate = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentToAccelerate) && !is_bool($paymentToAccelerate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentToAccelerate)), __LINE__);
        }
        $this->PaymentToAccelerate = $paymentToAccelerate;
        return $this;
    }
    /**
     * Get SystemNotes value
     * @return string|null
     */
    public function getSystemNotes()
    {
        return $this->SystemNotes;
    }
    /**
     * Set SystemNotes value
     * @param string $systemNotes
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public function setSystemNotes($systemNotes = null)
    {
        // validation for constraint: string
        if (!is_null($systemNotes) && !is_string($systemNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemNotes)), __LINE__);
        }
        $this->SystemNotes = $systemNotes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentArrangementSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
