<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentArrangementReceivable Struct
 * @subpackage Structs
 */
class PaymentArrangementReceivable extends AbstractStructBase
{
    /**
     * The PaymentArrangementReceivableID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementReceivableID;
    /**
     * The PaymentArrangementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementID;
    /**
     * The ReceivablePriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceivablePriority;
    /**
     * The AmountOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountOwed;
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountPaid;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The ReceivableCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceivableCode;
    /**
     * Constructor method for PaymentArrangementReceivable
     * @uses PaymentArrangementReceivable::setPaymentArrangementReceivableID()
     * @uses PaymentArrangementReceivable::setPaymentArrangementID()
     * @uses PaymentArrangementReceivable::setReceivablePriority()
     * @uses PaymentArrangementReceivable::setAmountOwed()
     * @uses PaymentArrangementReceivable::setAmountPaid()
     * @uses PaymentArrangementReceivable::setCreateDate()
     * @uses PaymentArrangementReceivable::setReceivableCode()
     * @param int $paymentArrangementReceivableID
     * @param int $paymentArrangementID
     * @param int $receivablePriority
     * @param float $amountOwed
     * @param float $amountPaid
     * @param string $createDate
     * @param string $receivableCode
     */
    public function __construct($paymentArrangementReceivableID = null, $paymentArrangementID = null, $receivablePriority = null, $amountOwed = null, $amountPaid = null, $createDate = null, $receivableCode = null)
    {
        $this
            ->setPaymentArrangementReceivableID($paymentArrangementReceivableID)
            ->setPaymentArrangementID($paymentArrangementID)
            ->setReceivablePriority($receivablePriority)
            ->setAmountOwed($amountOwed)
            ->setAmountPaid($amountPaid)
            ->setCreateDate($createDate)
            ->setReceivableCode($receivableCode);
    }
    /**
     * Get PaymentArrangementReceivableID value
     * @return int
     */
    public function getPaymentArrangementReceivableID()
    {
        return $this->PaymentArrangementReceivableID;
    }
    /**
     * Set PaymentArrangementReceivableID value
     * @param int $paymentArrangementReceivableID
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public function setPaymentArrangementReceivableID($paymentArrangementReceivableID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementReceivableID) && !is_numeric($paymentArrangementReceivableID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementReceivableID)), __LINE__);
        }
        $this->PaymentArrangementReceivableID = $paymentArrangementReceivableID;
        return $this;
    }
    /**
     * Get PaymentArrangementID value
     * @return int
     */
    public function getPaymentArrangementID()
    {
        return $this->PaymentArrangementID;
    }
    /**
     * Set PaymentArrangementID value
     * @param int $paymentArrangementID
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public function setPaymentArrangementID($paymentArrangementID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementID) && !is_numeric($paymentArrangementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementID)), __LINE__);
        }
        $this->PaymentArrangementID = $paymentArrangementID;
        return $this;
    }
    /**
     * Get ReceivablePriority value
     * @return int
     */
    public function getReceivablePriority()
    {
        return $this->ReceivablePriority;
    }
    /**
     * Set ReceivablePriority value
     * @param int $receivablePriority
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public function setReceivablePriority($receivablePriority = null)
    {
        // validation for constraint: int
        if (!is_null($receivablePriority) && !is_numeric($receivablePriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($receivablePriority)), __LINE__);
        }
        $this->ReceivablePriority = $receivablePriority;
        return $this;
    }
    /**
     * Get AmountOwed value
     * @return float
     */
    public function getAmountOwed()
    {
        return $this->AmountOwed;
    }
    /**
     * Set AmountOwed value
     * @param float $amountOwed
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public function setAmountOwed($amountOwed = null)
    {
        $this->AmountOwed = $amountOwed;
        return $this;
    }
    /**
     * Get AmountPaid value
     * @return float
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param float $amountPaid
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public function setAmountPaid($amountPaid = null)
    {
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get ReceivableCode value
     * @return string|null
     */
    public function getReceivableCode()
    {
        return $this->ReceivableCode;
    }
    /**
     * Set ReceivableCode value
     * @param string $receivableCode
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public function setReceivableCode($receivableCode = null)
    {
        // validation for constraint: string
        if (!is_null($receivableCode) && !is_string($receivableCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receivableCode)), __LINE__);
        }
        $this->ReceivableCode = $receivableCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentArrangementReceivable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
