<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationChannel Struct
 * @subpackage Structs
 */
class NotificationChannel extends AbstractStructBase
{
    /**
     * The NotificationChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NotificationChannelID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The NotificationProcessor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationProcessor;
    /**
     * Constructor method for NotificationChannel
     * @uses NotificationChannel::setNotificationChannelID()
     * @uses NotificationChannel::setName()
     * @uses NotificationChannel::setDescription()
     * @uses NotificationChannel::setNotificationProcessor()
     * @param int $notificationChannelID
     * @param string $name
     * @param string $description
     * @param string $notificationProcessor
     */
    public function __construct($notificationChannelID = null, $name = null, $description = null, $notificationProcessor = null)
    {
        $this
            ->setNotificationChannelID($notificationChannelID)
            ->setName($name)
            ->setDescription($description)
            ->setNotificationProcessor($notificationProcessor);
    }
    /**
     * Get NotificationChannelID value
     * @return int
     */
    public function getNotificationChannelID()
    {
        return $this->NotificationChannelID;
    }
    /**
     * Set NotificationChannelID value
     * @param int $notificationChannelID
     * @return \SGCIS\Struct\NotificationChannel
     */
    public function setNotificationChannelID($notificationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($notificationChannelID) && !is_numeric($notificationChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notificationChannelID)), __LINE__);
        }
        $this->NotificationChannelID = $notificationChannelID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\NotificationChannel
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\NotificationChannel
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get NotificationProcessor value
     * @return string|null
     */
    public function getNotificationProcessor()
    {
        return $this->NotificationProcessor;
    }
    /**
     * Set NotificationProcessor value
     * @param string $notificationProcessor
     * @return \SGCIS\Struct\NotificationChannel
     */
    public function setNotificationProcessor($notificationProcessor = null)
    {
        // validation for constraint: string
        if (!is_null($notificationProcessor) && !is_string($notificationProcessor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationProcessor)), __LINE__);
        }
        $this->NotificationProcessor = $notificationProcessor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\NotificationChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
