<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterRead Struct
 * @subpackage Structs
 */
class MeterRead extends AbstractStructBase
{
    /**
     * The MeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadID;
    /**
     * The MeterReadStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadStatusID;
    /**
     * The MeterReadTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadTypeID;
    /**
     * The VersionedMeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VersionedMeterReadID;
    /**
     * The IsDuplicate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDuplicate;
    /**
     * The VersionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VersionNumber;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The StartRegisterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StartRegisterValue;
    /**
     * The EndRegisterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EndRegisterValue;
    /**
     * The TotalConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalConsumption;
    /**
     * The RateValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateValue;
    /**
     * The TotalCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCharges;
    /**
     * The UnitOfMeasureID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitOfMeasureID;
    /**
     * The IntervalLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IntervalLength;
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToDate;
    /**
     * The BillDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillDate;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsCurrentVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCurrentVersion;
    /**
     * The MarketTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MarketTransactionID;
    /**
     * The BillStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusID;
    /**
     * The IsEstimated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEstimated;
    /**
     * The EnergyChargePortion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EnergyChargePortion;
    /**
     * The RateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RateDate;
    /**
     * The IsPosted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPosted;
    /**
     * The AccountStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusID;
    /**
     * The IsBilled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBilled;
    /**
     * The IsBilledAsAdjustment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBilledAsAdjustment;
    /**
     * The TotalAdjustmentUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAdjustmentUsage;
    /**
     * The MarketDocumentTrackingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketDocumentTrackingNumber;
    /**
     * The ReadSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReadSource;
    /**
     * The MeterIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterIdentifier;
    /**
     * The LocationIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationIdentifier;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The UnitOfMeasureName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasureName;
    /**
     * The UnitOfMeasureCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The SourceFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceFile;
    /**
     * The MeterReadStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterReadStatusName;
    /**
     * The MeterReadDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterReadDetail
     */
    public $MeterReadDetails;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillNumber;
    /**
     * The RatingErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RatingErrorMessage;
    /**
     * The ChannelNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChannelNumber;
    /**
     * The MeterReadRatingComponents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterReadRatingComponent
     */
    public $MeterReadRatingComponents;
    /**
     * The ChargeCodeStr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCodeStr;
    /**
     * Constructor method for MeterRead
     * @uses MeterRead::setMeterReadID()
     * @uses MeterRead::setMeterReadStatusID()
     * @uses MeterRead::setMeterReadTypeID()
     * @uses MeterRead::setVersionedMeterReadID()
     * @uses MeterRead::setIsDuplicate()
     * @uses MeterRead::setVersionNumber()
     * @uses MeterRead::setAccountID()
     * @uses MeterRead::setAccountServicePointID()
     * @uses MeterRead::setStartRegisterValue()
     * @uses MeterRead::setEndRegisterValue()
     * @uses MeterRead::setTotalConsumption()
     * @uses MeterRead::setRateValue()
     * @uses MeterRead::setTotalCharges()
     * @uses MeterRead::setUnitOfMeasureID()
     * @uses MeterRead::setIntervalLength()
     * @uses MeterRead::setFromDate()
     * @uses MeterRead::setToDate()
     * @uses MeterRead::setBillDate()
     * @uses MeterRead::setCreateDate()
     * @uses MeterRead::setIsCurrentVersion()
     * @uses MeterRead::setMarketTransactionID()
     * @uses MeterRead::setBillStatusID()
     * @uses MeterRead::setIsEstimated()
     * @uses MeterRead::setEnergyChargePortion()
     * @uses MeterRead::setRateDate()
     * @uses MeterRead::setIsPosted()
     * @uses MeterRead::setAccountStatusID()
     * @uses MeterRead::setIsBilled()
     * @uses MeterRead::setIsBilledAsAdjustment()
     * @uses MeterRead::setTotalAdjustmentUsage()
     * @uses MeterRead::setMarketDocumentTrackingNumber()
     * @uses MeterRead::setReadSource()
     * @uses MeterRead::setMeterIdentifier()
     * @uses MeterRead::setLocationIdentifier()
     * @uses MeterRead::setServiceProviderIdentifier()
     * @uses MeterRead::setAccountNumber()
     * @uses MeterRead::setAccountStatusName()
     * @uses MeterRead::setUnitOfMeasureName()
     * @uses MeterRead::setUnitOfMeasureCode()
     * @uses MeterRead::setSourceFile()
     * @uses MeterRead::setMeterReadStatusName()
     * @uses MeterRead::setMeterReadDetails()
     * @uses MeterRead::setBillNumber()
     * @uses MeterRead::setRatingErrorMessage()
     * @uses MeterRead::setChannelNumber()
     * @uses MeterRead::setMeterReadRatingComponents()
     * @uses MeterRead::setChargeCodeStr()
     * @param int $meterReadID
     * @param int $meterReadStatusID
     * @param int $meterReadTypeID
     * @param int $versionedMeterReadID
     * @param bool $isDuplicate
     * @param int $versionNumber
     * @param int $accountID
     * @param int $accountServicePointID
     * @param float $startRegisterValue
     * @param float $endRegisterValue
     * @param float $totalConsumption
     * @param float $rateValue
     * @param float $totalCharges
     * @param int $unitOfMeasureID
     * @param int $intervalLength
     * @param string $fromDate
     * @param string $toDate
     * @param string $billDate
     * @param string $createDate
     * @param bool $isCurrentVersion
     * @param int $marketTransactionID
     * @param int $billStatusID
     * @param bool $isEstimated
     * @param float $energyChargePortion
     * @param string $rateDate
     * @param bool $isPosted
     * @param int $accountStatusID
     * @param bool $isBilled
     * @param bool $isBilledAsAdjustment
     * @param float $totalAdjustmentUsage
     * @param string $marketDocumentTrackingNumber
     * @param string $readSource
     * @param string $meterIdentifier
     * @param string $locationIdentifier
     * @param string $serviceProviderIdentifier
     * @param string $accountNumber
     * @param string $accountStatusName
     * @param string $unitOfMeasureName
     * @param string $unitOfMeasureCode
     * @param string $sourceFile
     * @param string $meterReadStatusName
     * @param \SGCIS\Array\ArrayOfMeterReadDetail $meterReadDetails
     * @param string $billNumber
     * @param string $ratingErrorMessage
     * @param string $channelNumber
     * @param \SGCIS\Array\ArrayOfMeterReadRatingComponent $meterReadRatingComponents
     * @param string $chargeCodeStr
     */
    public function __construct($meterReadID = null, $meterReadStatusID = null, $meterReadTypeID = null, $versionedMeterReadID = null, $isDuplicate = null, $versionNumber = null, $accountID = null, $accountServicePointID = null, $startRegisterValue = null, $endRegisterValue = null, $totalConsumption = null, $rateValue = null, $totalCharges = null, $unitOfMeasureID = null, $intervalLength = null, $fromDate = null, $toDate = null, $billDate = null, $createDate = null, $isCurrentVersion = null, $marketTransactionID = null, $billStatusID = null, $isEstimated = null, $energyChargePortion = null, $rateDate = null, $isPosted = null, $accountStatusID = null, $isBilled = null, $isBilledAsAdjustment = null, $totalAdjustmentUsage = null, $marketDocumentTrackingNumber = null, $readSource = null, $meterIdentifier = null, $locationIdentifier = null, $serviceProviderIdentifier = null, $accountNumber = null, $accountStatusName = null, $unitOfMeasureName = null, $unitOfMeasureCode = null, $sourceFile = null, $meterReadStatusName = null, \SGCIS\Array\ArrayOfMeterReadDetail $meterReadDetails = null, $billNumber = null, $ratingErrorMessage = null, $channelNumber = null, \SGCIS\Array\ArrayOfMeterReadRatingComponent $meterReadRatingComponents = null, $chargeCodeStr = null)
    {
        $this
            ->setMeterReadID($meterReadID)
            ->setMeterReadStatusID($meterReadStatusID)
            ->setMeterReadTypeID($meterReadTypeID)
            ->setVersionedMeterReadID($versionedMeterReadID)
            ->setIsDuplicate($isDuplicate)
            ->setVersionNumber($versionNumber)
            ->setAccountID($accountID)
            ->setAccountServicePointID($accountServicePointID)
            ->setStartRegisterValue($startRegisterValue)
            ->setEndRegisterValue($endRegisterValue)
            ->setTotalConsumption($totalConsumption)
            ->setRateValue($rateValue)
            ->setTotalCharges($totalCharges)
            ->setUnitOfMeasureID($unitOfMeasureID)
            ->setIntervalLength($intervalLength)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setBillDate($billDate)
            ->setCreateDate($createDate)
            ->setIsCurrentVersion($isCurrentVersion)
            ->setMarketTransactionID($marketTransactionID)
            ->setBillStatusID($billStatusID)
            ->setIsEstimated($isEstimated)
            ->setEnergyChargePortion($energyChargePortion)
            ->setRateDate($rateDate)
            ->setIsPosted($isPosted)
            ->setAccountStatusID($accountStatusID)
            ->setIsBilled($isBilled)
            ->setIsBilledAsAdjustment($isBilledAsAdjustment)
            ->setTotalAdjustmentUsage($totalAdjustmentUsage)
            ->setMarketDocumentTrackingNumber($marketDocumentTrackingNumber)
            ->setReadSource($readSource)
            ->setMeterIdentifier($meterIdentifier)
            ->setLocationIdentifier($locationIdentifier)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setAccountNumber($accountNumber)
            ->setAccountStatusName($accountStatusName)
            ->setUnitOfMeasureName($unitOfMeasureName)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setSourceFile($sourceFile)
            ->setMeterReadStatusName($meterReadStatusName)
            ->setMeterReadDetails($meterReadDetails)
            ->setBillNumber($billNumber)
            ->setRatingErrorMessage($ratingErrorMessage)
            ->setChannelNumber($channelNumber)
            ->setMeterReadRatingComponents($meterReadRatingComponents)
            ->setChargeCodeStr($chargeCodeStr);
    }
    /**
     * Get MeterReadID value
     * @return int
     */
    public function getMeterReadID()
    {
        return $this->MeterReadID;
    }
    /**
     * Set MeterReadID value
     * @param int $meterReadID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMeterReadID($meterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadID) && !is_numeric($meterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadID)), __LINE__);
        }
        $this->MeterReadID = $meterReadID;
        return $this;
    }
    /**
     * Get MeterReadStatusID value
     * @return int
     */
    public function getMeterReadStatusID()
    {
        return $this->MeterReadStatusID;
    }
    /**
     * Set MeterReadStatusID value
     * @param int $meterReadStatusID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMeterReadStatusID($meterReadStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadStatusID) && !is_numeric($meterReadStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadStatusID)), __LINE__);
        }
        $this->MeterReadStatusID = $meterReadStatusID;
        return $this;
    }
    /**
     * Get MeterReadTypeID value
     * @return int
     */
    public function getMeterReadTypeID()
    {
        return $this->MeterReadTypeID;
    }
    /**
     * Set MeterReadTypeID value
     * @param int $meterReadTypeID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMeterReadTypeID($meterReadTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadTypeID) && !is_numeric($meterReadTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadTypeID)), __LINE__);
        }
        $this->MeterReadTypeID = $meterReadTypeID;
        return $this;
    }
    /**
     * Get VersionedMeterReadID value
     * @return int
     */
    public function getVersionedMeterReadID()
    {
        return $this->VersionedMeterReadID;
    }
    /**
     * Set VersionedMeterReadID value
     * @param int $versionedMeterReadID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setVersionedMeterReadID($versionedMeterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($versionedMeterReadID) && !is_numeric($versionedMeterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionedMeterReadID)), __LINE__);
        }
        $this->VersionedMeterReadID = $versionedMeterReadID;
        return $this;
    }
    /**
     * Get IsDuplicate value
     * @return bool
     */
    public function getIsDuplicate()
    {
        return $this->IsDuplicate;
    }
    /**
     * Set IsDuplicate value
     * @param bool $isDuplicate
     * @return \SGCIS\Struct\MeterRead
     */
    public function setIsDuplicate($isDuplicate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDuplicate) && !is_bool($isDuplicate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDuplicate)), __LINE__);
        }
        $this->IsDuplicate = $isDuplicate;
        return $this;
    }
    /**
     * Get VersionNumber value
     * @return int
     */
    public function getVersionNumber()
    {
        return $this->VersionNumber;
    }
    /**
     * Set VersionNumber value
     * @param int $versionNumber
     * @return \SGCIS\Struct\MeterRead
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !is_numeric($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionNumber)), __LINE__);
        }
        $this->VersionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get StartRegisterValue value
     * @return float
     */
    public function getStartRegisterValue()
    {
        return $this->StartRegisterValue;
    }
    /**
     * Set StartRegisterValue value
     * @param float $startRegisterValue
     * @return \SGCIS\Struct\MeterRead
     */
    public function setStartRegisterValue($startRegisterValue = null)
    {
        $this->StartRegisterValue = $startRegisterValue;
        return $this;
    }
    /**
     * Get EndRegisterValue value
     * @return float
     */
    public function getEndRegisterValue()
    {
        return $this->EndRegisterValue;
    }
    /**
     * Set EndRegisterValue value
     * @param float $endRegisterValue
     * @return \SGCIS\Struct\MeterRead
     */
    public function setEndRegisterValue($endRegisterValue = null)
    {
        $this->EndRegisterValue = $endRegisterValue;
        return $this;
    }
    /**
     * Get TotalConsumption value
     * @return float
     */
    public function getTotalConsumption()
    {
        return $this->TotalConsumption;
    }
    /**
     * Set TotalConsumption value
     * @param float $totalConsumption
     * @return \SGCIS\Struct\MeterRead
     */
    public function setTotalConsumption($totalConsumption = null)
    {
        $this->TotalConsumption = $totalConsumption;
        return $this;
    }
    /**
     * Get RateValue value
     * @return float
     */
    public function getRateValue()
    {
        return $this->RateValue;
    }
    /**
     * Set RateValue value
     * @param float $rateValue
     * @return \SGCIS\Struct\MeterRead
     */
    public function setRateValue($rateValue = null)
    {
        $this->RateValue = $rateValue;
        return $this;
    }
    /**
     * Get TotalCharges value
     * @return float
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param float $totalCharges
     * @return \SGCIS\Struct\MeterRead
     */
    public function setTotalCharges($totalCharges = null)
    {
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get UnitOfMeasureID value
     * @return int
     */
    public function getUnitOfMeasureID()
    {
        return $this->UnitOfMeasureID;
    }
    /**
     * Set UnitOfMeasureID value
     * @param int $unitOfMeasureID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setUnitOfMeasureID($unitOfMeasureID = null)
    {
        // validation for constraint: int
        if (!is_null($unitOfMeasureID) && !is_numeric($unitOfMeasureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitOfMeasureID)), __LINE__);
        }
        $this->UnitOfMeasureID = $unitOfMeasureID;
        return $this;
    }
    /**
     * Get IntervalLength value
     * @return int
     */
    public function getIntervalLength()
    {
        return $this->IntervalLength;
    }
    /**
     * Set IntervalLength value
     * @param int $intervalLength
     * @return \SGCIS\Struct\MeterRead
     */
    public function setIntervalLength($intervalLength = null)
    {
        // validation for constraint: int
        if (!is_null($intervalLength) && !is_numeric($intervalLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($intervalLength)), __LINE__);
        }
        $this->IntervalLength = $intervalLength;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \SGCIS\Struct\MeterRead
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \SGCIS\Struct\MeterRead
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get BillDate value
     * @return string
     */
    public function getBillDate()
    {
        return $this->BillDate;
    }
    /**
     * Set BillDate value
     * @param string $billDate
     * @return \SGCIS\Struct\MeterRead
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDate)), __LINE__);
        }
        $this->BillDate = $billDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\MeterRead
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsCurrentVersion value
     * @return bool
     */
    public function getIsCurrentVersion()
    {
        return $this->IsCurrentVersion;
    }
    /**
     * Set IsCurrentVersion value
     * @param bool $isCurrentVersion
     * @return \SGCIS\Struct\MeterRead
     */
    public function setIsCurrentVersion($isCurrentVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCurrentVersion) && !is_bool($isCurrentVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCurrentVersion)), __LINE__);
        }
        $this->IsCurrentVersion = $isCurrentVersion;
        return $this;
    }
    /**
     * Get MarketTransactionID value
     * @return int
     */
    public function getMarketTransactionID()
    {
        return $this->MarketTransactionID;
    }
    /**
     * Set MarketTransactionID value
     * @param int $marketTransactionID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMarketTransactionID($marketTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($marketTransactionID) && !is_numeric($marketTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marketTransactionID)), __LINE__);
        }
        $this->MarketTransactionID = $marketTransactionID;
        return $this;
    }
    /**
     * Get BillStatusID value
     * @return int
     */
    public function getBillStatusID()
    {
        return $this->BillStatusID;
    }
    /**
     * Set BillStatusID value
     * @param int $billStatusID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setBillStatusID($billStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusID) && !is_numeric($billStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusID)), __LINE__);
        }
        $this->BillStatusID = $billStatusID;
        return $this;
    }
    /**
     * Get IsEstimated value
     * @return bool
     */
    public function getIsEstimated()
    {
        return $this->IsEstimated;
    }
    /**
     * Set IsEstimated value
     * @param bool $isEstimated
     * @return \SGCIS\Struct\MeterRead
     */
    public function setIsEstimated($isEstimated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEstimated) && !is_bool($isEstimated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEstimated)), __LINE__);
        }
        $this->IsEstimated = $isEstimated;
        return $this;
    }
    /**
     * Get EnergyChargePortion value
     * @return float
     */
    public function getEnergyChargePortion()
    {
        return $this->EnergyChargePortion;
    }
    /**
     * Set EnergyChargePortion value
     * @param float $energyChargePortion
     * @return \SGCIS\Struct\MeterRead
     */
    public function setEnergyChargePortion($energyChargePortion = null)
    {
        $this->EnergyChargePortion = $energyChargePortion;
        return $this;
    }
    /**
     * Get RateDate value
     * @return string
     */
    public function getRateDate()
    {
        return $this->RateDate;
    }
    /**
     * Set RateDate value
     * @param string $rateDate
     * @return \SGCIS\Struct\MeterRead
     */
    public function setRateDate($rateDate = null)
    {
        // validation for constraint: string
        if (!is_null($rateDate) && !is_string($rateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateDate)), __LINE__);
        }
        $this->RateDate = $rateDate;
        return $this;
    }
    /**
     * Get IsPosted value
     * @return bool
     */
    public function getIsPosted()
    {
        return $this->IsPosted;
    }
    /**
     * Set IsPosted value
     * @param bool $isPosted
     * @return \SGCIS\Struct\MeterRead
     */
    public function setIsPosted($isPosted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPosted) && !is_bool($isPosted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPosted)), __LINE__);
        }
        $this->IsPosted = $isPosted;
        return $this;
    }
    /**
     * Get AccountStatusID value
     * @return int
     */
    public function getAccountStatusID()
    {
        return $this->AccountStatusID;
    }
    /**
     * Set AccountStatusID value
     * @param int $accountStatusID
     * @return \SGCIS\Struct\MeterRead
     */
    public function setAccountStatusID($accountStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusID) && !is_numeric($accountStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusID)), __LINE__);
        }
        $this->AccountStatusID = $accountStatusID;
        return $this;
    }
    /**
     * Get IsBilled value
     * @return bool
     */
    public function getIsBilled()
    {
        return $this->IsBilled;
    }
    /**
     * Set IsBilled value
     * @param bool $isBilled
     * @return \SGCIS\Struct\MeterRead
     */
    public function setIsBilled($isBilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBilled) && !is_bool($isBilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBilled)), __LINE__);
        }
        $this->IsBilled = $isBilled;
        return $this;
    }
    /**
     * Get IsBilledAsAdjustment value
     * @return bool
     */
    public function getIsBilledAsAdjustment()
    {
        return $this->IsBilledAsAdjustment;
    }
    /**
     * Set IsBilledAsAdjustment value
     * @param bool $isBilledAsAdjustment
     * @return \SGCIS\Struct\MeterRead
     */
    public function setIsBilledAsAdjustment($isBilledAsAdjustment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBilledAsAdjustment) && !is_bool($isBilledAsAdjustment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBilledAsAdjustment)), __LINE__);
        }
        $this->IsBilledAsAdjustment = $isBilledAsAdjustment;
        return $this;
    }
    /**
     * Get TotalAdjustmentUsage value
     * @return float
     */
    public function getTotalAdjustmentUsage()
    {
        return $this->TotalAdjustmentUsage;
    }
    /**
     * Set TotalAdjustmentUsage value
     * @param float $totalAdjustmentUsage
     * @return \SGCIS\Struct\MeterRead
     */
    public function setTotalAdjustmentUsage($totalAdjustmentUsage = null)
    {
        $this->TotalAdjustmentUsage = $totalAdjustmentUsage;
        return $this;
    }
    /**
     * Get MarketDocumentTrackingNumber value
     * @return string|null
     */
    public function getMarketDocumentTrackingNumber()
    {
        return $this->MarketDocumentTrackingNumber;
    }
    /**
     * Set MarketDocumentTrackingNumber value
     * @param string $marketDocumentTrackingNumber
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMarketDocumentTrackingNumber($marketDocumentTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($marketDocumentTrackingNumber) && !is_string($marketDocumentTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketDocumentTrackingNumber)), __LINE__);
        }
        $this->MarketDocumentTrackingNumber = $marketDocumentTrackingNumber;
        return $this;
    }
    /**
     * Get ReadSource value
     * @return string|null
     */
    public function getReadSource()
    {
        return $this->ReadSource;
    }
    /**
     * Set ReadSource value
     * @param string $readSource
     * @return \SGCIS\Struct\MeterRead
     */
    public function setReadSource($readSource = null)
    {
        // validation for constraint: string
        if (!is_null($readSource) && !is_string($readSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readSource)), __LINE__);
        }
        $this->ReadSource = $readSource;
        return $this;
    }
    /**
     * Get MeterIdentifier value
     * @return string|null
     */
    public function getMeterIdentifier()
    {
        return $this->MeterIdentifier;
    }
    /**
     * Set MeterIdentifier value
     * @param string $meterIdentifier
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMeterIdentifier($meterIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($meterIdentifier) && !is_string($meterIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterIdentifier)), __LINE__);
        }
        $this->MeterIdentifier = $meterIdentifier;
        return $this;
    }
    /**
     * Get LocationIdentifier value
     * @return string|null
     */
    public function getLocationIdentifier()
    {
        return $this->LocationIdentifier;
    }
    /**
     * Set LocationIdentifier value
     * @param string $locationIdentifier
     * @return \SGCIS\Struct\MeterRead
     */
    public function setLocationIdentifier($locationIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($locationIdentifier) && !is_string($locationIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationIdentifier)), __LINE__);
        }
        $this->LocationIdentifier = $locationIdentifier;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\MeterRead
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\MeterRead
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\MeterRead
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get UnitOfMeasureName value
     * @return string|null
     */
    public function getUnitOfMeasureName()
    {
        return $this->UnitOfMeasureName;
    }
    /**
     * Set UnitOfMeasureName value
     * @param string $unitOfMeasureName
     * @return \SGCIS\Struct\MeterRead
     */
    public function setUnitOfMeasureName($unitOfMeasureName = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureName) && !is_string($unitOfMeasureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasureName)), __LINE__);
        }
        $this->UnitOfMeasureName = $unitOfMeasureName;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \SGCIS\Struct\MeterRead
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasureCode)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get SourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->SourceFile;
    }
    /**
     * Set SourceFile value
     * @param string $sourceFile
     * @return \SGCIS\Struct\MeterRead
     */
    public function setSourceFile($sourceFile = null)
    {
        // validation for constraint: string
        if (!is_null($sourceFile) && !is_string($sourceFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceFile)), __LINE__);
        }
        $this->SourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get MeterReadStatusName value
     * @return string|null
     */
    public function getMeterReadStatusName()
    {
        return $this->MeterReadStatusName;
    }
    /**
     * Set MeterReadStatusName value
     * @param string $meterReadStatusName
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMeterReadStatusName($meterReadStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($meterReadStatusName) && !is_string($meterReadStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterReadStatusName)), __LINE__);
        }
        $this->MeterReadStatusName = $meterReadStatusName;
        return $this;
    }
    /**
     * Get MeterReadDetails value
     * @return \SGCIS\Array\ArrayOfMeterReadDetail|null
     */
    public function getMeterReadDetails()
    {
        return $this->MeterReadDetails;
    }
    /**
     * Set MeterReadDetails value
     * @param \SGCIS\Array\ArrayOfMeterReadDetail $meterReadDetails
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMeterReadDetails(\SGCIS\Array\ArrayOfMeterReadDetail $meterReadDetails = null)
    {
        $this->MeterReadDetails = $meterReadDetails;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \SGCIS\Struct\MeterRead
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Get RatingErrorMessage value
     * @return string|null
     */
    public function getRatingErrorMessage()
    {
        return $this->RatingErrorMessage;
    }
    /**
     * Set RatingErrorMessage value
     * @param string $ratingErrorMessage
     * @return \SGCIS\Struct\MeterRead
     */
    public function setRatingErrorMessage($ratingErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($ratingErrorMessage) && !is_string($ratingErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratingErrorMessage)), __LINE__);
        }
        $this->RatingErrorMessage = $ratingErrorMessage;
        return $this;
    }
    /**
     * Get ChannelNumber value
     * @return string|null
     */
    public function getChannelNumber()
    {
        return $this->ChannelNumber;
    }
    /**
     * Set ChannelNumber value
     * @param string $channelNumber
     * @return \SGCIS\Struct\MeterRead
     */
    public function setChannelNumber($channelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($channelNumber) && !is_string($channelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channelNumber)), __LINE__);
        }
        $this->ChannelNumber = $channelNumber;
        return $this;
    }
    /**
     * Get MeterReadRatingComponents value
     * @return \SGCIS\Array\ArrayOfMeterReadRatingComponent|null
     */
    public function getMeterReadRatingComponents()
    {
        return $this->MeterReadRatingComponents;
    }
    /**
     * Set MeterReadRatingComponents value
     * @param \SGCIS\Array\ArrayOfMeterReadRatingComponent $meterReadRatingComponents
     * @return \SGCIS\Struct\MeterRead
     */
    public function setMeterReadRatingComponents(\SGCIS\Array\ArrayOfMeterReadRatingComponent $meterReadRatingComponents = null)
    {
        $this->MeterReadRatingComponents = $meterReadRatingComponents;
        return $this;
    }
    /**
     * Get ChargeCodeStr value
     * @return string|null
     */
    public function getChargeCodeStr()
    {
        return $this->ChargeCodeStr;
    }
    /**
     * Set ChargeCodeStr value
     * @param string $chargeCodeStr
     * @return \SGCIS\Struct\MeterRead
     */
    public function setChargeCodeStr($chargeCodeStr = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCodeStr) && !is_string($chargeCodeStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCodeStr)), __LINE__);
        }
        $this->ChargeCodeStr = $chargeCodeStr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterRead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
