<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HistoricalConsumptionUsageReport Struct
 * @subpackage Structs
 */
class HistoricalConsumptionUsageReport extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The AccountServicePointId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointId;
    /**
     * The ConsumptionYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConsumptionYear;
    /**
     * The ConsumptionMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConsumptionMonth;
    /**
     * The PeriodStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The CalculatedConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CalculatedConsumption;
    /**
     * The HistoricalConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $HistoricalConsumption;
    /**
     * The Difference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Difference;
    /**
     * Constructor method for HistoricalConsumptionUsageReport
     * @uses HistoricalConsumptionUsageReport::setAccountId()
     * @uses HistoricalConsumptionUsageReport::setAccountServicePointId()
     * @uses HistoricalConsumptionUsageReport::setConsumptionYear()
     * @uses HistoricalConsumptionUsageReport::setConsumptionMonth()
     * @uses HistoricalConsumptionUsageReport::setPeriodStartDate()
     * @uses HistoricalConsumptionUsageReport::setPeriodEndDate()
     * @uses HistoricalConsumptionUsageReport::setCalculatedConsumption()
     * @uses HistoricalConsumptionUsageReport::setHistoricalConsumption()
     * @uses HistoricalConsumptionUsageReport::setDifference()
     * @param int $accountId
     * @param int $accountServicePointId
     * @param int $consumptionYear
     * @param int $consumptionMonth
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param float $calculatedConsumption
     * @param float $historicalConsumption
     * @param float $difference
     */
    public function __construct($accountId = null, $accountServicePointId = null, $consumptionYear = null, $consumptionMonth = null, $periodStartDate = null, $periodEndDate = null, $calculatedConsumption = null, $historicalConsumption = null, $difference = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAccountServicePointId($accountServicePointId)
            ->setConsumptionYear($consumptionYear)
            ->setConsumptionMonth($consumptionMonth)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setCalculatedConsumption($calculatedConsumption)
            ->setHistoricalConsumption($historicalConsumption)
            ->setDifference($difference);
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !is_numeric($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AccountServicePointId value
     * @return int
     */
    public function getAccountServicePointId()
    {
        return $this->AccountServicePointId;
    }
    /**
     * Set AccountServicePointId value
     * @param int $accountServicePointId
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setAccountServicePointId($accountServicePointId = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointId) && !is_numeric($accountServicePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointId)), __LINE__);
        }
        $this->AccountServicePointId = $accountServicePointId;
        return $this;
    }
    /**
     * Get ConsumptionYear value
     * @return int
     */
    public function getConsumptionYear()
    {
        return $this->ConsumptionYear;
    }
    /**
     * Set ConsumptionYear value
     * @param int $consumptionYear
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setConsumptionYear($consumptionYear = null)
    {
        // validation for constraint: int
        if (!is_null($consumptionYear) && !is_numeric($consumptionYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($consumptionYear)), __LINE__);
        }
        $this->ConsumptionYear = $consumptionYear;
        return $this;
    }
    /**
     * Get ConsumptionMonth value
     * @return int
     */
    public function getConsumptionMonth()
    {
        return $this->ConsumptionMonth;
    }
    /**
     * Set ConsumptionMonth value
     * @param int $consumptionMonth
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setConsumptionMonth($consumptionMonth = null)
    {
        // validation for constraint: int
        if (!is_null($consumptionMonth) && !is_numeric($consumptionMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($consumptionMonth)), __LINE__);
        }
        $this->ConsumptionMonth = $consumptionMonth;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get CalculatedConsumption value
     * @return float
     */
    public function getCalculatedConsumption()
    {
        return $this->CalculatedConsumption;
    }
    /**
     * Set CalculatedConsumption value
     * @param float $calculatedConsumption
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setCalculatedConsumption($calculatedConsumption = null)
    {
        $this->CalculatedConsumption = $calculatedConsumption;
        return $this;
    }
    /**
     * Get HistoricalConsumption value
     * @return float
     */
    public function getHistoricalConsumption()
    {
        return $this->HistoricalConsumption;
    }
    /**
     * Set HistoricalConsumption value
     * @param float $historicalConsumption
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setHistoricalConsumption($historicalConsumption = null)
    {
        $this->HistoricalConsumption = $historicalConsumption;
        return $this;
    }
    /**
     * Get Difference value
     * @return float
     */
    public function getDifference()
    {
        return $this->Difference;
    }
    /**
     * Set Difference value
     * @param float $difference
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public function setDifference($difference = null)
    {
        $this->Difference = $difference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\HistoricalConsumptionUsageReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
