<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFeesResponse Struct
 * @subpackage Structs
 */
class GetFeesResponse extends ServiceResponseBase
{
    /**
     * The MinPaymentToStartService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinPaymentToStartService;
    /**
     * The GetFeesResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\GetFeesResponse
     */
    public $GetFeesResult;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountFee
     */
    public $Fees;
    /**
     * Constructor method for GetFeesResponse
     * @uses GetFeesResponse::setMinPaymentToStartService()
     * @uses GetFeesResponse::setGetFeesResult()
     * @uses GetFeesResponse::setFees()
     * @param float $minPaymentToStartService
     * @param \SGCIS\Struct\GetFeesResponse $getFeesResult
     * @param \SGCIS\Array\ArrayOfAccountFee $fees
     */
    public function __construct($minPaymentToStartService = null, \SGCIS\Struct\GetFeesResponse $getFeesResult = null, \SGCIS\Array\ArrayOfAccountFee $fees = null)
    {
        $this
            ->setMinPaymentToStartService($minPaymentToStartService)
            ->setGetFeesResult($getFeesResult)
            ->setFees($fees);
    }
    /**
     * Get MinPaymentToStartService value
     * @return float
     */
    public function getMinPaymentToStartService()
    {
        return $this->MinPaymentToStartService;
    }
    /**
     * Set MinPaymentToStartService value
     * @param float $minPaymentToStartService
     * @return \SGCIS\Struct\GetFeesResponse
     */
    public function setMinPaymentToStartService($minPaymentToStartService = null)
    {
        $this->MinPaymentToStartService = $minPaymentToStartService;
        return $this;
    }
    /**
     * Get GetFeesResult value
     * @return \SGCIS\Struct\GetFeesResponse|null
     */
    public function getGetFeesResult()
    {
        return $this->GetFeesResult;
    }
    /**
     * Set GetFeesResult value
     * @param \SGCIS\Struct\GetFeesResponse $getFeesResult
     * @return \SGCIS\Struct\GetFeesResponse
     */
    public function setGetFeesResult(\SGCIS\Struct\GetFeesResponse $getFeesResult = null)
    {
        $this->GetFeesResult = $getFeesResult;
        return $this;
    }
    /**
     * Get Fees value
     * @return \SGCIS\Array\ArrayOfAccountFee|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \SGCIS\Array\ArrayOfAccountFee $fees
     * @return \SGCIS\Struct\GetFeesResponse
     */
    public function setFees(\SGCIS\Array\ArrayOfAccountFee $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\GetFeesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
