<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EDIBill Struct
 * @subpackage Structs
 */
class EDIBill extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The AccountStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusID;
    /**
     * The Usage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Usage;
    /**
     * The BillStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusID;
    /**
     * The InvoiceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceID;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDate;
    /**
     * The PeriodStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The PeriodLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodLength;
    /**
     * The TotalEnergyAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalEnergyAmount;
    /**
     * The TotalTDUBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTDUBase;
    /**
     * The TotalTDUDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTDUDelivery;
    /**
     * The TotalConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalConsumption;
    /**
     * The TotalAmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAmountDue;
    /**
     * The MeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountTypeName;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The MarketTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketTransactionID;
    /**
     * The MasterAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterAccountNumber;
    /**
     * The Purpose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purpose;
    /**
     * The SubPurpose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubPurpose;
    /**
     * The BillStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillStatusName;
    /**
     * The BillingExceptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingExceptions;
    /**
     * The TransactionTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionTypeName;
    /**
     * Constructor method for EDIBill
     * @uses EDIBill::setAccountID()
     * @uses EDIBill::setAccountTypeID()
     * @uses EDIBill::setAccountStatusID()
     * @uses EDIBill::setUsage()
     * @uses EDIBill::setBillStatusID()
     * @uses EDIBill::setInvoiceID()
     * @uses EDIBill::setTransactionDate()
     * @uses EDIBill::setPeriodStartDate()
     * @uses EDIBill::setPeriodEndDate()
     * @uses EDIBill::setPeriodLength()
     * @uses EDIBill::setTotalEnergyAmount()
     * @uses EDIBill::setTotalTDUBase()
     * @uses EDIBill::setTotalTDUDelivery()
     * @uses EDIBill::setTotalConsumption()
     * @uses EDIBill::setTotalAmountDue()
     * @uses EDIBill::setMeterReadID()
     * @uses EDIBill::setAccountNumber()
     * @uses EDIBill::setAccountTypeName()
     * @uses EDIBill::setAccountStatusName()
     * @uses EDIBill::setServiceProviderIdentifier()
     * @uses EDIBill::setMarketTransactionID()
     * @uses EDIBill::setMasterAccountNumber()
     * @uses EDIBill::setPurpose()
     * @uses EDIBill::setSubPurpose()
     * @uses EDIBill::setBillStatusName()
     * @uses EDIBill::setBillingExceptions()
     * @uses EDIBill::setTransactionTypeName()
     * @param int $accountID
     * @param int $accountTypeID
     * @param int $accountStatusID
     * @param float $usage
     * @param int $billStatusID
     * @param int $invoiceID
     * @param string $transactionDate
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param int $periodLength
     * @param float $totalEnergyAmount
     * @param float $totalTDUBase
     * @param float $totalTDUDelivery
     * @param float $totalConsumption
     * @param float $totalAmountDue
     * @param int $meterReadID
     * @param string $accountNumber
     * @param string $accountTypeName
     * @param string $accountStatusName
     * @param string $serviceProviderIdentifier
     * @param string $marketTransactionID
     * @param string $masterAccountNumber
     * @param string $purpose
     * @param string $subPurpose
     * @param string $billStatusName
     * @param string $billingExceptions
     * @param string $transactionTypeName
     */
    public function __construct($accountID = null, $accountTypeID = null, $accountStatusID = null, $usage = null, $billStatusID = null, $invoiceID = null, $transactionDate = null, $periodStartDate = null, $periodEndDate = null, $periodLength = null, $totalEnergyAmount = null, $totalTDUBase = null, $totalTDUDelivery = null, $totalConsumption = null, $totalAmountDue = null, $meterReadID = null, $accountNumber = null, $accountTypeName = null, $accountStatusName = null, $serviceProviderIdentifier = null, $marketTransactionID = null, $masterAccountNumber = null, $purpose = null, $subPurpose = null, $billStatusName = null, $billingExceptions = null, $transactionTypeName = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountTypeID($accountTypeID)
            ->setAccountStatusID($accountStatusID)
            ->setUsage($usage)
            ->setBillStatusID($billStatusID)
            ->setInvoiceID($invoiceID)
            ->setTransactionDate($transactionDate)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setPeriodLength($periodLength)
            ->setTotalEnergyAmount($totalEnergyAmount)
            ->setTotalTDUBase($totalTDUBase)
            ->setTotalTDUDelivery($totalTDUDelivery)
            ->setTotalConsumption($totalConsumption)
            ->setTotalAmountDue($totalAmountDue)
            ->setMeterReadID($meterReadID)
            ->setAccountNumber($accountNumber)
            ->setAccountTypeName($accountTypeName)
            ->setAccountStatusName($accountStatusName)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setMarketTransactionID($marketTransactionID)
            ->setMasterAccountNumber($masterAccountNumber)
            ->setPurpose($purpose)
            ->setSubPurpose($subPurpose)
            ->setBillStatusName($billStatusName)
            ->setBillingExceptions($billingExceptions)
            ->setTransactionTypeName($transactionTypeName);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\EDIBill
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\EDIBill
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get AccountStatusID value
     * @return int
     */
    public function getAccountStatusID()
    {
        return $this->AccountStatusID;
    }
    /**
     * Set AccountStatusID value
     * @param int $accountStatusID
     * @return \SGCIS\Struct\EDIBill
     */
    public function setAccountStatusID($accountStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusID) && !is_numeric($accountStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusID)), __LINE__);
        }
        $this->AccountStatusID = $accountStatusID;
        return $this;
    }
    /**
     * Get Usage value
     * @return float
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * Set Usage value
     * @param float $usage
     * @return \SGCIS\Struct\EDIBill
     */
    public function setUsage($usage = null)
    {
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Get BillStatusID value
     * @return int
     */
    public function getBillStatusID()
    {
        return $this->BillStatusID;
    }
    /**
     * Set BillStatusID value
     * @param int $billStatusID
     * @return \SGCIS\Struct\EDIBill
     */
    public function setBillStatusID($billStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusID) && !is_numeric($billStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusID)), __LINE__);
        }
        $this->BillStatusID = $billStatusID;
        return $this;
    }
    /**
     * Get InvoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param int $invoiceID
     * @return \SGCIS\Struct\EDIBill
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !is_numeric($invoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \SGCIS\Struct\EDIBill
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \SGCIS\Struct\EDIBill
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \SGCIS\Struct\EDIBill
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get PeriodLength value
     * @return int
     */
    public function getPeriodLength()
    {
        return $this->PeriodLength;
    }
    /**
     * Set PeriodLength value
     * @param int $periodLength
     * @return \SGCIS\Struct\EDIBill
     */
    public function setPeriodLength($periodLength = null)
    {
        // validation for constraint: int
        if (!is_null($periodLength) && !is_numeric($periodLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodLength)), __LINE__);
        }
        $this->PeriodLength = $periodLength;
        return $this;
    }
    /**
     * Get TotalEnergyAmount value
     * @return float
     */
    public function getTotalEnergyAmount()
    {
        return $this->TotalEnergyAmount;
    }
    /**
     * Set TotalEnergyAmount value
     * @param float $totalEnergyAmount
     * @return \SGCIS\Struct\EDIBill
     */
    public function setTotalEnergyAmount($totalEnergyAmount = null)
    {
        $this->TotalEnergyAmount = $totalEnergyAmount;
        return $this;
    }
    /**
     * Get TotalTDUBase value
     * @return float
     */
    public function getTotalTDUBase()
    {
        return $this->TotalTDUBase;
    }
    /**
     * Set TotalTDUBase value
     * @param float $totalTDUBase
     * @return \SGCIS\Struct\EDIBill
     */
    public function setTotalTDUBase($totalTDUBase = null)
    {
        $this->TotalTDUBase = $totalTDUBase;
        return $this;
    }
    /**
     * Get TotalTDUDelivery value
     * @return float
     */
    public function getTotalTDUDelivery()
    {
        return $this->TotalTDUDelivery;
    }
    /**
     * Set TotalTDUDelivery value
     * @param float $totalTDUDelivery
     * @return \SGCIS\Struct\EDIBill
     */
    public function setTotalTDUDelivery($totalTDUDelivery = null)
    {
        $this->TotalTDUDelivery = $totalTDUDelivery;
        return $this;
    }
    /**
     * Get TotalConsumption value
     * @return float
     */
    public function getTotalConsumption()
    {
        return $this->TotalConsumption;
    }
    /**
     * Set TotalConsumption value
     * @param float $totalConsumption
     * @return \SGCIS\Struct\EDIBill
     */
    public function setTotalConsumption($totalConsumption = null)
    {
        $this->TotalConsumption = $totalConsumption;
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * @return float
     */
    public function getTotalAmountDue()
    {
        return $this->TotalAmountDue;
    }
    /**
     * Set TotalAmountDue value
     * @param float $totalAmountDue
     * @return \SGCIS\Struct\EDIBill
     */
    public function setTotalAmountDue($totalAmountDue = null)
    {
        $this->TotalAmountDue = $totalAmountDue;
        return $this;
    }
    /**
     * Get MeterReadID value
     * @return int
     */
    public function getMeterReadID()
    {
        return $this->MeterReadID;
    }
    /**
     * Set MeterReadID value
     * @param int $meterReadID
     * @return \SGCIS\Struct\EDIBill
     */
    public function setMeterReadID($meterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadID) && !is_numeric($meterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadID)), __LINE__);
        }
        $this->MeterReadID = $meterReadID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\EDIBill
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountTypeName value
     * @return string|null
     */
    public function getAccountTypeName()
    {
        return $this->AccountTypeName;
    }
    /**
     * Set AccountTypeName value
     * @param string $accountTypeName
     * @return \SGCIS\Struct\EDIBill
     */
    public function setAccountTypeName($accountTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypeName) && !is_string($accountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeName)), __LINE__);
        }
        $this->AccountTypeName = $accountTypeName;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\EDIBill
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\EDIBill
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get MarketTransactionID value
     * @return string|null
     */
    public function getMarketTransactionID()
    {
        return $this->MarketTransactionID;
    }
    /**
     * Set MarketTransactionID value
     * @param string $marketTransactionID
     * @return \SGCIS\Struct\EDIBill
     */
    public function setMarketTransactionID($marketTransactionID = null)
    {
        // validation for constraint: string
        if (!is_null($marketTransactionID) && !is_string($marketTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketTransactionID)), __LINE__);
        }
        $this->MarketTransactionID = $marketTransactionID;
        return $this;
    }
    /**
     * Get MasterAccountNumber value
     * @return string|null
     */
    public function getMasterAccountNumber()
    {
        return $this->MasterAccountNumber;
    }
    /**
     * Set MasterAccountNumber value
     * @param string $masterAccountNumber
     * @return \SGCIS\Struct\EDIBill
     */
    public function setMasterAccountNumber($masterAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($masterAccountNumber) && !is_string($masterAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($masterAccountNumber)), __LINE__);
        }
        $this->MasterAccountNumber = $masterAccountNumber;
        return $this;
    }
    /**
     * Get Purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @param string $purpose
     * @return \SGCIS\Struct\EDIBill
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purpose)), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get SubPurpose value
     * @return string|null
     */
    public function getSubPurpose()
    {
        return $this->SubPurpose;
    }
    /**
     * Set SubPurpose value
     * @param string $subPurpose
     * @return \SGCIS\Struct\EDIBill
     */
    public function setSubPurpose($subPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($subPurpose) && !is_string($subPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subPurpose)), __LINE__);
        }
        $this->SubPurpose = $subPurpose;
        return $this;
    }
    /**
     * Get BillStatusName value
     * @return string|null
     */
    public function getBillStatusName()
    {
        return $this->BillStatusName;
    }
    /**
     * Set BillStatusName value
     * @param string $billStatusName
     * @return \SGCIS\Struct\EDIBill
     */
    public function setBillStatusName($billStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($billStatusName) && !is_string($billStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billStatusName)), __LINE__);
        }
        $this->BillStatusName = $billStatusName;
        return $this;
    }
    /**
     * Get BillingExceptions value
     * @return string|null
     */
    public function getBillingExceptions()
    {
        return $this->BillingExceptions;
    }
    /**
     * Set BillingExceptions value
     * @param string $billingExceptions
     * @return \SGCIS\Struct\EDIBill
     */
    public function setBillingExceptions($billingExceptions = null)
    {
        // validation for constraint: string
        if (!is_null($billingExceptions) && !is_string($billingExceptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingExceptions)), __LINE__);
        }
        $this->BillingExceptions = $billingExceptions;
        return $this;
    }
    /**
     * Get TransactionTypeName value
     * @return string|null
     */
    public function getTransactionTypeName()
    {
        return $this->TransactionTypeName;
    }
    /**
     * Set TransactionTypeName value
     * @param string $transactionTypeName
     * @return \SGCIS\Struct\EDIBill
     */
    public function setTransactionTypeName($transactionTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTypeName) && !is_string($transactionTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionTypeName)), __LINE__);
        }
        $this->TransactionTypeName = $transactionTypeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\EDIBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
