<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataListResponse Struct
 * @subpackage Structs
 */
class DataListResponse extends ServiceResponseBase
{
    /**
     * The ListItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDataListCacheItem
     */
    public $ListItems;
    /**
     * The ListData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfNameValuePair
     */
    public $ListData;
    /**
     * Constructor method for DataListResponse
     * @uses DataListResponse::setListItems()
     * @uses DataListResponse::setListData()
     * @param \SGCIS\Array\ArrayOfDataListCacheItem $listItems
     * @param \SGCIS\Array\ArrayOfNameValuePair $listData
     */
    public function __construct(\SGCIS\Array\ArrayOfDataListCacheItem $listItems = null, \SGCIS\Array\ArrayOfNameValuePair $listData = null)
    {
        $this
            ->setListItems($listItems)
            ->setListData($listData);
    }
    /**
     * Get ListItems value
     * @return \SGCIS\Array\ArrayOfDataListCacheItem|null
     */
    public function getListItems()
    {
        return $this->ListItems;
    }
    /**
     * Set ListItems value
     * @param \SGCIS\Array\ArrayOfDataListCacheItem $listItems
     * @return \SGCIS\Struct\DataListResponse
     */
    public function setListItems(\SGCIS\Array\ArrayOfDataListCacheItem $listItems = null)
    {
        $this->ListItems = $listItems;
        return $this;
    }
    /**
     * Get ListData value
     * @return \SGCIS\Array\ArrayOfNameValuePair|null
     */
    public function getListData()
    {
        return $this->ListData;
    }
    /**
     * Set ListData value
     * @param \SGCIS\Array\ArrayOfNameValuePair $listData
     * @return \SGCIS\Struct\DataListResponse
     */
    public function setListData(\SGCIS\Array\ArrayOfNameValuePair $listData = null)
    {
        $this->ListData = $listData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\DataListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
