<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldRequest Struct
 * @subpackage Structs
 */
class CustomFieldRequest extends ServiceRequestBase
{
    /**
     * The CustomFieldID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomFieldID;
    /**
     * The CustomField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\CustomField
     */
    public $CustomField;
    /**
     * Constructor method for CustomFieldRequest
     * @uses CustomFieldRequest::setCustomFieldID()
     * @uses CustomFieldRequest::setCustomField()
     * @param int $customFieldID
     * @param \SGCIS\Struct\CustomField $customField
     */
    public function __construct($customFieldID = null, \SGCIS\Struct\CustomField $customField = null)
    {
        $this
            ->setCustomFieldID($customFieldID)
            ->setCustomField($customField);
    }
    /**
     * Get CustomFieldID value
     * @return int
     */
    public function getCustomFieldID()
    {
        return $this->CustomFieldID;
    }
    /**
     * Set CustomFieldID value
     * @param int $customFieldID
     * @return \SGCIS\Struct\CustomFieldRequest
     */
    public function setCustomFieldID($customFieldID = null)
    {
        // validation for constraint: int
        if (!is_null($customFieldID) && !is_numeric($customFieldID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customFieldID)), __LINE__);
        }
        $this->CustomFieldID = $customFieldID;
        return $this;
    }
    /**
     * Get CustomField value
     * @return \SGCIS\Struct\CustomField|null
     */
    public function getCustomField()
    {
        return $this->CustomField;
    }
    /**
     * Set CustomField value
     * @param \SGCIS\Struct\CustomField $customField
     * @return \SGCIS\Struct\CustomFieldRequest
     */
    public function setCustomField(\SGCIS\Struct\CustomField $customField = null)
    {
        $this->CustomField = $customField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\CustomFieldRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
