<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrentBill Struct
 * @subpackage Structs
 */
class CurrentBill extends AbstractStructBase
{
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The EnergySinceLastBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EnergySinceLastBill;
    /**
     * The ProjectedEnergyNextBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ProjectedEnergyNextBill;
    /**
     * The ProjectedEnergyMin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ProjectedEnergyMin;
    /**
     * The ProjectedEnergyMax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ProjectedEnergyMax;
    /**
     * The ProjectedEnergyPeriodStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProjectedEnergyPeriodStart;
    /**
     * The ProjectedEnergyPeriodEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProjectedEnergyPeriodEnd;
    /**
     * The ServicePeriodStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServicePeriodStart;
    /**
     * The ServicePeriodEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServicePeriodEnd;
    /**
     * The EnergyCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EnergyCharges;
    /**
     * The EnergyAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EnergyAmount;
    /**
     * The PassThruCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PassThruCharges;
    /**
     * The OtherCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OtherCharges;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tax;
    /**
     * The TotalCurrentCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCurrentCharges;
    /**
     * The BalanceForward
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceForward;
    /**
     * The PaymentsAndAdjustments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentsAndAdjustments;
    /**
     * The TotalAmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAmountDue;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * Constructor method for CurrentBill
     * @uses CurrentBill::setBalance()
     * @uses CurrentBill::setDueDate()
     * @uses CurrentBill::setEnergySinceLastBill()
     * @uses CurrentBill::setProjectedEnergyNextBill()
     * @uses CurrentBill::setProjectedEnergyMin()
     * @uses CurrentBill::setProjectedEnergyMax()
     * @uses CurrentBill::setProjectedEnergyPeriodStart()
     * @uses CurrentBill::setProjectedEnergyPeriodEnd()
     * @uses CurrentBill::setServicePeriodStart()
     * @uses CurrentBill::setServicePeriodEnd()
     * @uses CurrentBill::setEnergyCharges()
     * @uses CurrentBill::setEnergyAmount()
     * @uses CurrentBill::setPassThruCharges()
     * @uses CurrentBill::setOtherCharges()
     * @uses CurrentBill::setTax()
     * @uses CurrentBill::setTotalCurrentCharges()
     * @uses CurrentBill::setBalanceForward()
     * @uses CurrentBill::setPaymentsAndAdjustments()
     * @uses CurrentBill::setTotalAmountDue()
     * @uses CurrentBill::setDate()
     * @param float $balance
     * @param string $dueDate
     * @param float $energySinceLastBill
     * @param float $projectedEnergyNextBill
     * @param float $projectedEnergyMin
     * @param float $projectedEnergyMax
     * @param string $projectedEnergyPeriodStart
     * @param string $projectedEnergyPeriodEnd
     * @param string $servicePeriodStart
     * @param string $servicePeriodEnd
     * @param float $energyCharges
     * @param float $energyAmount
     * @param float $passThruCharges
     * @param float $otherCharges
     * @param float $tax
     * @param float $totalCurrentCharges
     * @param float $balanceForward
     * @param float $paymentsAndAdjustments
     * @param float $totalAmountDue
     * @param string $date
     */
    public function __construct($balance = null, $dueDate = null, $energySinceLastBill = null, $projectedEnergyNextBill = null, $projectedEnergyMin = null, $projectedEnergyMax = null, $projectedEnergyPeriodStart = null, $projectedEnergyPeriodEnd = null, $servicePeriodStart = null, $servicePeriodEnd = null, $energyCharges = null, $energyAmount = null, $passThruCharges = null, $otherCharges = null, $tax = null, $totalCurrentCharges = null, $balanceForward = null, $paymentsAndAdjustments = null, $totalAmountDue = null, $date = null)
    {
        $this
            ->setBalance($balance)
            ->setDueDate($dueDate)
            ->setEnergySinceLastBill($energySinceLastBill)
            ->setProjectedEnergyNextBill($projectedEnergyNextBill)
            ->setProjectedEnergyMin($projectedEnergyMin)
            ->setProjectedEnergyMax($projectedEnergyMax)
            ->setProjectedEnergyPeriodStart($projectedEnergyPeriodStart)
            ->setProjectedEnergyPeriodEnd($projectedEnergyPeriodEnd)
            ->setServicePeriodStart($servicePeriodStart)
            ->setServicePeriodEnd($servicePeriodEnd)
            ->setEnergyCharges($energyCharges)
            ->setEnergyAmount($energyAmount)
            ->setPassThruCharges($passThruCharges)
            ->setOtherCharges($otherCharges)
            ->setTax($tax)
            ->setTotalCurrentCharges($totalCurrentCharges)
            ->setBalanceForward($balanceForward)
            ->setPaymentsAndAdjustments($paymentsAndAdjustments)
            ->setTotalAmountDue($totalAmountDue)
            ->setDate($date);
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get EnergySinceLastBill value
     * @return float
     */
    public function getEnergySinceLastBill()
    {
        return $this->EnergySinceLastBill;
    }
    /**
     * Set EnergySinceLastBill value
     * @param float $energySinceLastBill
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setEnergySinceLastBill($energySinceLastBill = null)
    {
        $this->EnergySinceLastBill = $energySinceLastBill;
        return $this;
    }
    /**
     * Get ProjectedEnergyNextBill value
     * @return float
     */
    public function getProjectedEnergyNextBill()
    {
        return $this->ProjectedEnergyNextBill;
    }
    /**
     * Set ProjectedEnergyNextBill value
     * @param float $projectedEnergyNextBill
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setProjectedEnergyNextBill($projectedEnergyNextBill = null)
    {
        $this->ProjectedEnergyNextBill = $projectedEnergyNextBill;
        return $this;
    }
    /**
     * Get ProjectedEnergyMin value
     * @return float
     */
    public function getProjectedEnergyMin()
    {
        return $this->ProjectedEnergyMin;
    }
    /**
     * Set ProjectedEnergyMin value
     * @param float $projectedEnergyMin
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setProjectedEnergyMin($projectedEnergyMin = null)
    {
        $this->ProjectedEnergyMin = $projectedEnergyMin;
        return $this;
    }
    /**
     * Get ProjectedEnergyMax value
     * @return float
     */
    public function getProjectedEnergyMax()
    {
        return $this->ProjectedEnergyMax;
    }
    /**
     * Set ProjectedEnergyMax value
     * @param float $projectedEnergyMax
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setProjectedEnergyMax($projectedEnergyMax = null)
    {
        $this->ProjectedEnergyMax = $projectedEnergyMax;
        return $this;
    }
    /**
     * Get ProjectedEnergyPeriodStart value
     * @return string
     */
    public function getProjectedEnergyPeriodStart()
    {
        return $this->ProjectedEnergyPeriodStart;
    }
    /**
     * Set ProjectedEnergyPeriodStart value
     * @param string $projectedEnergyPeriodStart
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setProjectedEnergyPeriodStart($projectedEnergyPeriodStart = null)
    {
        // validation for constraint: string
        if (!is_null($projectedEnergyPeriodStart) && !is_string($projectedEnergyPeriodStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectedEnergyPeriodStart)), __LINE__);
        }
        $this->ProjectedEnergyPeriodStart = $projectedEnergyPeriodStart;
        return $this;
    }
    /**
     * Get ProjectedEnergyPeriodEnd value
     * @return string
     */
    public function getProjectedEnergyPeriodEnd()
    {
        return $this->ProjectedEnergyPeriodEnd;
    }
    /**
     * Set ProjectedEnergyPeriodEnd value
     * @param string $projectedEnergyPeriodEnd
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setProjectedEnergyPeriodEnd($projectedEnergyPeriodEnd = null)
    {
        // validation for constraint: string
        if (!is_null($projectedEnergyPeriodEnd) && !is_string($projectedEnergyPeriodEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectedEnergyPeriodEnd)), __LINE__);
        }
        $this->ProjectedEnergyPeriodEnd = $projectedEnergyPeriodEnd;
        return $this;
    }
    /**
     * Get ServicePeriodStart value
     * @return string
     */
    public function getServicePeriodStart()
    {
        return $this->ServicePeriodStart;
    }
    /**
     * Set ServicePeriodStart value
     * @param string $servicePeriodStart
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setServicePeriodStart($servicePeriodStart = null)
    {
        // validation for constraint: string
        if (!is_null($servicePeriodStart) && !is_string($servicePeriodStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePeriodStart)), __LINE__);
        }
        $this->ServicePeriodStart = $servicePeriodStart;
        return $this;
    }
    /**
     * Get ServicePeriodEnd value
     * @return string
     */
    public function getServicePeriodEnd()
    {
        return $this->ServicePeriodEnd;
    }
    /**
     * Set ServicePeriodEnd value
     * @param string $servicePeriodEnd
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setServicePeriodEnd($servicePeriodEnd = null)
    {
        // validation for constraint: string
        if (!is_null($servicePeriodEnd) && !is_string($servicePeriodEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePeriodEnd)), __LINE__);
        }
        $this->ServicePeriodEnd = $servicePeriodEnd;
        return $this;
    }
    /**
     * Get EnergyCharges value
     * @return float
     */
    public function getEnergyCharges()
    {
        return $this->EnergyCharges;
    }
    /**
     * Set EnergyCharges value
     * @param float $energyCharges
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setEnergyCharges($energyCharges = null)
    {
        $this->EnergyCharges = $energyCharges;
        return $this;
    }
    /**
     * Get EnergyAmount value
     * @return float
     */
    public function getEnergyAmount()
    {
        return $this->EnergyAmount;
    }
    /**
     * Set EnergyAmount value
     * @param float $energyAmount
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setEnergyAmount($energyAmount = null)
    {
        $this->EnergyAmount = $energyAmount;
        return $this;
    }
    /**
     * Get PassThruCharges value
     * @return float
     */
    public function getPassThruCharges()
    {
        return $this->PassThruCharges;
    }
    /**
     * Set PassThruCharges value
     * @param float $passThruCharges
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setPassThruCharges($passThruCharges = null)
    {
        $this->PassThruCharges = $passThruCharges;
        return $this;
    }
    /**
     * Get OtherCharges value
     * @return float
     */
    public function getOtherCharges()
    {
        return $this->OtherCharges;
    }
    /**
     * Set OtherCharges value
     * @param float $otherCharges
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setOtherCharges($otherCharges = null)
    {
        $this->OtherCharges = $otherCharges;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TotalCurrentCharges value
     * @return float
     */
    public function getTotalCurrentCharges()
    {
        return $this->TotalCurrentCharges;
    }
    /**
     * Set TotalCurrentCharges value
     * @param float $totalCurrentCharges
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setTotalCurrentCharges($totalCurrentCharges = null)
    {
        $this->TotalCurrentCharges = $totalCurrentCharges;
        return $this;
    }
    /**
     * Get BalanceForward value
     * @return float
     */
    public function getBalanceForward()
    {
        return $this->BalanceForward;
    }
    /**
     * Set BalanceForward value
     * @param float $balanceForward
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setBalanceForward($balanceForward = null)
    {
        $this->BalanceForward = $balanceForward;
        return $this;
    }
    /**
     * Get PaymentsAndAdjustments value
     * @return float
     */
    public function getPaymentsAndAdjustments()
    {
        return $this->PaymentsAndAdjustments;
    }
    /**
     * Set PaymentsAndAdjustments value
     * @param float $paymentsAndAdjustments
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setPaymentsAndAdjustments($paymentsAndAdjustments = null)
    {
        $this->PaymentsAndAdjustments = $paymentsAndAdjustments;
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * @return float
     */
    public function getTotalAmountDue()
    {
        return $this->TotalAmountDue;
    }
    /**
     * Set TotalAmountDue value
     * @param float $totalAmountDue
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setTotalAmountDue($totalAmountDue = null)
    {
        $this->TotalAmountDue = $totalAmountDue;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \SGCIS\Struct\CurrentBill
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\CurrentBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
