<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactType Struct
 * @subpackage Structs
 */
class ContactType extends AbstractStructBase
{
    /**
     * The ContactTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContactTypeID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ContactType
     * @uses ContactType::setContactTypeID()
     * @uses ContactType::setName()
     * @param int $contactTypeID
     * @param string $name
     */
    public function __construct($contactTypeID = null, $name = null)
    {
        $this
            ->setContactTypeID($contactTypeID)
            ->setName($name);
    }
    /**
     * Get ContactTypeID value
     * @return int
     */
    public function getContactTypeID()
    {
        return $this->ContactTypeID;
    }
    /**
     * Set ContactTypeID value
     * @param int $contactTypeID
     * @return \SGCIS\Struct\ContactType
     */
    public function setContactTypeID($contactTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contactTypeID) && !is_numeric($contactTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contactTypeID)), __LINE__);
        }
        $this->ContactTypeID = $contactTypeID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\ContactType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ContactType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
