<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillPaymentAdjustmentDetail Struct
 * @subpackage Structs
 */
class BillPaymentAdjustmentDetail extends AbstractStructBase
{
    /**
     * The BillPaymentAdjustmentDetailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillPaymentAdjustmentDetailID;
    /**
     * The BillPaymentAdjustmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillPaymentAdjustmentID;
    /**
     * The SourceItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceItemID;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TransactionAmount;
    /**
     * The TransactionTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionTypeID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for BillPaymentAdjustmentDetail
     * @uses BillPaymentAdjustmentDetail::setBillPaymentAdjustmentDetailID()
     * @uses BillPaymentAdjustmentDetail::setBillPaymentAdjustmentID()
     * @uses BillPaymentAdjustmentDetail::setSourceItemID()
     * @uses BillPaymentAdjustmentDetail::setTransactionDate()
     * @uses BillPaymentAdjustmentDetail::setTransactionAmount()
     * @uses BillPaymentAdjustmentDetail::setTransactionTypeID()
     * @uses BillPaymentAdjustmentDetail::setCreateDate()
     * @uses BillPaymentAdjustmentDetail::setDescription()
     * @param int $billPaymentAdjustmentDetailID
     * @param int $billPaymentAdjustmentID
     * @param int $sourceItemID
     * @param string $transactionDate
     * @param float $transactionAmount
     * @param int $transactionTypeID
     * @param string $createDate
     * @param string $description
     */
    public function __construct($billPaymentAdjustmentDetailID = null, $billPaymentAdjustmentID = null, $sourceItemID = null, $transactionDate = null, $transactionAmount = null, $transactionTypeID = null, $createDate = null, $description = null)
    {
        $this
            ->setBillPaymentAdjustmentDetailID($billPaymentAdjustmentDetailID)
            ->setBillPaymentAdjustmentID($billPaymentAdjustmentID)
            ->setSourceItemID($sourceItemID)
            ->setTransactionDate($transactionDate)
            ->setTransactionAmount($transactionAmount)
            ->setTransactionTypeID($transactionTypeID)
            ->setCreateDate($createDate)
            ->setDescription($description);
    }
    /**
     * Get BillPaymentAdjustmentDetailID value
     * @return int
     */
    public function getBillPaymentAdjustmentDetailID()
    {
        return $this->BillPaymentAdjustmentDetailID;
    }
    /**
     * Set BillPaymentAdjustmentDetailID value
     * @param int $billPaymentAdjustmentDetailID
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setBillPaymentAdjustmentDetailID($billPaymentAdjustmentDetailID = null)
    {
        // validation for constraint: int
        if (!is_null($billPaymentAdjustmentDetailID) && !is_numeric($billPaymentAdjustmentDetailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billPaymentAdjustmentDetailID)), __LINE__);
        }
        $this->BillPaymentAdjustmentDetailID = $billPaymentAdjustmentDetailID;
        return $this;
    }
    /**
     * Get BillPaymentAdjustmentID value
     * @return int
     */
    public function getBillPaymentAdjustmentID()
    {
        return $this->BillPaymentAdjustmentID;
    }
    /**
     * Set BillPaymentAdjustmentID value
     * @param int $billPaymentAdjustmentID
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setBillPaymentAdjustmentID($billPaymentAdjustmentID = null)
    {
        // validation for constraint: int
        if (!is_null($billPaymentAdjustmentID) && !is_numeric($billPaymentAdjustmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billPaymentAdjustmentID)), __LINE__);
        }
        $this->BillPaymentAdjustmentID = $billPaymentAdjustmentID;
        return $this;
    }
    /**
     * Get SourceItemID value
     * @return int
     */
    public function getSourceItemID()
    {
        return $this->SourceItemID;
    }
    /**
     * Set SourceItemID value
     * @param int $sourceItemID
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setSourceItemID($sourceItemID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceItemID) && !is_numeric($sourceItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceItemID)), __LINE__);
        }
        $this->SourceItemID = $sourceItemID;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get TransactionAmount value
     * @return float
     */
    public function getTransactionAmount()
    {
        return $this->TransactionAmount;
    }
    /**
     * Set TransactionAmount value
     * @param float $transactionAmount
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setTransactionAmount($transactionAmount = null)
    {
        $this->TransactionAmount = $transactionAmount;
        return $this;
    }
    /**
     * Get TransactionTypeID value
     * @return int
     */
    public function getTransactionTypeID()
    {
        return $this->TransactionTypeID;
    }
    /**
     * Set TransactionTypeID value
     * @param int $transactionTypeID
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setTransactionTypeID($transactionTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionTypeID) && !is_numeric($transactionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionTypeID)), __LINE__);
        }
        $this->TransactionTypeID = $transactionTypeID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillPaymentAdjustmentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
