<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillApprovalQueryParameters Struct
 * @subpackage Structs
 */
class BillApprovalQueryParameters extends AbstractStructBase
{
    /**
     * The TransactionDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDateFrom;
    /**
     * The TransactionDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDateTo;
    /**
     * The AccountStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusID;
    /**
     * The MasterAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MasterAccountID;
    /**
     * The AmountDueFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountDueFrom;
    /**
     * The AmountDueTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountDueTo;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The NoBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoBill;
    /**
     * The BillStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusID;
    /**
     * The BillingExceptionCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingExceptionCategoryID;
    /**
     * The BillCalculationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillCalculationMethodID;
    /**
     * The Skip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Skip;
    /**
     * The Take
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Take;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The BillingExceptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $BillingExceptions;
    /**
     * The BillIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $BillIDs;
    /**
     * The BillStatusIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $BillStatusIDs;
    /**
     * The Conditions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Conditions;
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * Constructor method for BillApprovalQueryParameters
     * @uses BillApprovalQueryParameters::setTransactionDateFrom()
     * @uses BillApprovalQueryParameters::setTransactionDateTo()
     * @uses BillApprovalQueryParameters::setAccountStatusID()
     * @uses BillApprovalQueryParameters::setMasterAccountID()
     * @uses BillApprovalQueryParameters::setAmountDueFrom()
     * @uses BillApprovalQueryParameters::setAmountDueTo()
     * @uses BillApprovalQueryParameters::setAccountTypeID()
     * @uses BillApprovalQueryParameters::setNoBill()
     * @uses BillApprovalQueryParameters::setBillStatusID()
     * @uses BillApprovalQueryParameters::setBillingExceptionCategoryID()
     * @uses BillApprovalQueryParameters::setBillCalculationMethodID()
     * @uses BillApprovalQueryParameters::setSkip()
     * @uses BillApprovalQueryParameters::setTake()
     * @uses BillApprovalQueryParameters::setAccountNumber()
     * @uses BillApprovalQueryParameters::setBillingExceptions()
     * @uses BillApprovalQueryParameters::setBillIDs()
     * @uses BillApprovalQueryParameters::setBillStatusIDs()
     * @uses BillApprovalQueryParameters::setConditions()
     * @uses BillApprovalQueryParameters::setOrderBy()
     * @param string $transactionDateFrom
     * @param string $transactionDateTo
     * @param int $accountStatusID
     * @param int $masterAccountID
     * @param float $amountDueFrom
     * @param float $amountDueTo
     * @param int $accountTypeID
     * @param int $noBill
     * @param int $billStatusID
     * @param int $billingExceptionCategoryID
     * @param int $billCalculationMethodID
     * @param int $skip
     * @param int $take
     * @param string $accountNumber
     * @param \SGCIS\Array\ArrayOfInt $billingExceptions
     * @param \SGCIS\Array\ArrayOfInt $billIDs
     * @param \SGCIS\Array\ArrayOfInt $billStatusIDs
     * @param string $conditions
     * @param string $orderBy
     */
    public function __construct($transactionDateFrom = null, $transactionDateTo = null, $accountStatusID = null, $masterAccountID = null, $amountDueFrom = null, $amountDueTo = null, $accountTypeID = null, $noBill = null, $billStatusID = null, $billingExceptionCategoryID = null, $billCalculationMethodID = null, $skip = null, $take = null, $accountNumber = null, \SGCIS\Array\ArrayOfInt $billingExceptions = null, \SGCIS\Array\ArrayOfInt $billIDs = null, \SGCIS\Array\ArrayOfInt $billStatusIDs = null, $conditions = null, $orderBy = null)
    {
        $this
            ->setTransactionDateFrom($transactionDateFrom)
            ->setTransactionDateTo($transactionDateTo)
            ->setAccountStatusID($accountStatusID)
            ->setMasterAccountID($masterAccountID)
            ->setAmountDueFrom($amountDueFrom)
            ->setAmountDueTo($amountDueTo)
            ->setAccountTypeID($accountTypeID)
            ->setNoBill($noBill)
            ->setBillStatusID($billStatusID)
            ->setBillingExceptionCategoryID($billingExceptionCategoryID)
            ->setBillCalculationMethodID($billCalculationMethodID)
            ->setSkip($skip)
            ->setTake($take)
            ->setAccountNumber($accountNumber)
            ->setBillingExceptions($billingExceptions)
            ->setBillIDs($billIDs)
            ->setBillStatusIDs($billStatusIDs)
            ->setConditions($conditions)
            ->setOrderBy($orderBy);
    }
    /**
     * Get TransactionDateFrom value
     * @return string
     */
    public function getTransactionDateFrom()
    {
        return $this->TransactionDateFrom;
    }
    /**
     * Set TransactionDateFrom value
     * @param string $transactionDateFrom
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setTransactionDateFrom($transactionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateFrom) && !is_string($transactionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDateFrom)), __LINE__);
        }
        $this->TransactionDateFrom = $transactionDateFrom;
        return $this;
    }
    /**
     * Get TransactionDateTo value
     * @return string
     */
    public function getTransactionDateTo()
    {
        return $this->TransactionDateTo;
    }
    /**
     * Set TransactionDateTo value
     * @param string $transactionDateTo
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setTransactionDateTo($transactionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTo) && !is_string($transactionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDateTo)), __LINE__);
        }
        $this->TransactionDateTo = $transactionDateTo;
        return $this;
    }
    /**
     * Get AccountStatusID value
     * @return int
     */
    public function getAccountStatusID()
    {
        return $this->AccountStatusID;
    }
    /**
     * Set AccountStatusID value
     * @param int $accountStatusID
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setAccountStatusID($accountStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusID) && !is_numeric($accountStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusID)), __LINE__);
        }
        $this->AccountStatusID = $accountStatusID;
        return $this;
    }
    /**
     * Get MasterAccountID value
     * @return int
     */
    public function getMasterAccountID()
    {
        return $this->MasterAccountID;
    }
    /**
     * Set MasterAccountID value
     * @param int $masterAccountID
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setMasterAccountID($masterAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($masterAccountID) && !is_numeric($masterAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($masterAccountID)), __LINE__);
        }
        $this->MasterAccountID = $masterAccountID;
        return $this;
    }
    /**
     * Get AmountDueFrom value
     * @return float
     */
    public function getAmountDueFrom()
    {
        return $this->AmountDueFrom;
    }
    /**
     * Set AmountDueFrom value
     * @param float $amountDueFrom
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setAmountDueFrom($amountDueFrom = null)
    {
        $this->AmountDueFrom = $amountDueFrom;
        return $this;
    }
    /**
     * Get AmountDueTo value
     * @return float
     */
    public function getAmountDueTo()
    {
        return $this->AmountDueTo;
    }
    /**
     * Set AmountDueTo value
     * @param float $amountDueTo
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setAmountDueTo($amountDueTo = null)
    {
        $this->AmountDueTo = $amountDueTo;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get NoBill value
     * @return int
     */
    public function getNoBill()
    {
        return $this->NoBill;
    }
    /**
     * Set NoBill value
     * @param int $noBill
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setNoBill($noBill = null)
    {
        // validation for constraint: int
        if (!is_null($noBill) && !is_numeric($noBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noBill)), __LINE__);
        }
        $this->NoBill = $noBill;
        return $this;
    }
    /**
     * Get BillStatusID value
     * @return int
     */
    public function getBillStatusID()
    {
        return $this->BillStatusID;
    }
    /**
     * Set BillStatusID value
     * @param int $billStatusID
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setBillStatusID($billStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusID) && !is_numeric($billStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusID)), __LINE__);
        }
        $this->BillStatusID = $billStatusID;
        return $this;
    }
    /**
     * Get BillingExceptionCategoryID value
     * @return int
     */
    public function getBillingExceptionCategoryID()
    {
        return $this->BillingExceptionCategoryID;
    }
    /**
     * Set BillingExceptionCategoryID value
     * @param int $billingExceptionCategoryID
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setBillingExceptionCategoryID($billingExceptionCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($billingExceptionCategoryID) && !is_numeric($billingExceptionCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingExceptionCategoryID)), __LINE__);
        }
        $this->BillingExceptionCategoryID = $billingExceptionCategoryID;
        return $this;
    }
    /**
     * Get BillCalculationMethodID value
     * @return int
     */
    public function getBillCalculationMethodID()
    {
        return $this->BillCalculationMethodID;
    }
    /**
     * Set BillCalculationMethodID value
     * @param int $billCalculationMethodID
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setBillCalculationMethodID($billCalculationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($billCalculationMethodID) && !is_numeric($billCalculationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billCalculationMethodID)), __LINE__);
        }
        $this->BillCalculationMethodID = $billCalculationMethodID;
        return $this;
    }
    /**
     * Get Skip value
     * @return int
     */
    public function getSkip()
    {
        return $this->Skip;
    }
    /**
     * Set Skip value
     * @param int $skip
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setSkip($skip = null)
    {
        // validation for constraint: int
        if (!is_null($skip) && !is_numeric($skip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($skip)), __LINE__);
        }
        $this->Skip = $skip;
        return $this;
    }
    /**
     * Get Take value
     * @return int
     */
    public function getTake()
    {
        return $this->Take;
    }
    /**
     * Set Take value
     * @param int $take
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setTake($take = null)
    {
        // validation for constraint: int
        if (!is_null($take) && !is_numeric($take)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($take)), __LINE__);
        }
        $this->Take = $take;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get BillingExceptions value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getBillingExceptions()
    {
        return $this->BillingExceptions;
    }
    /**
     * Set BillingExceptions value
     * @param \SGCIS\Array\ArrayOfInt $billingExceptions
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setBillingExceptions(\SGCIS\Array\ArrayOfInt $billingExceptions = null)
    {
        $this->BillingExceptions = $billingExceptions;
        return $this;
    }
    /**
     * Get BillIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getBillIDs()
    {
        return $this->BillIDs;
    }
    /**
     * Set BillIDs value
     * @param \SGCIS\Array\ArrayOfInt $billIDs
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setBillIDs(\SGCIS\Array\ArrayOfInt $billIDs = null)
    {
        $this->BillIDs = $billIDs;
        return $this;
    }
    /**
     * Get BillStatusIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getBillStatusIDs()
    {
        return $this->BillStatusIDs;
    }
    /**
     * Set BillStatusIDs value
     * @param \SGCIS\Array\ArrayOfInt $billStatusIDs
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setBillStatusIDs(\SGCIS\Array\ArrayOfInt $billStatusIDs = null)
    {
        $this->BillStatusIDs = $billStatusIDs;
        return $this;
    }
    /**
     * Get Conditions value
     * @return string|null
     */
    public function getConditions()
    {
        return $this->Conditions;
    }
    /**
     * Set Conditions value
     * @param string $conditions
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setConditions($conditions = null)
    {
        // validation for constraint: string
        if (!is_null($conditions) && !is_string($conditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conditions)), __LINE__);
        }
        $this->Conditions = $conditions;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillApprovalQueryParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
