<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuditLog Struct
 * @subpackage Structs
 */
class AuditLog extends AbstractStructBase
{
    /**
     * The AuditLogID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AuditLogID;
    /**
     * The AuditDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuditDate;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EntityID;
    /**
     * The AuditChangeTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AuditChangeTypeID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AuditUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuditUserName;
    /**
     * The EntityChanged
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityChanged;
    /**
     * The AuditChangeTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuditChangeTypeName;
    /**
     * The ItemChanged
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemChanged;
    /**
     * The BeforeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BeforeValue;
    /**
     * The AfterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AfterValue;
    /**
     * Constructor method for AuditLog
     * @uses AuditLog::setAuditLogID()
     * @uses AuditLog::setAuditDate()
     * @uses AuditLog::setAccountID()
     * @uses AuditLog::setEntityID()
     * @uses AuditLog::setAuditChangeTypeID()
     * @uses AuditLog::setAccountNumber()
     * @uses AuditLog::setAuditUserName()
     * @uses AuditLog::setEntityChanged()
     * @uses AuditLog::setAuditChangeTypeName()
     * @uses AuditLog::setItemChanged()
     * @uses AuditLog::setBeforeValue()
     * @uses AuditLog::setAfterValue()
     * @param int $auditLogID
     * @param string $auditDate
     * @param int $accountID
     * @param int $entityID
     * @param int $auditChangeTypeID
     * @param string $accountNumber
     * @param string $auditUserName
     * @param string $entityChanged
     * @param string $auditChangeTypeName
     * @param string $itemChanged
     * @param string $beforeValue
     * @param string $afterValue
     */
    public function __construct($auditLogID = null, $auditDate = null, $accountID = null, $entityID = null, $auditChangeTypeID = null, $accountNumber = null, $auditUserName = null, $entityChanged = null, $auditChangeTypeName = null, $itemChanged = null, $beforeValue = null, $afterValue = null)
    {
        $this
            ->setAuditLogID($auditLogID)
            ->setAuditDate($auditDate)
            ->setAccountID($accountID)
            ->setEntityID($entityID)
            ->setAuditChangeTypeID($auditChangeTypeID)
            ->setAccountNumber($accountNumber)
            ->setAuditUserName($auditUserName)
            ->setEntityChanged($entityChanged)
            ->setAuditChangeTypeName($auditChangeTypeName)
            ->setItemChanged($itemChanged)
            ->setBeforeValue($beforeValue)
            ->setAfterValue($afterValue);
    }
    /**
     * Get AuditLogID value
     * @return int
     */
    public function getAuditLogID()
    {
        return $this->AuditLogID;
    }
    /**
     * Set AuditLogID value
     * @param int $auditLogID
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAuditLogID($auditLogID = null)
    {
        // validation for constraint: int
        if (!is_null($auditLogID) && !is_numeric($auditLogID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($auditLogID)), __LINE__);
        }
        $this->AuditLogID = $auditLogID;
        return $this;
    }
    /**
     * Get AuditDate value
     * @return string
     */
    public function getAuditDate()
    {
        return $this->AuditDate;
    }
    /**
     * Set AuditDate value
     * @param string $auditDate
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAuditDate($auditDate = null)
    {
        // validation for constraint: string
        if (!is_null($auditDate) && !is_string($auditDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($auditDate)), __LINE__);
        }
        $this->AuditDate = $auditDate;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get EntityID value
     * @return int
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param int $entityID
     * @return \SGCIS\Struct\AuditLog
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: int
        if (!is_null($entityID) && !is_numeric($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get AuditChangeTypeID value
     * @return int
     */
    public function getAuditChangeTypeID()
    {
        return $this->AuditChangeTypeID;
    }
    /**
     * Set AuditChangeTypeID value
     * @param int $auditChangeTypeID
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAuditChangeTypeID($auditChangeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($auditChangeTypeID) && !is_numeric($auditChangeTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($auditChangeTypeID)), __LINE__);
        }
        $this->AuditChangeTypeID = $auditChangeTypeID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AuditUserName value
     * @return string|null
     */
    public function getAuditUserName()
    {
        return $this->AuditUserName;
    }
    /**
     * Set AuditUserName value
     * @param string $auditUserName
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAuditUserName($auditUserName = null)
    {
        // validation for constraint: string
        if (!is_null($auditUserName) && !is_string($auditUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($auditUserName)), __LINE__);
        }
        $this->AuditUserName = $auditUserName;
        return $this;
    }
    /**
     * Get EntityChanged value
     * @return string|null
     */
    public function getEntityChanged()
    {
        return $this->EntityChanged;
    }
    /**
     * Set EntityChanged value
     * @param string $entityChanged
     * @return \SGCIS\Struct\AuditLog
     */
    public function setEntityChanged($entityChanged = null)
    {
        // validation for constraint: string
        if (!is_null($entityChanged) && !is_string($entityChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityChanged)), __LINE__);
        }
        $this->EntityChanged = $entityChanged;
        return $this;
    }
    /**
     * Get AuditChangeTypeName value
     * @return string|null
     */
    public function getAuditChangeTypeName()
    {
        return $this->AuditChangeTypeName;
    }
    /**
     * Set AuditChangeTypeName value
     * @param string $auditChangeTypeName
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAuditChangeTypeName($auditChangeTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($auditChangeTypeName) && !is_string($auditChangeTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($auditChangeTypeName)), __LINE__);
        }
        $this->AuditChangeTypeName = $auditChangeTypeName;
        return $this;
    }
    /**
     * Get ItemChanged value
     * @return string|null
     */
    public function getItemChanged()
    {
        return $this->ItemChanged;
    }
    /**
     * Set ItemChanged value
     * @param string $itemChanged
     * @return \SGCIS\Struct\AuditLog
     */
    public function setItemChanged($itemChanged = null)
    {
        // validation for constraint: string
        if (!is_null($itemChanged) && !is_string($itemChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemChanged)), __LINE__);
        }
        $this->ItemChanged = $itemChanged;
        return $this;
    }
    /**
     * Get BeforeValue value
     * @return string|null
     */
    public function getBeforeValue()
    {
        return $this->BeforeValue;
    }
    /**
     * Set BeforeValue value
     * @param string $beforeValue
     * @return \SGCIS\Struct\AuditLog
     */
    public function setBeforeValue($beforeValue = null)
    {
        // validation for constraint: string
        if (!is_null($beforeValue) && !is_string($beforeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beforeValue)), __LINE__);
        }
        $this->BeforeValue = $beforeValue;
        return $this;
    }
    /**
     * Get AfterValue value
     * @return string|null
     */
    public function getAfterValue()
    {
        return $this->AfterValue;
    }
    /**
     * Set AfterValue value
     * @param string $afterValue
     * @return \SGCIS\Struct\AuditLog
     */
    public function setAfterValue($afterValue = null)
    {
        // validation for constraint: string
        if (!is_null($afterValue) && !is_string($afterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($afterValue)), __LINE__);
        }
        $this->AfterValue = $afterValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AuditLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
