<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountTransaction Struct
 * @subpackage Structs
 */
class AccountTransaction extends AbstractStructBase
{
    /**
     * The ConsolidatedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsolidatedAmount;
    /**
     * The Day
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Day;
    /**
     * The AccountTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTransactionID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The IsDebit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDebit;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDate;
    /**
     * The EnergyFlowDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EnergyFlowDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The PaymentEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentEventID;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The TransactionTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionTypeID;
    /**
     * The FeeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeeID;
    /**
     * The LinkedTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LinkedTransactionID;
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountPaid;
    /**
     * The AmountOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountOwed;
    /**
     * The AmountWrittenOff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountWrittenOff;
    /**
     * The IsPaymentDistributed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPaymentDistributed;
    /**
     * The ServiceAgreementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The BillServicePointChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointChargeID;
    /**
     * The TenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TenderTypeID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The IsPostedToGL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPostedToGL;
    /**
     * The PaymentTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTransactionID;
    /**
     * The DistributionAmountApplied
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DistributionAmountApplied;
    /**
     * The PaymentEventReversalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentEventReversalID;
    /**
     * The IsReversal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReversal;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The IsReversalEligible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReversalEligible;
    /**
     * The IsTaxed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTaxed;
    /**
     * The IsBaseCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBaseCharge;
    /**
     * The ConsolidateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsolidateDate;
    /**
     * The MonthAndDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthAndDay;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The TransactionTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionTypeName;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ChargeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The TenderTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TenderTypeName;
    /**
     * The AuthorizationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationNumber;
    /**
     * The IpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpAddress;
    /**
     * Constructor method for AccountTransaction
     * @uses AccountTransaction::setConsolidatedAmount()
     * @uses AccountTransaction::setDay()
     * @uses AccountTransaction::setAccountTransactionID()
     * @uses AccountTransaction::setAccountID()
     * @uses AccountTransaction::setAccountServicePointID()
     * @uses AccountTransaction::setIsDebit()
     * @uses AccountTransaction::setTransactionDate()
     * @uses AccountTransaction::setEnergyFlowDate()
     * @uses AccountTransaction::setAmount()
     * @uses AccountTransaction::setPaymentEventID()
     * @uses AccountTransaction::setBalance()
     * @uses AccountTransaction::setTransactionTypeID()
     * @uses AccountTransaction::setFeeID()
     * @uses AccountTransaction::setLinkedTransactionID()
     * @uses AccountTransaction::setAmountPaid()
     * @uses AccountTransaction::setAmountOwed()
     * @uses AccountTransaction::setAmountWrittenOff()
     * @uses AccountTransaction::setIsPaymentDistributed()
     * @uses AccountTransaction::setServiceAgreementID()
     * @uses AccountTransaction::setBillID()
     * @uses AccountTransaction::setBillServicePointChargeID()
     * @uses AccountTransaction::setTenderTypeID()
     * @uses AccountTransaction::setAccountTypeID()
     * @uses AccountTransaction::setIsPostedToGL()
     * @uses AccountTransaction::setPaymentTransactionID()
     * @uses AccountTransaction::setDistributionAmountApplied()
     * @uses AccountTransaction::setPaymentEventReversalID()
     * @uses AccountTransaction::setIsReversal()
     * @uses AccountTransaction::setConsumption()
     * @uses AccountTransaction::setIsReversalEligible()
     * @uses AccountTransaction::setIsTaxed()
     * @uses AccountTransaction::setIsBaseCharge()
     * @uses AccountTransaction::setConsolidateDate()
     * @uses AccountTransaction::setMonthAndDay()
     * @uses AccountTransaction::setDescription()
     * @uses AccountTransaction::setTransactionTypeName()
     * @uses AccountTransaction::setCreatedByUserName()
     * @uses AccountTransaction::setAccountNumber()
     * @uses AccountTransaction::setChargeCode()
     * @uses AccountTransaction::setTenderTypeName()
     * @uses AccountTransaction::setAuthorizationNumber()
     * @uses AccountTransaction::setIpAddress()
     * @param float $consolidatedAmount
     * @param int $day
     * @param int $accountTransactionID
     * @param int $accountID
     * @param int $accountServicePointID
     * @param bool $isDebit
     * @param string $transactionDate
     * @param string $energyFlowDate
     * @param float $amount
     * @param int $paymentEventID
     * @param float $balance
     * @param int $transactionTypeID
     * @param int $feeID
     * @param int $linkedTransactionID
     * @param float $amountPaid
     * @param float $amountOwed
     * @param float $amountWrittenOff
     * @param bool $isPaymentDistributed
     * @param int $serviceAgreementID
     * @param int $billID
     * @param int $billServicePointChargeID
     * @param int $tenderTypeID
     * @param int $accountTypeID
     * @param bool $isPostedToGL
     * @param int $paymentTransactionID
     * @param float $distributionAmountApplied
     * @param int $paymentEventReversalID
     * @param bool $isReversal
     * @param float $consumption
     * @param bool $isReversalEligible
     * @param bool $isTaxed
     * @param bool $isBaseCharge
     * @param string $consolidateDate
     * @param string $monthAndDay
     * @param string $description
     * @param string $transactionTypeName
     * @param string $createdByUserName
     * @param string $accountNumber
     * @param string $chargeCode
     * @param string $tenderTypeName
     * @param string $authorizationNumber
     * @param string $ipAddress
     */
    public function __construct($consolidatedAmount = null, $day = null, $accountTransactionID = null, $accountID = null, $accountServicePointID = null, $isDebit = null, $transactionDate = null, $energyFlowDate = null, $amount = null, $paymentEventID = null, $balance = null, $transactionTypeID = null, $feeID = null, $linkedTransactionID = null, $amountPaid = null, $amountOwed = null, $amountWrittenOff = null, $isPaymentDistributed = null, $serviceAgreementID = null, $billID = null, $billServicePointChargeID = null, $tenderTypeID = null, $accountTypeID = null, $isPostedToGL = null, $paymentTransactionID = null, $distributionAmountApplied = null, $paymentEventReversalID = null, $isReversal = null, $consumption = null, $isReversalEligible = null, $isTaxed = null, $isBaseCharge = null, $consolidateDate = null, $monthAndDay = null, $description = null, $transactionTypeName = null, $createdByUserName = null, $accountNumber = null, $chargeCode = null, $tenderTypeName = null, $authorizationNumber = null, $ipAddress = null)
    {
        $this
            ->setConsolidatedAmount($consolidatedAmount)
            ->setDay($day)
            ->setAccountTransactionID($accountTransactionID)
            ->setAccountID($accountID)
            ->setAccountServicePointID($accountServicePointID)
            ->setIsDebit($isDebit)
            ->setTransactionDate($transactionDate)
            ->setEnergyFlowDate($energyFlowDate)
            ->setAmount($amount)
            ->setPaymentEventID($paymentEventID)
            ->setBalance($balance)
            ->setTransactionTypeID($transactionTypeID)
            ->setFeeID($feeID)
            ->setLinkedTransactionID($linkedTransactionID)
            ->setAmountPaid($amountPaid)
            ->setAmountOwed($amountOwed)
            ->setAmountWrittenOff($amountWrittenOff)
            ->setIsPaymentDistributed($isPaymentDistributed)
            ->setServiceAgreementID($serviceAgreementID)
            ->setBillID($billID)
            ->setBillServicePointChargeID($billServicePointChargeID)
            ->setTenderTypeID($tenderTypeID)
            ->setAccountTypeID($accountTypeID)
            ->setIsPostedToGL($isPostedToGL)
            ->setPaymentTransactionID($paymentTransactionID)
            ->setDistributionAmountApplied($distributionAmountApplied)
            ->setPaymentEventReversalID($paymentEventReversalID)
            ->setIsReversal($isReversal)
            ->setConsumption($consumption)
            ->setIsReversalEligible($isReversalEligible)
            ->setIsTaxed($isTaxed)
            ->setIsBaseCharge($isBaseCharge)
            ->setConsolidateDate($consolidateDate)
            ->setMonthAndDay($monthAndDay)
            ->setDescription($description)
            ->setTransactionTypeName($transactionTypeName)
            ->setCreatedByUserName($createdByUserName)
            ->setAccountNumber($accountNumber)
            ->setChargeCode($chargeCode)
            ->setTenderTypeName($tenderTypeName)
            ->setAuthorizationNumber($authorizationNumber)
            ->setIpAddress($ipAddress);
    }
    /**
     * Get ConsolidatedAmount value
     * @return float
     */
    public function getConsolidatedAmount()
    {
        return $this->ConsolidatedAmount;
    }
    /**
     * Set ConsolidatedAmount value
     * @param float $consolidatedAmount
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setConsolidatedAmount($consolidatedAmount = null)
    {
        $this->ConsolidatedAmount = $consolidatedAmount;
        return $this;
    }
    /**
     * Get Day value
     * @return int
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param int $day
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !is_numeric($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get AccountTransactionID value
     * @return int
     */
    public function getAccountTransactionID()
    {
        return $this->AccountTransactionID;
    }
    /**
     * Set AccountTransactionID value
     * @param int $accountTransactionID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAccountTransactionID($accountTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTransactionID) && !is_numeric($accountTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTransactionID)), __LINE__);
        }
        $this->AccountTransactionID = $accountTransactionID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get IsDebit value
     * @return bool
     */
    public function getIsDebit()
    {
        return $this->IsDebit;
    }
    /**
     * Set IsDebit value
     * @param bool $isDebit
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIsDebit($isDebit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDebit) && !is_bool($isDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDebit)), __LINE__);
        }
        $this->IsDebit = $isDebit;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get EnergyFlowDate value
     * @return string
     */
    public function getEnergyFlowDate()
    {
        return $this->EnergyFlowDate;
    }
    /**
     * Set EnergyFlowDate value
     * @param string $energyFlowDate
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setEnergyFlowDate($energyFlowDate = null)
    {
        // validation for constraint: string
        if (!is_null($energyFlowDate) && !is_string($energyFlowDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($energyFlowDate)), __LINE__);
        }
        $this->EnergyFlowDate = $energyFlowDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PaymentEventID value
     * @return int
     */
    public function getPaymentEventID()
    {
        return $this->PaymentEventID;
    }
    /**
     * Set PaymentEventID value
     * @param int $paymentEventID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setPaymentEventID($paymentEventID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentEventID) && !is_numeric($paymentEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentEventID)), __LINE__);
        }
        $this->PaymentEventID = $paymentEventID;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get TransactionTypeID value
     * @return int
     */
    public function getTransactionTypeID()
    {
        return $this->TransactionTypeID;
    }
    /**
     * Set TransactionTypeID value
     * @param int $transactionTypeID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setTransactionTypeID($transactionTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionTypeID) && !is_numeric($transactionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionTypeID)), __LINE__);
        }
        $this->TransactionTypeID = $transactionTypeID;
        return $this;
    }
    /**
     * Get FeeID value
     * @return int
     */
    public function getFeeID()
    {
        return $this->FeeID;
    }
    /**
     * Set FeeID value
     * @param int $feeID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setFeeID($feeID = null)
    {
        // validation for constraint: int
        if (!is_null($feeID) && !is_numeric($feeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($feeID)), __LINE__);
        }
        $this->FeeID = $feeID;
        return $this;
    }
    /**
     * Get LinkedTransactionID value
     * @return int
     */
    public function getLinkedTransactionID()
    {
        return $this->LinkedTransactionID;
    }
    /**
     * Set LinkedTransactionID value
     * @param int $linkedTransactionID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setLinkedTransactionID($linkedTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($linkedTransactionID) && !is_numeric($linkedTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($linkedTransactionID)), __LINE__);
        }
        $this->LinkedTransactionID = $linkedTransactionID;
        return $this;
    }
    /**
     * Get AmountPaid value
     * @return float
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param float $amountPaid
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAmountPaid($amountPaid = null)
    {
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get AmountOwed value
     * @return float
     */
    public function getAmountOwed()
    {
        return $this->AmountOwed;
    }
    /**
     * Set AmountOwed value
     * @param float $amountOwed
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAmountOwed($amountOwed = null)
    {
        $this->AmountOwed = $amountOwed;
        return $this;
    }
    /**
     * Get AmountWrittenOff value
     * @return float
     */
    public function getAmountWrittenOff()
    {
        return $this->AmountWrittenOff;
    }
    /**
     * Set AmountWrittenOff value
     * @param float $amountWrittenOff
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAmountWrittenOff($amountWrittenOff = null)
    {
        $this->AmountWrittenOff = $amountWrittenOff;
        return $this;
    }
    /**
     * Get IsPaymentDistributed value
     * @return bool
     */
    public function getIsPaymentDistributed()
    {
        return $this->IsPaymentDistributed;
    }
    /**
     * Set IsPaymentDistributed value
     * @param bool $isPaymentDistributed
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIsPaymentDistributed($isPaymentDistributed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaymentDistributed) && !is_bool($isPaymentDistributed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPaymentDistributed)), __LINE__);
        }
        $this->IsPaymentDistributed = $isPaymentDistributed;
        return $this;
    }
    /**
     * Get ServiceAgreementID value
     * @return int
     */
    public function getServiceAgreementID()
    {
        return $this->ServiceAgreementID;
    }
    /**
     * Set ServiceAgreementID value
     * @param int $serviceAgreementID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setServiceAgreementID($serviceAgreementID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementID) && !is_numeric($serviceAgreementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementID)), __LINE__);
        }
        $this->ServiceAgreementID = $serviceAgreementID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get BillServicePointChargeID value
     * @return int
     */
    public function getBillServicePointChargeID()
    {
        return $this->BillServicePointChargeID;
    }
    /**
     * Set BillServicePointChargeID value
     * @param int $billServicePointChargeID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setBillServicePointChargeID($billServicePointChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointChargeID) && !is_numeric($billServicePointChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointChargeID)), __LINE__);
        }
        $this->BillServicePointChargeID = $billServicePointChargeID;
        return $this;
    }
    /**
     * Get TenderTypeID value
     * @return int
     */
    public function getTenderTypeID()
    {
        return $this->TenderTypeID;
    }
    /**
     * Set TenderTypeID value
     * @param int $tenderTypeID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setTenderTypeID($tenderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($tenderTypeID) && !is_numeric($tenderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tenderTypeID)), __LINE__);
        }
        $this->TenderTypeID = $tenderTypeID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get IsPostedToGL value
     * @return bool
     */
    public function getIsPostedToGL()
    {
        return $this->IsPostedToGL;
    }
    /**
     * Set IsPostedToGL value
     * @param bool $isPostedToGL
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIsPostedToGL($isPostedToGL = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPostedToGL) && !is_bool($isPostedToGL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPostedToGL)), __LINE__);
        }
        $this->IsPostedToGL = $isPostedToGL;
        return $this;
    }
    /**
     * Get PaymentTransactionID value
     * @return int
     */
    public function getPaymentTransactionID()
    {
        return $this->PaymentTransactionID;
    }
    /**
     * Set PaymentTransactionID value
     * @param int $paymentTransactionID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setPaymentTransactionID($paymentTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTransactionID) && !is_numeric($paymentTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTransactionID)), __LINE__);
        }
        $this->PaymentTransactionID = $paymentTransactionID;
        return $this;
    }
    /**
     * Get DistributionAmountApplied value
     * @return float
     */
    public function getDistributionAmountApplied()
    {
        return $this->DistributionAmountApplied;
    }
    /**
     * Set DistributionAmountApplied value
     * @param float $distributionAmountApplied
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setDistributionAmountApplied($distributionAmountApplied = null)
    {
        $this->DistributionAmountApplied = $distributionAmountApplied;
        return $this;
    }
    /**
     * Get PaymentEventReversalID value
     * @return int
     */
    public function getPaymentEventReversalID()
    {
        return $this->PaymentEventReversalID;
    }
    /**
     * Set PaymentEventReversalID value
     * @param int $paymentEventReversalID
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setPaymentEventReversalID($paymentEventReversalID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentEventReversalID) && !is_numeric($paymentEventReversalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentEventReversalID)), __LINE__);
        }
        $this->PaymentEventReversalID = $paymentEventReversalID;
        return $this;
    }
    /**
     * Get IsReversal value
     * @return bool
     */
    public function getIsReversal()
    {
        return $this->IsReversal;
    }
    /**
     * Set IsReversal value
     * @param bool $isReversal
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIsReversal($isReversal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReversal) && !is_bool($isReversal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isReversal)), __LINE__);
        }
        $this->IsReversal = $isReversal;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get IsReversalEligible value
     * @return bool
     */
    public function getIsReversalEligible()
    {
        return $this->IsReversalEligible;
    }
    /**
     * Set IsReversalEligible value
     * @param bool $isReversalEligible
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIsReversalEligible($isReversalEligible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReversalEligible) && !is_bool($isReversalEligible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isReversalEligible)), __LINE__);
        }
        $this->IsReversalEligible = $isReversalEligible;
        return $this;
    }
    /**
     * Get IsTaxed value
     * @return bool
     */
    public function getIsTaxed()
    {
        return $this->IsTaxed;
    }
    /**
     * Set IsTaxed value
     * @param bool $isTaxed
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIsTaxed($isTaxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxed) && !is_bool($isTaxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxed)), __LINE__);
        }
        $this->IsTaxed = $isTaxed;
        return $this;
    }
    /**
     * Get IsBaseCharge value
     * @return bool
     */
    public function getIsBaseCharge()
    {
        return $this->IsBaseCharge;
    }
    /**
     * Set IsBaseCharge value
     * @param bool $isBaseCharge
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIsBaseCharge($isBaseCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBaseCharge) && !is_bool($isBaseCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBaseCharge)), __LINE__);
        }
        $this->IsBaseCharge = $isBaseCharge;
        return $this;
    }
    /**
     * Get ConsolidateDate value
     * @return string|null
     */
    public function getConsolidateDate()
    {
        return $this->ConsolidateDate;
    }
    /**
     * Set ConsolidateDate value
     * @param string $consolidateDate
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setConsolidateDate($consolidateDate = null)
    {
        // validation for constraint: string
        if (!is_null($consolidateDate) && !is_string($consolidateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consolidateDate)), __LINE__);
        }
        $this->ConsolidateDate = $consolidateDate;
        return $this;
    }
    /**
     * Get MonthAndDay value
     * @return string|null
     */
    public function getMonthAndDay()
    {
        return $this->MonthAndDay;
    }
    /**
     * Set MonthAndDay value
     * @param string $monthAndDay
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setMonthAndDay($monthAndDay = null)
    {
        // validation for constraint: string
        if (!is_null($monthAndDay) && !is_string($monthAndDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monthAndDay)), __LINE__);
        }
        $this->MonthAndDay = $monthAndDay;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TransactionTypeName value
     * @return string|null
     */
    public function getTransactionTypeName()
    {
        return $this->TransactionTypeName;
    }
    /**
     * Set TransactionTypeName value
     * @param string $transactionTypeName
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setTransactionTypeName($transactionTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTypeName) && !is_string($transactionTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionTypeName)), __LINE__);
        }
        $this->TransactionTypeName = $transactionTypeName;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get TenderTypeName value
     * @return string|null
     */
    public function getTenderTypeName()
    {
        return $this->TenderTypeName;
    }
    /**
     * Set TenderTypeName value
     * @param string $tenderTypeName
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setTenderTypeName($tenderTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($tenderTypeName) && !is_string($tenderTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenderTypeName)), __LINE__);
        }
        $this->TenderTypeName = $tenderTypeName;
        return $this;
    }
    /**
     * Get AuthorizationNumber value
     * @return string|null
     */
    public function getAuthorizationNumber()
    {
        return $this->AuthorizationNumber;
    }
    /**
     * Set AuthorizationNumber value
     * @param string $authorizationNumber
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setAuthorizationNumber($authorizationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationNumber) && !is_string($authorizationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationNumber)), __LINE__);
        }
        $this->AuthorizationNumber = $authorizationNumber;
        return $this;
    }
    /**
     * Get IpAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->IpAddress;
    }
    /**
     * Set IpAddress value
     * @param string $ipAddress
     * @return \SGCIS\Struct\AccountTransaction
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->IpAddress = $ipAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
