<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountStatusHistory Struct
 * @subpackage Structs
 */
class AccountStatusHistory extends AbstractStructBase
{
    /**
     * The AccountStatusHistoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusHistoryID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The ToStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToStatusID;
    /**
     * The ChangeTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChangeTypeID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ChangeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeType;
    /**
     * The ChangeItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeItem;
    /**
     * The ItemIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemIdentifier;
    /**
     * The FromStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromStatusName;
    /**
     * The ToStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToStatusName;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The ChangeUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeUserName;
    /**
     * Constructor method for AccountStatusHistory
     * @uses AccountStatusHistory::setAccountStatusHistoryID()
     * @uses AccountStatusHistory::setAccountID()
     * @uses AccountStatusHistory::setCreateDate()
     * @uses AccountStatusHistory::setToStatusID()
     * @uses AccountStatusHistory::setChangeTypeID()
     * @uses AccountStatusHistory::setAccountNumber()
     * @uses AccountStatusHistory::setChangeType()
     * @uses AccountStatusHistory::setChangeItem()
     * @uses AccountStatusHistory::setItemIdentifier()
     * @uses AccountStatusHistory::setFromStatusName()
     * @uses AccountStatusHistory::setToStatusName()
     * @uses AccountStatusHistory::setReason()
     * @uses AccountStatusHistory::setChangeUserName()
     * @param int $accountStatusHistoryID
     * @param int $accountID
     * @param string $createDate
     * @param int $toStatusID
     * @param int $changeTypeID
     * @param string $accountNumber
     * @param string $changeType
     * @param string $changeItem
     * @param string $itemIdentifier
     * @param string $fromStatusName
     * @param string $toStatusName
     * @param string $reason
     * @param string $changeUserName
     */
    public function __construct($accountStatusHistoryID = null, $accountID = null, $createDate = null, $toStatusID = null, $changeTypeID = null, $accountNumber = null, $changeType = null, $changeItem = null, $itemIdentifier = null, $fromStatusName = null, $toStatusName = null, $reason = null, $changeUserName = null)
    {
        $this
            ->setAccountStatusHistoryID($accountStatusHistoryID)
            ->setAccountID($accountID)
            ->setCreateDate($createDate)
            ->setToStatusID($toStatusID)
            ->setChangeTypeID($changeTypeID)
            ->setAccountNumber($accountNumber)
            ->setChangeType($changeType)
            ->setChangeItem($changeItem)
            ->setItemIdentifier($itemIdentifier)
            ->setFromStatusName($fromStatusName)
            ->setToStatusName($toStatusName)
            ->setReason($reason)
            ->setChangeUserName($changeUserName);
    }
    /**
     * Get AccountStatusHistoryID value
     * @return int
     */
    public function getAccountStatusHistoryID()
    {
        return $this->AccountStatusHistoryID;
    }
    /**
     * Set AccountStatusHistoryID value
     * @param int $accountStatusHistoryID
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setAccountStatusHistoryID($accountStatusHistoryID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusHistoryID) && !is_numeric($accountStatusHistoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusHistoryID)), __LINE__);
        }
        $this->AccountStatusHistoryID = $accountStatusHistoryID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get ToStatusID value
     * @return int
     */
    public function getToStatusID()
    {
        return $this->ToStatusID;
    }
    /**
     * Set ToStatusID value
     * @param int $toStatusID
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setToStatusID($toStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($toStatusID) && !is_numeric($toStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toStatusID)), __LINE__);
        }
        $this->ToStatusID = $toStatusID;
        return $this;
    }
    /**
     * Get ChangeTypeID value
     * @return int
     */
    public function getChangeTypeID()
    {
        return $this->ChangeTypeID;
    }
    /**
     * Set ChangeTypeID value
     * @param int $changeTypeID
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setChangeTypeID($changeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($changeTypeID) && !is_numeric($changeTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($changeTypeID)), __LINE__);
        }
        $this->ChangeTypeID = $changeTypeID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ChangeType value
     * @return string|null
     */
    public function getChangeType()
    {
        return $this->ChangeType;
    }
    /**
     * Set ChangeType value
     * @param string $changeType
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setChangeType($changeType = null)
    {
        // validation for constraint: string
        if (!is_null($changeType) && !is_string($changeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeType)), __LINE__);
        }
        $this->ChangeType = $changeType;
        return $this;
    }
    /**
     * Get ChangeItem value
     * @return string|null
     */
    public function getChangeItem()
    {
        return $this->ChangeItem;
    }
    /**
     * Set ChangeItem value
     * @param string $changeItem
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setChangeItem($changeItem = null)
    {
        // validation for constraint: string
        if (!is_null($changeItem) && !is_string($changeItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeItem)), __LINE__);
        }
        $this->ChangeItem = $changeItem;
        return $this;
    }
    /**
     * Get ItemIdentifier value
     * @return string|null
     */
    public function getItemIdentifier()
    {
        return $this->ItemIdentifier;
    }
    /**
     * Set ItemIdentifier value
     * @param string $itemIdentifier
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setItemIdentifier($itemIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($itemIdentifier) && !is_string($itemIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemIdentifier)), __LINE__);
        }
        $this->ItemIdentifier = $itemIdentifier;
        return $this;
    }
    /**
     * Get FromStatusName value
     * @return string|null
     */
    public function getFromStatusName()
    {
        return $this->FromStatusName;
    }
    /**
     * Set FromStatusName value
     * @param string $fromStatusName
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setFromStatusName($fromStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($fromStatusName) && !is_string($fromStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromStatusName)), __LINE__);
        }
        $this->FromStatusName = $fromStatusName;
        return $this;
    }
    /**
     * Get ToStatusName value
     * @return string|null
     */
    public function getToStatusName()
    {
        return $this->ToStatusName;
    }
    /**
     * Set ToStatusName value
     * @param string $toStatusName
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setToStatusName($toStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($toStatusName) && !is_string($toStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toStatusName)), __LINE__);
        }
        $this->ToStatusName = $toStatusName;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get ChangeUserName value
     * @return string|null
     */
    public function getChangeUserName()
    {
        return $this->ChangeUserName;
    }
    /**
     * Set ChangeUserName value
     * @param string $changeUserName
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public function setChangeUserName($changeUserName = null)
    {
        // validation for constraint: string
        if (!is_null($changeUserName) && !is_string($changeUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeUserName)), __LINE__);
        }
        $this->ChangeUserName = $changeUserName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountStatusHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
