<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountLookupResponse Struct
 * @subpackage Structs
 */
class AccountLookupResponse extends ServiceResponseBase
{
    /**
     * The IsAccountValid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAccountValid;
    /**
     * The AccountSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountSummary
     */
    public $AccountSummary;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Account
     */
    public $Account;
    /**
     * The Accounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccount
     */
    public $Accounts;
    /**
     * The PreviousAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountPrevious
     */
    public $PreviousAccounts;
    /**
     * Constructor method for AccountLookupResponse
     * @uses AccountLookupResponse::setIsAccountValid()
     * @uses AccountLookupResponse::setAccountSummary()
     * @uses AccountLookupResponse::setAccount()
     * @uses AccountLookupResponse::setAccounts()
     * @uses AccountLookupResponse::setPreviousAccounts()
     * @param bool $isAccountValid
     * @param \SGCIS\Array\ArrayOfAccountSummary $accountSummary
     * @param \SGCIS\Struct\Account $account
     * @param \SGCIS\Array\ArrayOfAccount $accounts
     * @param \SGCIS\Array\ArrayOfAccountPrevious $previousAccounts
     */
    public function __construct($isAccountValid = null, \SGCIS\Array\ArrayOfAccountSummary $accountSummary = null, \SGCIS\Struct\Account $account = null, \SGCIS\Array\ArrayOfAccount $accounts = null, \SGCIS\Array\ArrayOfAccountPrevious $previousAccounts = null)
    {
        $this
            ->setIsAccountValid($isAccountValid)
            ->setAccountSummary($accountSummary)
            ->setAccount($account)
            ->setAccounts($accounts)
            ->setPreviousAccounts($previousAccounts);
    }
    /**
     * Get IsAccountValid value
     * @return bool
     */
    public function getIsAccountValid()
    {
        return $this->IsAccountValid;
    }
    /**
     * Set IsAccountValid value
     * @param bool $isAccountValid
     * @return \SGCIS\Struct\AccountLookupResponse
     */
    public function setIsAccountValid($isAccountValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccountValid) && !is_bool($isAccountValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAccountValid)), __LINE__);
        }
        $this->IsAccountValid = $isAccountValid;
        return $this;
    }
    /**
     * Get AccountSummary value
     * @return \SGCIS\Array\ArrayOfAccountSummary|null
     */
    public function getAccountSummary()
    {
        return $this->AccountSummary;
    }
    /**
     * Set AccountSummary value
     * @param \SGCIS\Array\ArrayOfAccountSummary $accountSummary
     * @return \SGCIS\Struct\AccountLookupResponse
     */
    public function setAccountSummary(\SGCIS\Array\ArrayOfAccountSummary $accountSummary = null)
    {
        $this->AccountSummary = $accountSummary;
        return $this;
    }
    /**
     * Get Account value
     * @return \SGCIS\Struct\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \SGCIS\Struct\Account $account
     * @return \SGCIS\Struct\AccountLookupResponse
     */
    public function setAccount(\SGCIS\Struct\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Accounts value
     * @return \SGCIS\Array\ArrayOfAccount|null
     */
    public function getAccounts()
    {
        return $this->Accounts;
    }
    /**
     * Set Accounts value
     * @param \SGCIS\Array\ArrayOfAccount $accounts
     * @return \SGCIS\Struct\AccountLookupResponse
     */
    public function setAccounts(\SGCIS\Array\ArrayOfAccount $accounts = null)
    {
        $this->Accounts = $accounts;
        return $this;
    }
    /**
     * Get PreviousAccounts value
     * @return \SGCIS\Array\ArrayOfAccountPrevious|null
     */
    public function getPreviousAccounts()
    {
        return $this->PreviousAccounts;
    }
    /**
     * Set PreviousAccounts value
     * @param \SGCIS\Array\ArrayOfAccountPrevious $previousAccounts
     * @return \SGCIS\Struct\AccountLookupResponse
     */
    public function setPreviousAccounts(\SGCIS\Array\ArrayOfAccountPrevious $previousAccounts = null)
    {
        $this->PreviousAccounts = $previousAccounts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountLookupResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
