<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDocument Struct
 * @subpackage Structs
 */
class AccountDocument extends AbstractStructBase
{
    /**
     * The AccountDocumentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDocumentID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CreatedByUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatedByUserID;
    /**
     * The ProductDocumentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDocumentID;
    /**
     * The ServiceAgreementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementID;
    /**
     * The AccountDocumentTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDocumentTypeID;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The DocumentURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentURL;
    /**
     * The LOAReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LOAReferenceNumber;
    /**
     * The AccountDocumentTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountDocumentTypeName;
    /**
     * Constructor method for AccountDocument
     * @uses AccountDocument::setAccountDocumentID()
     * @uses AccountDocument::setAccountID()
     * @uses AccountDocument::setCreateDate()
     * @uses AccountDocument::setCreatedByUserID()
     * @uses AccountDocument::setProductDocumentID()
     * @uses AccountDocument::setServiceAgreementID()
     * @uses AccountDocument::setAccountDocumentTypeID()
     * @uses AccountDocument::setFileName()
     * @uses AccountDocument::setDescription()
     * @uses AccountDocument::setContent()
     * @uses AccountDocument::setUserName()
     * @uses AccountDocument::setDocumentURL()
     * @uses AccountDocument::setLOAReferenceNumber()
     * @uses AccountDocument::setAccountDocumentTypeName()
     * @param int $accountDocumentID
     * @param int $accountID
     * @param string $createDate
     * @param int $createdByUserID
     * @param int $productDocumentID
     * @param int $serviceAgreementID
     * @param int $accountDocumentTypeID
     * @param string $fileName
     * @param string $description
     * @param string $content
     * @param string $userName
     * @param string $documentURL
     * @param string $lOAReferenceNumber
     * @param string $accountDocumentTypeName
     */
    public function __construct($accountDocumentID = null, $accountID = null, $createDate = null, $createdByUserID = null, $productDocumentID = null, $serviceAgreementID = null, $accountDocumentTypeID = null, $fileName = null, $description = null, $content = null, $userName = null, $documentURL = null, $lOAReferenceNumber = null, $accountDocumentTypeName = null)
    {
        $this
            ->setAccountDocumentID($accountDocumentID)
            ->setAccountID($accountID)
            ->setCreateDate($createDate)
            ->setCreatedByUserID($createdByUserID)
            ->setProductDocumentID($productDocumentID)
            ->setServiceAgreementID($serviceAgreementID)
            ->setAccountDocumentTypeID($accountDocumentTypeID)
            ->setFileName($fileName)
            ->setDescription($description)
            ->setContent($content)
            ->setUserName($userName)
            ->setDocumentURL($documentURL)
            ->setLOAReferenceNumber($lOAReferenceNumber)
            ->setAccountDocumentTypeName($accountDocumentTypeName);
    }
    /**
     * Get AccountDocumentID value
     * @return int
     */
    public function getAccountDocumentID()
    {
        return $this->AccountDocumentID;
    }
    /**
     * Set AccountDocumentID value
     * @param int $accountDocumentID
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setAccountDocumentID($accountDocumentID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDocumentID) && !is_numeric($accountDocumentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDocumentID)), __LINE__);
        }
        $this->AccountDocumentID = $accountDocumentID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreatedByUserID value
     * @return int
     */
    public function getCreatedByUserID()
    {
        return $this->CreatedByUserID;
    }
    /**
     * Set CreatedByUserID value
     * @param int $createdByUserID
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setCreatedByUserID($createdByUserID = null)
    {
        // validation for constraint: int
        if (!is_null($createdByUserID) && !is_numeric($createdByUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByUserID)), __LINE__);
        }
        $this->CreatedByUserID = $createdByUserID;
        return $this;
    }
    /**
     * Get ProductDocumentID value
     * @return int
     */
    public function getProductDocumentID()
    {
        return $this->ProductDocumentID;
    }
    /**
     * Set ProductDocumentID value
     * @param int $productDocumentID
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setProductDocumentID($productDocumentID = null)
    {
        // validation for constraint: int
        if (!is_null($productDocumentID) && !is_numeric($productDocumentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDocumentID)), __LINE__);
        }
        $this->ProductDocumentID = $productDocumentID;
        return $this;
    }
    /**
     * Get ServiceAgreementID value
     * @return int
     */
    public function getServiceAgreementID()
    {
        return $this->ServiceAgreementID;
    }
    /**
     * Set ServiceAgreementID value
     * @param int $serviceAgreementID
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setServiceAgreementID($serviceAgreementID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementID) && !is_numeric($serviceAgreementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementID)), __LINE__);
        }
        $this->ServiceAgreementID = $serviceAgreementID;
        return $this;
    }
    /**
     * Get AccountDocumentTypeID value
     * @return int
     */
    public function getAccountDocumentTypeID()
    {
        return $this->AccountDocumentTypeID;
    }
    /**
     * Set AccountDocumentTypeID value
     * @param int $accountDocumentTypeID
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setAccountDocumentTypeID($accountDocumentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDocumentTypeID) && !is_numeric($accountDocumentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDocumentTypeID)), __LINE__);
        }
        $this->AccountDocumentTypeID = $accountDocumentTypeID;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get DocumentURL value
     * @return string|null
     */
    public function getDocumentURL()
    {
        return $this->DocumentURL;
    }
    /**
     * Set DocumentURL value
     * @param string $documentURL
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setDocumentURL($documentURL = null)
    {
        // validation for constraint: string
        if (!is_null($documentURL) && !is_string($documentURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentURL)), __LINE__);
        }
        $this->DocumentURL = $documentURL;
        return $this;
    }
    /**
     * Get LOAReferenceNumber value
     * @return string|null
     */
    public function getLOAReferenceNumber()
    {
        return $this->LOAReferenceNumber;
    }
    /**
     * Set LOAReferenceNumber value
     * @param string $lOAReferenceNumber
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setLOAReferenceNumber($lOAReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lOAReferenceNumber) && !is_string($lOAReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lOAReferenceNumber)), __LINE__);
        }
        $this->LOAReferenceNumber = $lOAReferenceNumber;
        return $this;
    }
    /**
     * Get AccountDocumentTypeName value
     * @return string|null
     */
    public function getAccountDocumentTypeName()
    {
        return $this->AccountDocumentTypeName;
    }
    /**
     * Set AccountDocumentTypeName value
     * @param string $accountDocumentTypeName
     * @return \SGCIS\Struct\AccountDocument
     */
    public function setAccountDocumentTypeName($accountDocumentTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($accountDocumentTypeName) && !is_string($accountDocumentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountDocumentTypeName)), __LINE__);
        }
        $this->AccountDocumentTypeName = $accountDocumentTypeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
