<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountAutoPay Struct
 * @subpackage Structs
 */
class AccountAutoPay extends BaseDTO
{
    /**
     * The AccountAutoPayID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountAutoPayID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PaymentAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentAccountID;
    /**
     * The PaymentAccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentAccountTypeID;
    /**
     * The AutoPayAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AutoPayAmount;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The SystemEventTriggerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemEventTriggerID;
    /**
     * The BalanceThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceThreshold;
    /**
     * The DuringEnrollment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DuringEnrollment;
    /**
     * The PaymentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentAccount
     */
    public $PaymentAccount;
    /**
     * The PaymentAccountTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAccountTypeName;
    /**
     * The PaymentAccountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAccountName;
    /**
     * The SystemEventName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemEventName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for AccountAutoPay
     * @uses AccountAutoPay::setAccountAutoPayID()
     * @uses AccountAutoPay::setAccountID()
     * @uses AccountAutoPay::setPaymentAccountID()
     * @uses AccountAutoPay::setPaymentAccountTypeID()
     * @uses AccountAutoPay::setAutoPayAmount()
     * @uses AccountAutoPay::setActive()
     * @uses AccountAutoPay::setIsDeleted()
     * @uses AccountAutoPay::setStartDate()
     * @uses AccountAutoPay::setEndDate()
     * @uses AccountAutoPay::setSystemEventTriggerID()
     * @uses AccountAutoPay::setBalanceThreshold()
     * @uses AccountAutoPay::setDuringEnrollment()
     * @uses AccountAutoPay::setPaymentAccount()
     * @uses AccountAutoPay::setPaymentAccountTypeName()
     * @uses AccountAutoPay::setPaymentAccountName()
     * @uses AccountAutoPay::setSystemEventName()
     * @uses AccountAutoPay::setAccountNumber()
     * @param int $accountAutoPayID
     * @param int $accountID
     * @param int $paymentAccountID
     * @param int $paymentAccountTypeID
     * @param float $autoPayAmount
     * @param bool $active
     * @param bool $isDeleted
     * @param string $startDate
     * @param string $endDate
     * @param int $systemEventTriggerID
     * @param float $balanceThreshold
     * @param bool $duringEnrollment
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @param string $paymentAccountTypeName
     * @param string $paymentAccountName
     * @param string $systemEventName
     * @param string $accountNumber
     */
    public function __construct($accountAutoPayID = null, $accountID = null, $paymentAccountID = null, $paymentAccountTypeID = null, $autoPayAmount = null, $active = null, $isDeleted = null, $startDate = null, $endDate = null, $systemEventTriggerID = null, $balanceThreshold = null, $duringEnrollment = null, \SGCIS\Struct\PaymentAccount $paymentAccount = null, $paymentAccountTypeName = null, $paymentAccountName = null, $systemEventName = null, $accountNumber = null)
    {
        $this
            ->setAccountAutoPayID($accountAutoPayID)
            ->setAccountID($accountID)
            ->setPaymentAccountID($paymentAccountID)
            ->setPaymentAccountTypeID($paymentAccountTypeID)
            ->setAutoPayAmount($autoPayAmount)
            ->setActive($active)
            ->setIsDeleted($isDeleted)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setSystemEventTriggerID($systemEventTriggerID)
            ->setBalanceThreshold($balanceThreshold)
            ->setDuringEnrollment($duringEnrollment)
            ->setPaymentAccount($paymentAccount)
            ->setPaymentAccountTypeName($paymentAccountTypeName)
            ->setPaymentAccountName($paymentAccountName)
            ->setSystemEventName($systemEventName)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get AccountAutoPayID value
     * @return int
     */
    public function getAccountAutoPayID()
    {
        return $this->AccountAutoPayID;
    }
    /**
     * Set AccountAutoPayID value
     * @param int $accountAutoPayID
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setAccountAutoPayID($accountAutoPayID = null)
    {
        // validation for constraint: int
        if (!is_null($accountAutoPayID) && !is_numeric($accountAutoPayID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountAutoPayID)), __LINE__);
        }
        $this->AccountAutoPayID = $accountAutoPayID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PaymentAccountID value
     * @return int
     */
    public function getPaymentAccountID()
    {
        return $this->PaymentAccountID;
    }
    /**
     * Set PaymentAccountID value
     * @param int $paymentAccountID
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setPaymentAccountID($paymentAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentAccountID) && !is_numeric($paymentAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentAccountID)), __LINE__);
        }
        $this->PaymentAccountID = $paymentAccountID;
        return $this;
    }
    /**
     * Get PaymentAccountTypeID value
     * @return int
     */
    public function getPaymentAccountTypeID()
    {
        return $this->PaymentAccountTypeID;
    }
    /**
     * Set PaymentAccountTypeID value
     * @param int $paymentAccountTypeID
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setPaymentAccountTypeID($paymentAccountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentAccountTypeID) && !is_numeric($paymentAccountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentAccountTypeID)), __LINE__);
        }
        $this->PaymentAccountTypeID = $paymentAccountTypeID;
        return $this;
    }
    /**
     * Get AutoPayAmount value
     * @return float
     */
    public function getAutoPayAmount()
    {
        return $this->AutoPayAmount;
    }
    /**
     * Set AutoPayAmount value
     * @param float $autoPayAmount
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setAutoPayAmount($autoPayAmount = null)
    {
        $this->AutoPayAmount = $autoPayAmount;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get SystemEventTriggerID value
     * @return int
     */
    public function getSystemEventTriggerID()
    {
        return $this->SystemEventTriggerID;
    }
    /**
     * Set SystemEventTriggerID value
     * @param int $systemEventTriggerID
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setSystemEventTriggerID($systemEventTriggerID = null)
    {
        // validation for constraint: int
        if (!is_null($systemEventTriggerID) && !is_numeric($systemEventTriggerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemEventTriggerID)), __LINE__);
        }
        $this->SystemEventTriggerID = $systemEventTriggerID;
        return $this;
    }
    /**
     * Get BalanceThreshold value
     * @return float
     */
    public function getBalanceThreshold()
    {
        return $this->BalanceThreshold;
    }
    /**
     * Set BalanceThreshold value
     * @param float $balanceThreshold
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setBalanceThreshold($balanceThreshold = null)
    {
        $this->BalanceThreshold = $balanceThreshold;
        return $this;
    }
    /**
     * Get DuringEnrollment value
     * @return bool
     */
    public function getDuringEnrollment()
    {
        return $this->DuringEnrollment;
    }
    /**
     * Set DuringEnrollment value
     * @param bool $duringEnrollment
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setDuringEnrollment($duringEnrollment = null)
    {
        // validation for constraint: boolean
        if (!is_null($duringEnrollment) && !is_bool($duringEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($duringEnrollment)), __LINE__);
        }
        $this->DuringEnrollment = $duringEnrollment;
        return $this;
    }
    /**
     * Get PaymentAccount value
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function getPaymentAccount()
    {
        return $this->PaymentAccount;
    }
    /**
     * Set PaymentAccount value
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setPaymentAccount(\SGCIS\Struct\PaymentAccount $paymentAccount = null)
    {
        $this->PaymentAccount = $paymentAccount;
        return $this;
    }
    /**
     * Get PaymentAccountTypeName value
     * @return string|null
     */
    public function getPaymentAccountTypeName()
    {
        return $this->PaymentAccountTypeName;
    }
    /**
     * Set PaymentAccountTypeName value
     * @param string $paymentAccountTypeName
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setPaymentAccountTypeName($paymentAccountTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAccountTypeName) && !is_string($paymentAccountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAccountTypeName)), __LINE__);
        }
        $this->PaymentAccountTypeName = $paymentAccountTypeName;
        return $this;
    }
    /**
     * Get PaymentAccountName value
     * @return string|null
     */
    public function getPaymentAccountName()
    {
        return $this->PaymentAccountName;
    }
    /**
     * Set PaymentAccountName value
     * @param string $paymentAccountName
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setPaymentAccountName($paymentAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAccountName) && !is_string($paymentAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAccountName)), __LINE__);
        }
        $this->PaymentAccountName = $paymentAccountName;
        return $this;
    }
    /**
     * Get SystemEventName value
     * @return string|null
     */
    public function getSystemEventName()
    {
        return $this->SystemEventName;
    }
    /**
     * Set SystemEventName value
     * @param string $systemEventName
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setSystemEventName($systemEventName = null)
    {
        // validation for constraint: string
        if (!is_null($systemEventName) && !is_string($systemEventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemEventName)), __LINE__);
        }
        $this->SystemEventName = $systemEventName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountAutoPay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
