<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountActivityResponse Struct
 * @subpackage Structs
 */
class AccountActivityResponse extends ServiceResponseBase
{
    /**
     * The MeterReads
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePointMeterRead
     */
    public $MeterReads;
    /**
     * The AccountCommunications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountCommunication
     */
    public $AccountCommunications;
    /**
     * The AccountTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountTransaction
     */
    public $AccountTransactions;
    /**
     * The ZipCodeWeatherArray
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfZipCodeWeather
     */
    public $ZipCodeWeatherArray;
    /**
     * The SummaryTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountSummaryTransaction
     */
    public $SummaryTransactions;
    /**
     * The AccountTransactionSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountTransactionSummary
     */
    public $AccountTransactionSummary;
    /**
     * Constructor method for AccountActivityResponse
     * @uses AccountActivityResponse::setMeterReads()
     * @uses AccountActivityResponse::setAccountCommunications()
     * @uses AccountActivityResponse::setAccountTransactions()
     * @uses AccountActivityResponse::setZipCodeWeatherArray()
     * @uses AccountActivityResponse::setSummaryTransactions()
     * @uses AccountActivityResponse::setAccountTransactionSummary()
     * @param \SGCIS\Array\ArrayOfServicePointMeterRead $meterReads
     * @param \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications
     * @param \SGCIS\Array\ArrayOfAccountTransaction $accountTransactions
     * @param \SGCIS\Array\ArrayOfZipCodeWeather $zipCodeWeatherArray
     * @param \SGCIS\Array\ArrayOfAccountSummaryTransaction $summaryTransactions
     * @param \SGCIS\Struct\AccountTransactionSummary $accountTransactionSummary
     */
    public function __construct(\SGCIS\Array\ArrayOfServicePointMeterRead $meterReads = null, \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications = null, \SGCIS\Array\ArrayOfAccountTransaction $accountTransactions = null, \SGCIS\Array\ArrayOfZipCodeWeather $zipCodeWeatherArray = null, \SGCIS\Array\ArrayOfAccountSummaryTransaction $summaryTransactions = null, \SGCIS\Struct\AccountTransactionSummary $accountTransactionSummary = null)
    {
        $this
            ->setMeterReads($meterReads)
            ->setAccountCommunications($accountCommunications)
            ->setAccountTransactions($accountTransactions)
            ->setZipCodeWeatherArray($zipCodeWeatherArray)
            ->setSummaryTransactions($summaryTransactions)
            ->setAccountTransactionSummary($accountTransactionSummary);
    }
    /**
     * Get MeterReads value
     * @return \SGCIS\Array\ArrayOfServicePointMeterRead|null
     */
    public function getMeterReads()
    {
        return $this->MeterReads;
    }
    /**
     * Set MeterReads value
     * @param \SGCIS\Array\ArrayOfServicePointMeterRead $meterReads
     * @return \SGCIS\Struct\AccountActivityResponse
     */
    public function setMeterReads(\SGCIS\Array\ArrayOfServicePointMeterRead $meterReads = null)
    {
        $this->MeterReads = $meterReads;
        return $this;
    }
    /**
     * Get AccountCommunications value
     * @return \SGCIS\Array\ArrayOfAccountCommunication|null
     */
    public function getAccountCommunications()
    {
        return $this->AccountCommunications;
    }
    /**
     * Set AccountCommunications value
     * @param \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications
     * @return \SGCIS\Struct\AccountActivityResponse
     */
    public function setAccountCommunications(\SGCIS\Array\ArrayOfAccountCommunication $accountCommunications = null)
    {
        $this->AccountCommunications = $accountCommunications;
        return $this;
    }
    /**
     * Get AccountTransactions value
     * @return \SGCIS\Array\ArrayOfAccountTransaction|null
     */
    public function getAccountTransactions()
    {
        return $this->AccountTransactions;
    }
    /**
     * Set AccountTransactions value
     * @param \SGCIS\Array\ArrayOfAccountTransaction $accountTransactions
     * @return \SGCIS\Struct\AccountActivityResponse
     */
    public function setAccountTransactions(\SGCIS\Array\ArrayOfAccountTransaction $accountTransactions = null)
    {
        $this->AccountTransactions = $accountTransactions;
        return $this;
    }
    /**
     * Get ZipCodeWeatherArray value
     * @return \SGCIS\Array\ArrayOfZipCodeWeather|null
     */
    public function getZipCodeWeatherArray()
    {
        return $this->ZipCodeWeatherArray;
    }
    /**
     * Set ZipCodeWeatherArray value
     * @param \SGCIS\Array\ArrayOfZipCodeWeather $zipCodeWeatherArray
     * @return \SGCIS\Struct\AccountActivityResponse
     */
    public function setZipCodeWeatherArray(\SGCIS\Array\ArrayOfZipCodeWeather $zipCodeWeatherArray = null)
    {
        $this->ZipCodeWeatherArray = $zipCodeWeatherArray;
        return $this;
    }
    /**
     * Get SummaryTransactions value
     * @return \SGCIS\Array\ArrayOfAccountSummaryTransaction|null
     */
    public function getSummaryTransactions()
    {
        return $this->SummaryTransactions;
    }
    /**
     * Set SummaryTransactions value
     * @param \SGCIS\Array\ArrayOfAccountSummaryTransaction $summaryTransactions
     * @return \SGCIS\Struct\AccountActivityResponse
     */
    public function setSummaryTransactions(\SGCIS\Array\ArrayOfAccountSummaryTransaction $summaryTransactions = null)
    {
        $this->SummaryTransactions = $summaryTransactions;
        return $this;
    }
    /**
     * Get AccountTransactionSummary value
     * @return \SGCIS\Struct\AccountTransactionSummary|null
     */
    public function getAccountTransactionSummary()
    {
        return $this->AccountTransactionSummary;
    }
    /**
     * Set AccountTransactionSummary value
     * @param \SGCIS\Struct\AccountTransactionSummary $accountTransactionSummary
     * @return \SGCIS\Struct\AccountActivityResponse
     */
    public function setAccountTransactionSummary(\SGCIS\Struct\AccountTransactionSummary $accountTransactionSummary = null)
    {
        $this->AccountTransactionSummary = $accountTransactionSummary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountActivityResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
