<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountAccountFlag Struct
 * @subpackage Structs
 */
class AccountAccountFlag extends AbstractStructBase
{
    /**
     * The AccountAccountFlagID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountAccountFlagID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountFlagID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountFlagID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for AccountAccountFlag
     * @uses AccountAccountFlag::setAccountAccountFlagID()
     * @uses AccountAccountFlag::setAccountID()
     * @uses AccountAccountFlag::setAccountFlagID()
     * @uses AccountAccountFlag::setCreateDate()
     * @param int $accountAccountFlagID
     * @param int $accountID
     * @param int $accountFlagID
     * @param string $createDate
     */
    public function __construct($accountAccountFlagID = null, $accountID = null, $accountFlagID = null, $createDate = null)
    {
        $this
            ->setAccountAccountFlagID($accountAccountFlagID)
            ->setAccountID($accountID)
            ->setAccountFlagID($accountFlagID)
            ->setCreateDate($createDate);
    }
    /**
     * Get AccountAccountFlagID value
     * @return int
     */
    public function getAccountAccountFlagID()
    {
        return $this->AccountAccountFlagID;
    }
    /**
     * Set AccountAccountFlagID value
     * @param int $accountAccountFlagID
     * @return \SGCIS\Struct\AccountAccountFlag
     */
    public function setAccountAccountFlagID($accountAccountFlagID = null)
    {
        // validation for constraint: int
        if (!is_null($accountAccountFlagID) && !is_numeric($accountAccountFlagID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountAccountFlagID)), __LINE__);
        }
        $this->AccountAccountFlagID = $accountAccountFlagID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountAccountFlag
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountFlagID value
     * @return int
     */
    public function getAccountFlagID()
    {
        return $this->AccountFlagID;
    }
    /**
     * Set AccountFlagID value
     * @param int $accountFlagID
     * @return \SGCIS\Struct\AccountAccountFlag
     */
    public function setAccountFlagID($accountFlagID = null)
    {
        // validation for constraint: int
        if (!is_null($accountFlagID) && !is_numeric($accountFlagID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountFlagID)), __LINE__);
        }
        $this->AccountFlagID = $accountFlagID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\AccountAccountFlag
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountAccountFlag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
