<?php

namespace SGCIS;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'GetAccountShallowCopy' => '\\SGCIS\\Struct\\GetAccountShallowCopy',
            'AccountRequest' => '\\SGCIS\\Struct\\AccountRequest',
            'ServiceRequestBase' => '\\SGCIS\\Struct\\ServiceRequestBase',
            'AuthenticationHeader' => '\\SGCIS\\Struct\\AuthenticationHeader',
            'Account' => '\\SGCIS\\Struct\\Account',
            'BaseDTO' => '\\SGCIS\\Struct\\BaseDTO',
            'AccountDepositTransaction' => '\\SGCIS\\Struct\\AccountDepositTransaction',
            'AccountDepositSchedule' => '\\SGCIS\\Struct\\AccountDepositSchedule',
            'TicketStatusHistory' => '\\SGCIS\\Struct\\TicketStatusHistory',
            'TicketSla' => '\\SGCIS\\Struct\\TicketSla',
            'TicketPriority' => '\\SGCIS\\Struct\\TicketPriority',
            'TicketType' => '\\SGCIS\\Struct\\TicketType',
            'ArrayOfTicketTypeQueue' => '\\SGCIS\\Array\\ArrayOfTicketTypeQueue',
            'TicketTypeQueue' => '\\SGCIS\\Struct\\TicketTypeQueue',
            'ArrayOfTicketTypeField' => '\\SGCIS\\Array\\ArrayOfTicketTypeField',
            'TicketTypeField' => '\\SGCIS\\Struct\\TicketTypeField',
            'ArrayOfTicketQueueType' => '\\SGCIS\\Array\\ArrayOfTicketQueueType',
            'TicketQueueType' => '\\SGCIS\\Struct\\TicketQueueType',
            'ArrayOfSystemRoleTicketQueueType' => '\\SGCIS\\Array\\ArrayOfSystemRoleTicketQueueType',
            'SystemRoleTicketQueueType' => '\\SGCIS\\Struct\\SystemRoleTicketQueueType',
            'TicketQueue' => '\\SGCIS\\Struct\\TicketQueue',
            'ArrayOfTicket' => '\\SGCIS\\Array\\ArrayOfTicket',
            'Ticket' => '\\SGCIS\\Struct\\Ticket',
            'ArrayOfTicketNote' => '\\SGCIS\\Array\\ArrayOfTicketNote',
            'TicketNote' => '\\SGCIS\\Struct\\TicketNote',
            'ArrayOfTicketFieldValue' => '\\SGCIS\\Array\\ArrayOfTicketFieldValue',
            'TicketFieldValue' => '\\SGCIS\\Struct\\TicketFieldValue',
            'ArrayOfTicketStatusHistory' => '\\SGCIS\\Array\\ArrayOfTicketStatusHistory',
            'ArrayOfTicketField' => '\\SGCIS\\Array\\ArrayOfTicketField',
            'TicketField' => '\\SGCIS\\Struct\\TicketField',
            'ServiceOrderNote' => '\\SGCIS\\Struct\\ServiceOrderNote',
            'ServiceOrder' => '\\SGCIS\\Struct\\ServiceOrder',
            'ArrayOfServiceOrderNote' => '\\SGCIS\\Array\\ArrayOfServiceOrderNote',
            'PaymentArrangement' => '\\SGCIS\\Struct\\PaymentArrangement',
            'AccountAddress' => '\\SGCIS\\Struct\\AccountAddress',
            'ArrayOfPaymentArrangementSchedule' => '\\SGCIS\\Array\\ArrayOfPaymentArrangementSchedule',
            'PaymentArrangementSchedule' => '\\SGCIS\\Struct\\PaymentArrangementSchedule',
            'ArrayOfPaymentArrangementBill' => '\\SGCIS\\Array\\ArrayOfPaymentArrangementBill',
            'PaymentArrangementBill' => '\\SGCIS\\Struct\\PaymentArrangementBill',
            'ArrayOfPaymentArrangementReceivable' => '\\SGCIS\\Array\\ArrayOfPaymentArrangementReceivable',
            'PaymentArrangementReceivable' => '\\SGCIS\\Struct\\PaymentArrangementReceivable',
            'AccountNote' => '\\SGCIS\\Struct\\AccountNote',
            'DistributionPoint' => '\\SGCIS\\Struct\\DistributionPoint',
            'AccountPerson' => '\\SGCIS\\Struct\\AccountPerson',
            'PersonContact' => '\\SGCIS\\Struct\\PersonContact',
            'ContactType' => '\\SGCIS\\Struct\\ContactType',
            'Person' => '\\SGCIS\\Struct\\Person',
            'PersonType' => '\\SGCIS\\Struct\\PersonType',
            'ServicePoint' => '\\SGCIS\\Struct\\ServicePoint',
            'ServicePointMeter' => '\\SGCIS\\Struct\\ServicePointMeter',
            'Meter' => '\\SGCIS\\Struct\\Meter',
            'ArrayOfServicePointMeter' => '\\SGCIS\\Array\\ArrayOfServicePointMeter',
            'ArrayOfAccountServicePoint' => '\\SGCIS\\Array\\ArrayOfAccountServicePoint',
            'AccountServicePoint' => '\\SGCIS\\Struct\\AccountServicePoint',
            'ArrayOfServiceAgreement' => '\\SGCIS\\Array\\ArrayOfServiceAgreement',
            'ServiceAgreement' => '\\SGCIS\\Struct\\ServiceAgreement',
            'ArrayOfProductDocument' => '\\SGCIS\\Array\\ArrayOfProductDocument',
            'ProductDocument' => '\\SGCIS\\Struct\\ProductDocument',
            'ArrayOfAccountServicePointTarrifCharge' => '\\SGCIS\\Array\\ArrayOfAccountServicePointTarrifCharge',
            'AccountServicePointTarrifCharge' => '\\SGCIS\\Struct\\AccountServicePointTarrifCharge',
            'Rate' => '\\SGCIS\\Struct\\Rate',
            'ArrayOfUsageCharge' => '\\SGCIS\\Array\\ArrayOfUsageCharge',
            'UsageCharge' => '\\SGCIS\\Struct\\UsageCharge',
            'ArrayOfUsageChargeAccountType' => '\\SGCIS\\Array\\ArrayOfUsageChargeAccountType',
            'UsageChargeAccountType' => '\\SGCIS\\Struct\\UsageChargeAccountType',
            'ArrayOfTOU' => '\\SGCIS\\Array\\ArrayOfTOU',
            'TOU' => '\\SGCIS\\Struct\\TOU',
            'ArrayOfDateTime' => '\\SGCIS\\Array\\ArrayOfDateTime',
            'ArrayOfTOUChargeSchedule' => '\\SGCIS\\Array\\ArrayOfTOUChargeSchedule',
            'TOUChargeSchedule' => '\\SGCIS\\Struct\\TOUChargeSchedule',
            'ArrayOfUsageChargeTier' => '\\SGCIS\\Array\\ArrayOfUsageChargeTier',
            'UsageChargeTier' => '\\SGCIS\\Struct\\UsageChargeTier',
            'ArrayOfRateAdder' => '\\SGCIS\\Array\\ArrayOfRateAdder',
            'RateAdder' => '\\SGCIS\\Struct\\RateAdder',
            'ArrayOfRateTariffCharge' => '\\SGCIS\\Array\\ArrayOfRateTariffCharge',
            'RateTariffCharge' => '\\SGCIS\\Struct\\RateTariffCharge',
            'ArrayOfRateUsageCharge' => '\\SGCIS\\Array\\ArrayOfRateUsageCharge',
            'RateUsageCharge' => '\\SGCIS\\Struct\\RateUsageCharge',
            'ArrayOfRateOtherCharge' => '\\SGCIS\\Array\\ArrayOfRateOtherCharge',
            'RateOtherCharge' => '\\SGCIS\\Struct\\RateOtherCharge',
            'ArrayOfCharge' => '\\SGCIS\\Array\\ArrayOfCharge',
            'Charge' => '\\SGCIS\\Struct\\Charge',
            'ArrayOfChargeAccountType' => '\\SGCIS\\Array\\ArrayOfChargeAccountType',
            'ChargeAccountType' => '\\SGCIS\\Struct\\ChargeAccountType',
            'ArrayOfChargeDistributionServiceProvider' => '\\SGCIS\\Array\\ArrayOfChargeDistributionServiceProvider',
            'ChargeDistributionServiceProvider' => '\\SGCIS\\Struct\\ChargeDistributionServiceProvider',
            'ArrayOfChargeTier' => '\\SGCIS\\Array\\ArrayOfChargeTier',
            'ChargeTier' => '\\SGCIS\\Struct\\ChargeTier',
            'ChargeSchedule' => '\\SGCIS\\Struct\\ChargeSchedule',
            'ArrayOfChargeCharacteristic' => '\\SGCIS\\Array\\ArrayOfChargeCharacteristic',
            'ChargeCharacteristic' => '\\SGCIS\\Struct\\ChargeCharacteristic',
            'ArrayOfRateCharacteristic' => '\\SGCIS\\Array\\ArrayOfRateCharacteristic',
            'RateCharacteristic' => '\\SGCIS\\Struct\\RateCharacteristic',
            'ArrayOfChargeGroup' => '\\SGCIS\\Array\\ArrayOfChargeGroup',
            'ChargeGroup' => '\\SGCIS\\Struct\\ChargeGroup',
            'ArrayOfPromotion' => '\\SGCIS\\Array\\ArrayOfPromotion',
            'Promotion' => '\\SGCIS\\Struct\\Promotion',
            'ArrayOfPromotionAccountType' => '\\SGCIS\\Array\\ArrayOfPromotionAccountType',
            'PromotionAccountType' => '\\SGCIS\\Struct\\PromotionAccountType',
            'ArrayOfPromotionDistributionServiceProvider' => '\\SGCIS\\Array\\ArrayOfPromotionDistributionServiceProvider',
            'PromotionDistributionServiceProvider' => '\\SGCIS\\Struct\\PromotionDistributionServiceProvider',
            'PromotionSchedule' => '\\SGCIS\\Struct\\PromotionSchedule',
            'ArrayOfPromotionTier' => '\\SGCIS\\Array\\ArrayOfPromotionTier',
            'PromotionTier' => '\\SGCIS\\Struct\\PromotionTier',
            'ArrayOfDistributionServiceProvider' => '\\SGCIS\\Array\\ArrayOfDistributionServiceProvider',
            'DistributionServiceProvider' => '\\SGCIS\\Struct\\DistributionServiceProvider',
            'ArrayOfDistributionServiceProviderAudit' => '\\SGCIS\\Array\\ArrayOfDistributionServiceProviderAudit',
            'DistributionServiceProviderAudit' => '\\SGCIS\\Struct\\DistributionServiceProviderAudit',
            'ArrayOfMonthlyBillingCycle' => '\\SGCIS\\Array\\ArrayOfMonthlyBillingCycle',
            'MonthlyBillingCycle' => '\\SGCIS\\Struct\\MonthlyBillingCycle',
            'ServiceProviderWorkingDays' => '\\SGCIS\\Struct\\ServiceProviderWorkingDays',
            'ArrayOfPromotionCharacteristic' => '\\SGCIS\\Array\\ArrayOfPromotionCharacteristic',
            'PromotionCharacteristic' => '\\SGCIS\\Struct\\PromotionCharacteristic',
            'ArrayOfPromotionScheduleSpecificDay' => '\\SGCIS\\Array\\ArrayOfPromotionScheduleSpecificDay',
            'PromotionScheduleSpecificDay' => '\\SGCIS\\Struct\\PromotionScheduleSpecificDay',
            'Product' => '\\SGCIS\\Struct\\Product',
            'ArrayOfApplication' => '\\SGCIS\\Array\\ArrayOfApplication',
            'Application' => '\\SGCIS\\Struct\\Application',
            'ArrayOfProductAccountType' => '\\SGCIS\\Array\\ArrayOfProductAccountType',
            'ProductAccountType' => '\\SGCIS\\Struct\\ProductAccountType',
            'ArrayOfCompany' => '\\SGCIS\\Array\\ArrayOfCompany',
            'Company' => '\\SGCIS\\Struct\\Company',
            'ArrayOfInt' => '\\SGCIS\\Array\\ArrayOfInt',
            'ArrayOfProductRate' => '\\SGCIS\\Array\\ArrayOfProductRate',
            'ProductRate' => '\\SGCIS\\Struct\\ProductRate',
            'ArrayOfProductAudit' => '\\SGCIS\\Array\\ArrayOfProductAudit',
            'ProductAudit' => '\\SGCIS\\Struct\\ProductAudit',
            'ArrayOfProductAvgPrice' => '\\SGCIS\\Array\\ArrayOfProductAvgPrice',
            'ProductAvgPrice' => '\\SGCIS\\Struct\\ProductAvgPrice',
            'ProductDisplay' => '\\SGCIS\\Struct\\ProductDisplay',
            'ArrayOfProductDisplayTDSP' => '\\SGCIS\\Array\\ArrayOfProductDisplayTDSP',
            'ProductDisplayTDSP' => '\\SGCIS\\Struct\\ProductDisplayTDSP',
            'ArrayOfServicePointMeterGroup' => '\\SGCIS\\Array\\ArrayOfServicePointMeterGroup',
            'ServicePointMeterGroup' => '\\SGCIS\\Struct\\ServicePointMeterGroup',
            'ArrayOfPersonContact' => '\\SGCIS\\Array\\ArrayOfPersonContact',
            'ArrayOfNotificationChannel' => '\\SGCIS\\Array\\ArrayOfNotificationChannel',
            'NotificationChannel' => '\\SGCIS\\Struct\\NotificationChannel',
            'ArrayOfAccountPerson' => '\\SGCIS\\Array\\ArrayOfAccountPerson',
            'PaymentAccount' => '\\SGCIS\\Struct\\PaymentAccount',
            'AccountAutoPay' => '\\SGCIS\\Struct\\AccountAutoPay',
            'ServicePointMeterRead' => '\\SGCIS\\Struct\\ServicePointMeterRead',
            'ArrayOfServicePointMeterReadDetail' => '\\SGCIS\\Array\\ArrayOfServicePointMeterReadDetail',
            'ServicePointMeterReadDetail' => '\\SGCIS\\Struct\\ServicePointMeterReadDetail',
            'ArrayOfServicePointMeterRead' => '\\SGCIS\\Array\\ArrayOfServicePointMeterRead',
            'ArrayOfMeterRead' => '\\SGCIS\\Array\\ArrayOfMeterRead',
            'MeterRead' => '\\SGCIS\\Struct\\MeterRead',
            'ArrayOfMeterReadDetail' => '\\SGCIS\\Array\\ArrayOfMeterReadDetail',
            'MeterReadDetail' => '\\SGCIS\\Struct\\MeterReadDetail',
            'ArrayOfMeterReadDetailFailedValidationRule' => '\\SGCIS\\Array\\ArrayOfMeterReadDetailFailedValidationRule',
            'MeterReadDetailFailedValidationRule' => '\\SGCIS\\Struct\\MeterReadDetailFailedValidationRule',
            'ArrayOfVEEValidationRule' => '\\SGCIS\\Array\\ArrayOfVEEValidationRule',
            'VEEValidationRule' => '\\SGCIS\\Struct\\VEEValidationRule',
            'ArrayOfMeterReadRatingComponent' => '\\SGCIS\\Array\\ArrayOfMeterReadRatingComponent',
            'MeterReadRatingComponent' => '\\SGCIS\\Struct\\MeterReadRatingComponent',
            'ArrayOfMeterReadRatingComponentDetail' => '\\SGCIS\\Array\\ArrayOfMeterReadRatingComponentDetail',
            'MeterReadRatingComponentDetail' => '\\SGCIS\\Struct\\MeterReadRatingComponentDetail',
            'ArrayOfAccountAccountFlag' => '\\SGCIS\\Array\\ArrayOfAccountAccountFlag',
            'AccountAccountFlag' => '\\SGCIS\\Struct\\AccountAccountFlag',
            'AccountStatus' => '\\SGCIS\\Struct\\AccountStatus',
            'AccountType' => '\\SGCIS\\Struct\\AccountType',
            'Language' => '\\SGCIS\\Struct\\Language',
            'AccountTerminationReason' => '\\SGCIS\\Struct\\AccountTerminationReason',
            'ArrayOfProduct' => '\\SGCIS\\Array\\ArrayOfProduct',
            'SnapshotARReport' => '\\SGCIS\\Struct\\SnapshotARReport',
            'ArrayOfPerson' => '\\SGCIS\\Array\\ArrayOfPerson',
            'ArrayOfDistributionPoint' => '\\SGCIS\\Array\\ArrayOfDistributionPoint',
            'ArrayOfAccountNote' => '\\SGCIS\\Array\\ArrayOfAccountNote',
            'ArrayOfServicePoint' => '\\SGCIS\\Array\\ArrayOfServicePoint',
            'ArrayOfPaymentAccount' => '\\SGCIS\\Array\\ArrayOfPaymentAccount',
            'ArrayOfAccountTransaction' => '\\SGCIS\\Array\\ArrayOfAccountTransaction',
            'AccountTransaction' => '\\SGCIS\\Struct\\AccountTransaction',
            'ArrayOfPaymentArrangement' => '\\SGCIS\\Array\\ArrayOfPaymentArrangement',
            'ArrayOfServiceOrder' => '\\SGCIS\\Array\\ArrayOfServiceOrder',
            'ArrayOfAccountAutoPay' => '\\SGCIS\\Array\\ArrayOfAccountAutoPay',
            'ArrayOfAccountCommunication' => '\\SGCIS\\Array\\ArrayOfAccountCommunication',
            'AccountCommunication' => '\\SGCIS\\Struct\\AccountCommunication',
            'ArrayOfAttachedFile' => '\\SGCIS\\Array\\ArrayOfAttachedFile',
            'AttachedFile' => '\\SGCIS\\Struct\\AttachedFile',
            'Stream' => '\\SGCIS\\Struct\\Stream',
            'MarshalByRefObject' => '\\SGCIS\\Struct\\MarshalByRefObject',
            'ArrayOfAccountDocument' => '\\SGCIS\\Array\\ArrayOfAccountDocument',
            'AccountDocument' => '\\SGCIS\\Struct\\AccountDocument',
            'ArrayOfAccountStatusHistory' => '\\SGCIS\\Array\\ArrayOfAccountStatusHistory',
            'AccountStatusHistory' => '\\SGCIS\\Struct\\AccountStatusHistory',
            'ArrayOfAuditLog' => '\\SGCIS\\Array\\ArrayOfAuditLog',
            'AuditLog' => '\\SGCIS\\Struct\\AuditLog',
            'ArrayOfTransactionSummaryItem' => '\\SGCIS\\Array\\ArrayOfTransactionSummaryItem',
            'TransactionSummaryItem' => '\\SGCIS\\Struct\\TransactionSummaryItem',
            'AccountDepositOption' => '\\SGCIS\\Struct\\AccountDepositOption',
            'ArrayOfAccountDeposit' => '\\SGCIS\\Array\\ArrayOfAccountDeposit',
            'AccountDeposit' => '\\SGCIS\\Struct\\AccountDeposit',
            'ArrayOfAccountDepositSchedule' => '\\SGCIS\\Array\\ArrayOfAccountDepositSchedule',
            'ArrayOfAccountDepositTransaction' => '\\SGCIS\\Array\\ArrayOfAccountDepositTransaction',
            'ArrayOfBillHeader' => '\\SGCIS\\Array\\ArrayOfBillHeader',
            'BillHeader' => '\\SGCIS\\Struct\\BillHeader',
            'ArrayOfBillDeliveryMethod' => '\\SGCIS\\Array\\ArrayOfBillDeliveryMethod',
            'BillDeliveryMethod' => '\\SGCIS\\Struct\\BillDeliveryMethod',
            'ArrayOfAccountCustomField' => '\\SGCIS\\Array\\ArrayOfAccountCustomField',
            'AccountCustomField' => '\\SGCIS\\Struct\\AccountCustomField',
            'GetAccountShallowCopyResponse' => '\\SGCIS\\Struct\\GetAccountShallowCopyResponse',
            'AccountResponse' => '\\SGCIS\\Struct\\AccountResponse',
            'ServiceResponseBase' => '\\SGCIS\\Struct\\ServiceResponseBase',
            'AccountSummary' => '\\SGCIS\\Struct\\AccountSummary',
            'DailyBurnRate' => '\\SGCIS\\Struct\\DailyBurnRate',
            'GetUserAgentCodeByAgentID' => '\\SGCIS\\Struct\\GetUserAgentCodeByAgentID',
            'UserRequest' => '\\SGCIS\\Struct\\UserRequest',
            'User' => '\\SGCIS\\Struct\\User',
            'ArrayOfUserSystemRole' => '\\SGCIS\\Array\\ArrayOfUserSystemRole',
            'UserSystemRole' => '\\SGCIS\\Struct\\UserSystemRole',
            'ArrayOfSystemRoleApplication' => '\\SGCIS\\Array\\ArrayOfSystemRoleApplication',
            'SystemRoleApplication' => '\\SGCIS\\Struct\\SystemRoleApplication',
            'ArrayOfSystemRoleApplicationFunction' => '\\SGCIS\\Array\\ArrayOfSystemRoleApplicationFunction',
            'SystemRoleApplicationFunction' => '\\SGCIS\\Struct\\SystemRoleApplicationFunction',
            'ArrayOfSystemRoleApplicationExportFunction' => '\\SGCIS\\Array\\ArrayOfSystemRoleApplicationExportFunction',
            'SystemRoleApplicationExportFunction' => '\\SGCIS\\Struct\\SystemRoleApplicationExportFunction',
            'ArrayOfSystemRoleApplicationSearchEntityView' => '\\SGCIS\\Array\\ArrayOfSystemRoleApplicationSearchEntityView',
            'SystemRoleApplicationSearchEntityView' => '\\SGCIS\\Struct\\SystemRoleApplicationSearchEntityView',
            'ArrayOfSystemRoleApplicationWidget' => '\\SGCIS\\Array\\ArrayOfSystemRoleApplicationWidget',
            'SystemRoleApplicationWidget' => '\\SGCIS\\Struct\\SystemRoleApplicationWidget',
            'DashboardGalleryWidget' => '\\SGCIS\\Struct\\DashboardGalleryWidget',
            'ArrayOfSearchEntity' => '\\SGCIS\\Array\\ArrayOfSearchEntity',
            'SearchEntity' => '\\SGCIS\\Struct\\SearchEntity',
            'ArrayOfSearchEntityView' => '\\SGCIS\\Array\\ArrayOfSearchEntityView',
            'SearchEntityView' => '\\SGCIS\\Struct\\SearchEntityView',
            'ArrayOfSystemApplicationRoleProduct' => '\\SGCIS\\Array\\ArrayOfSystemApplicationRoleProduct',
            'SystemApplicationRoleProduct' => '\\SGCIS\\Struct\\SystemApplicationRoleProduct',
            'ArrayOfCommunity' => '\\SGCIS\\Array\\ArrayOfCommunity',
            'Community' => '\\SGCIS\\Struct\\Community',
            'ArrayOfUserCharacteristic' => '\\SGCIS\\Array\\ArrayOfUserCharacteristic',
            'UserCharacteristic' => '\\SGCIS\\Struct\\UserCharacteristic',
            'ArrayOfUserAgentCode' => '\\SGCIS\\Array\\ArrayOfUserAgentCode',
            'UserAgentCode' => '\\SGCIS\\Struct\\UserAgentCode',
            'GetUserAgentCodeByAgentIDResponse' => '\\SGCIS\\Struct\\GetUserAgentCodeByAgentIDResponse',
            'UserResponse' => '\\SGCIS\\Struct\\UserResponse',
            'ArrayOfUser' => '\\SGCIS\\Array\\ArrayOfUser',
            'SalesAgentCompany' => '\\SGCIS\\Struct\\SalesAgentCompany',
            'SaveAutoPayment' => '\\SGCIS\\Struct\\SaveAutoPayment',
            'AutoPaymentRequest' => '\\SGCIS\\Struct\\AutoPaymentRequest',
            'SaveAutoPaymentResponse' => '\\SGCIS\\Struct\\SaveAutoPaymentResponse',
            'AutoPaymentResponse' => '\\SGCIS\\Struct\\AutoPaymentResponse',
            'GetAccountDocuments' => '\\SGCIS\\Struct\\GetAccountDocuments',
            'GetAccountDocumentsResponse' => '\\SGCIS\\Struct\\GetAccountDocumentsResponse',
            'GetAccountDocumentTypes' => '\\SGCIS\\Struct\\GetAccountDocumentTypes',
            'AccountDocumentTypeRequest' => '\\SGCIS\\Struct\\AccountDocumentTypeRequest',
            'AccountDocumentType' => '\\SGCIS\\Struct\\AccountDocumentType',
            'GetAccountDocumentTypesResponse' => '\\SGCIS\\Struct\\GetAccountDocumentTypesResponse',
            'AccountDocumentTypeResponse' => '\\SGCIS\\Struct\\AccountDocumentTypeResponse',
            'ArrayOfAccountDocumentType' => '\\SGCIS\\Array\\ArrayOfAccountDocumentType',
            'GetAccountIVR' => '\\SGCIS\\Struct\\GetAccountIVR',
            'AccountLookupRequest' => '\\SGCIS\\Struct\\AccountLookupRequest',
            'ArrayOfString' => '\\SGCIS\\Array\\ArrayOfString',
            'GetAccountIVRResponse' => '\\SGCIS\\Struct\\GetAccountIVRResponse',
            'SimpleAccountLookupResponse' => '\\SGCIS\\Struct\\SimpleAccountLookupResponse',
            'ValidPhone' => '\\SGCIS\\Struct\\ValidPhone',
            'ValidPhoneResponse' => '\\SGCIS\\Struct\\ValidPhoneResponse',
            'AccountValidPhoneResponse' => '\\SGCIS\\Struct\\AccountValidPhoneResponse',
            'RegisterCustomerWith2FactorAuth' => '\\SGCIS\\Struct\\RegisterCustomerWith2FactorAuth',
            'RegisterRequest' => '\\SGCIS\\Struct\\RegisterRequest',
            'RegisterCustomerWith2FactorAuthResponse' => '\\SGCIS\\Struct\\RegisterCustomerWith2FactorAuthResponse',
            'RegisterResponse' => '\\SGCIS\\Struct\\RegisterResponse',
            'Claim2FactorAuthCustomerRegistration' => '\\SGCIS\\Struct\\Claim2FactorAuthCustomerRegistration',
            'Claim2FactorAuthCustomerRegistrationResponse' => '\\SGCIS\\Struct\\Claim2FactorAuthCustomerRegistrationResponse',
            'GetProductsByZipCode' => '\\SGCIS\\Struct\\GetProductsByZipCode',
            'RateLookupRequest' => '\\SGCIS\\Struct\\RateLookupRequest',
            'GetProductsByZipCodeResponse' => '\\SGCIS\\Struct\\GetProductsByZipCodeResponse',
            'RateLookupResponse' => '\\SGCIS\\Struct\\RateLookupResponse',
            'GetProducts' => '\\SGCIS\\Struct\\GetProducts',
            'GetProductsRequest' => '\\SGCIS\\Struct\\GetProductsRequest',
            'GetProductsResponse' => '\\SGCIS\\Struct\\GetProductsResponse',
            'ValidateEnrollmentLocations' => '\\SGCIS\\Struct\\ValidateEnrollmentLocations',
            'ValidateEnrollmentLocationsRequest' => '\\SGCIS\\Struct\\ValidateEnrollmentLocationsRequest',
            'ValidateEnrollmentLocationsResponse' => '\\SGCIS\\Struct\\ValidateEnrollmentLocationsResponse',
            'ValidateEnrollmentServiceLocationResponse' => '\\SGCIS\\Struct\\ValidateEnrollmentServiceLocationResponse',
            'ProcessAccountEnrollment' => '\\SGCIS\\Struct\\ProcessAccountEnrollment',
            'CreateAccountRequest' => '\\SGCIS\\Struct\\CreateAccountRequest',
            'ProcessAccountEnrollmentResponse' => '\\SGCIS\\Struct\\ProcessAccountEnrollmentResponse',
            'CreateAccountResponse' => '\\SGCIS\\Struct\\CreateAccountResponse',
            'GetDistributionPoints' => '\\SGCIS\\Struct\\GetDistributionPoints',
            'GetDistributionPointsRequest' => '\\SGCIS\\Struct\\GetDistributionPointsRequest',
            'GetDistributionPointsResponse' => '\\SGCIS\\Struct\\GetDistributionPointsResponse',
            'GetAccountActivityMobile' => '\\SGCIS\\Struct\\GetAccountActivityMobile',
            'AccountActivityRequest' => '\\SGCIS\\Struct\\AccountActivityRequest',
            'GetAccountActivityMobileResponse' => '\\SGCIS\\Struct\\GetAccountActivityMobileResponse',
            'AccountActivityResponse' => '\\SGCIS\\Struct\\AccountActivityResponse',
            'ArrayOfZipCodeWeather' => '\\SGCIS\\Array\\ArrayOfZipCodeWeather',
            'ZipCodeWeather' => '\\SGCIS\\Struct\\ZipCodeWeather',
            'ArrayOfAccountSummaryTransaction' => '\\SGCIS\\Array\\ArrayOfAccountSummaryTransaction',
            'AccountSummaryTransaction' => '\\SGCIS\\Struct\\AccountSummaryTransaction',
            'AccountTransactionSummary' => '\\SGCIS\\Struct\\AccountTransactionSummary',
            'ArrayOfActivityDetailItem' => '\\SGCIS\\Array\\ArrayOfActivityDetailItem',
            'ActivityDetailItem' => '\\SGCIS\\Struct\\ActivityDetailItem',
            'GetAutoPayMetaData' => '\\SGCIS\\Struct\\GetAutoPayMetaData',
            'AutoPayMetaDataRequest' => '\\SGCIS\\Struct\\AutoPayMetaDataRequest',
            'GetAutoPayMetaDataResponse' => '\\SGCIS\\Struct\\GetAutoPayMetaDataResponse',
            'AutoPayMetaDataResponse' => '\\SGCIS\\Struct\\AutoPayMetaDataResponse',
            'ArrayOfPaymentTenderType' => '\\SGCIS\\Array\\ArrayOfPaymentTenderType',
            'PaymentTenderType' => '\\SGCIS\\Struct\\PaymentTenderType',
            'ArrayOfSystemEvent' => '\\SGCIS\\Array\\ArrayOfSystemEvent',
            'SystemEvent' => '\\SGCIS\\Struct\\SystemEvent',
            'ConnectSoftArmedMeter' => '\\SGCIS\\Struct\\ConnectSoftArmedMeter',
            'MeterRequest' => '\\SGCIS\\Struct\\MeterRequest',
            'MeterQuery' => '\\SGCIS\\Struct\\MeterQuery',
            'MeterGroup' => '\\SGCIS\\Struct\\MeterGroup',
            'ConnectSoftArmedMeterResponse' => '\\SGCIS\\Struct\\ConnectSoftArmedMeterResponse',
            'MeterResponse' => '\\SGCIS\\Struct\\MeterResponse',
            'dsMeters' => '\\SGCIS\\Struct\\DsMeters',
            'ArrayOfMeterCopy' => '\\SGCIS\\Array\\ArrayOfMeterCopy',
            'MeterCopy' => '\\SGCIS\\Struct\\MeterCopy',
            'ArrayOfMeterGroup' => '\\SGCIS\\Array\\ArrayOfMeterGroup',
            'ArrayOfHistoricalConsumptionUsageReport' => '\\SGCIS\\Array\\ArrayOfHistoricalConsumptionUsageReport',
            'HistoricalConsumptionUsageReport' => '\\SGCIS\\Struct\\HistoricalConsumptionUsageReport',
            'GetProductDeepCopy' => '\\SGCIS\\Struct\\GetProductDeepCopy',
            'ProductRequest' => '\\SGCIS\\Struct\\ProductRequest',
            'LineOfBusiness' => '\\SGCIS\\Struct\\LineOfBusiness',
            'ProductFamily' => '\\SGCIS\\Struct\\ProductFamily',
            'GetProductDeepCopyResponse' => '\\SGCIS\\Struct\\GetProductDeepCopyResponse',
            'ProductResponse' => '\\SGCIS\\Struct\\ProductResponse',
            'ArrayOfLineOfBusiness' => '\\SGCIS\\Array\\ArrayOfLineOfBusiness',
            'ArrayOfProductFamily' => '\\SGCIS\\Array\\ArrayOfProductFamily',
            'ArrayOfAccountType' => '\\SGCIS\\Array\\ArrayOfAccountType',
            'AuthenticateUser' => '\\SGCIS\\Struct\\AuthenticateUser',
            'AutheticateUserRequest' => '\\SGCIS\\Struct\\AutheticateUserRequest',
            'AuthenticateUserResponse' => '\\SGCIS\\Struct\\AuthenticateUserResponse',
            'AutheticateUserResponse' => '\\SGCIS\\Struct\\AutheticateUserResponse',
            'ArrayOfAccount' => '\\SGCIS\\Array\\ArrayOfAccount',
            'ChangePassword' => '\\SGCIS\\Struct\\ChangePassword',
            'ChangeUserPasswordRequest' => '\\SGCIS\\Struct\\ChangeUserPasswordRequest',
            'ChangePasswordResponse' => '\\SGCIS\\Struct\\ChangePasswordResponse',
            'ChangeUserPasswordResponse' => '\\SGCIS\\Struct\\ChangeUserPasswordResponse',
            'Register' => '\\SGCIS\\Struct\\Register',
            'UpdateAccountProfile' => '\\SGCIS\\Struct\\UpdateAccountProfile',
            'UpdateProfileRequest' => '\\SGCIS\\Struct\\UpdateProfileRequest',
            'UpdateAccountProfileResponse' => '\\SGCIS\\Struct\\UpdateAccountProfileResponse',
            'UpdateProfileResponse' => '\\SGCIS\\Struct\\UpdateProfileResponse',
            'GetPaymentLocations' => '\\SGCIS\\Struct\\GetPaymentLocations',
            'PaymentLocationRequest' => '\\SGCIS\\Struct\\PaymentLocationRequest',
            'PaymentLocationQuery' => '\\SGCIS\\Struct\\PaymentLocationQuery',
            'Point' => '\\SGCIS\\Struct\\Point',
            'GetPaymentLocationsResponse' => '\\SGCIS\\Struct\\GetPaymentLocationsResponse',
            'PaymentLocationResponse' => '\\SGCIS\\Struct\\PaymentLocationResponse',
            'ArrayOfPaymentLocation' => '\\SGCIS\\Array\\ArrayOfPaymentLocation',
            'PaymentLocation' => '\\SGCIS\\Struct\\PaymentLocation',
            'BaseDAO' => '\\SGCIS\\Struct\\BaseDAO',
            'DeletePaymentAccount' => '\\SGCIS\\Struct\\DeletePaymentAccount',
            'PaymentAccountRequest' => '\\SGCIS\\Struct\\PaymentAccountRequest',
            'DeletePaymentAccountResponse' => '\\SGCIS\\Struct\\DeletePaymentAccountResponse',
            'PaymentAccountResponse' => '\\SGCIS\\Struct\\PaymentAccountResponse',
            'PersonIDType' => '\\SGCIS\\Struct\\PersonIDType',
            'SavePaymentAccount' => '\\SGCIS\\Struct\\SavePaymentAccount',
            'SavePaymentAccountResponse' => '\\SGCIS\\Struct\\SavePaymentAccountResponse',
            'SendPassword' => '\\SGCIS\\Struct\\SendPassword',
            'SendPasswordRequest' => '\\SGCIS\\Struct\\SendPasswordRequest',
            'SendPasswordResponse' => '\\SGCIS\\Struct\\SendPasswordResponse',
            'UpdateAccountCommunicationViewStatus' => '\\SGCIS\\Struct\\UpdateAccountCommunicationViewStatus',
            'UpdateAccountCommunicationViewStatusResponse' => '\\SGCIS\\Struct\\UpdateAccountCommunicationViewStatusResponse',
            'GetAccountActivity' => '\\SGCIS\\Struct\\GetAccountActivity',
            'GetAccountActivityResponse' => '\\SGCIS\\Struct\\GetAccountActivityResponse',
            'GetAccount' => '\\SGCIS\\Struct\\GetAccount',
            'GetAccountResponse' => '\\SGCIS\\Struct\\GetAccountResponse',
            'AccountLookupResponse' => '\\SGCIS\\Struct\\AccountLookupResponse',
            'ArrayOfAccountSummary' => '\\SGCIS\\Array\\ArrayOfAccountSummary',
            'ArrayOfAccountPrevious' => '\\SGCIS\\Array\\ArrayOfAccountPrevious',
            'AccountPrevious' => '\\SGCIS\\Struct\\AccountPrevious',
            'GetUspAccount' => '\\SGCIS\\Struct\\GetUspAccount',
            'GetUspAccountResponse' => '\\SGCIS\\Struct\\GetUspAccountResponse',
            'GetFees' => '\\SGCIS\\Struct\\GetFees',
            'GetFeesRequest' => '\\SGCIS\\Struct\\GetFeesRequest',
            'GetFeesResponse' => '\\SGCIS\\Struct\\GetFeesResponse',
            'ArrayOfAccountFee' => '\\SGCIS\\Array\\ArrayOfAccountFee',
            'AccountFee' => '\\SGCIS\\Struct\\AccountFee',
            'ArrayOfFeeEvent' => '\\SGCIS\\Array\\ArrayOfFeeEvent',
            'FeeEvent' => '\\SGCIS\\Struct\\FeeEvent',
            'GetPaymentArrangements' => '\\SGCIS\\Struct\\GetPaymentArrangements',
            'PaymentArrangementRequest' => '\\SGCIS\\Struct\\PaymentArrangementRequest',
            'GetPaymentArrangementsResponse' => '\\SGCIS\\Struct\\GetPaymentArrangementsResponse',
            'PaymentArrangementResponse' => '\\SGCIS\\Struct\\PaymentArrangementResponse',
            'GetPaymentArrangement' => '\\SGCIS\\Struct\\GetPaymentArrangement',
            'GetPaymentArrangementResponse' => '\\SGCIS\\Struct\\GetPaymentArrangementResponse',
            'CreateNewPaymentArrangement' => '\\SGCIS\\Struct\\CreateNewPaymentArrangement',
            'CreateNewPaymentArrangementResponse' => '\\SGCIS\\Struct\\CreateNewPaymentArrangementResponse',
            'GetPaymentAccounts' => '\\SGCIS\\Struct\\GetPaymentAccounts',
            'GetPaymentAccountsResponse' => '\\SGCIS\\Struct\\GetPaymentAccountsResponse',
            'GetAccountAutopayment' => '\\SGCIS\\Struct\\GetAccountAutopayment',
            'GetAccountAutopaymentResponse' => '\\SGCIS\\Struct\\GetAccountAutopaymentResponse',
            'PostUspPayment' => '\\SGCIS\\Struct\\PostUspPayment',
            'PostPaymentRequest' => '\\SGCIS\\Struct\\PostPaymentRequest',
            'PaymentVendorProcess' => '\\SGCIS\\Struct\\PaymentVendorProcess',
            'PostUspPaymentResponse' => '\\SGCIS\\Struct\\PostUspPaymentResponse',
            'PostPaymentResponse' => '\\SGCIS\\Struct\\PostPaymentResponse',
            'PaymentEvent' => '\\SGCIS\\Struct\\PaymentEvent',
            'PaymentTender' => '\\SGCIS\\Struct\\PaymentTender',
            'PostAccountPayment' => '\\SGCIS\\Struct\\PostAccountPayment',
            'PostAccountPaymentResponse' => '\\SGCIS\\Struct\\PostAccountPaymentResponse',
            'ProcessAccountPayLater' => '\\SGCIS\\Struct\\ProcessAccountPayLater',
            'ProcessAccountPayLaterResponse' => '\\SGCIS\\Struct\\ProcessAccountPayLaterResponse',
            'GetDataLists' => '\\SGCIS\\Struct\\GetDataLists',
            'DataListRequest' => '\\SGCIS\\Struct\\DataListRequest',
            'GetDataListsResponse' => '\\SGCIS\\Struct\\GetDataListsResponse',
            'DataListResponse' => '\\SGCIS\\Struct\\DataListResponse',
            'ArrayOfDataListCacheItem' => '\\SGCIS\\Array\\ArrayOfDataListCacheItem',
            'DataListCacheItem' => '\\SGCIS\\Struct\\DataListCacheItem',
            'ArrayOfNameValuePair' => '\\SGCIS\\Array\\ArrayOfNameValuePair',
            'NameValuePair' => '\\SGCIS\\Struct\\NameValuePair',
            'GetDataList' => '\\SGCIS\\Struct\\GetDataList',
            'GetDataListResponse' => '\\SGCIS\\Struct\\GetDataListResponse',
            'GetSystemProperty' => '\\SGCIS\\Struct\\GetSystemProperty',
            'SystemPropertyRequest' => '\\SGCIS\\Struct\\SystemPropertyRequest',
            'SystemProperty' => '\\SGCIS\\Struct\\SystemProperty',
            'ArrayOfSystemProperty' => '\\SGCIS\\Array\\ArrayOfSystemProperty',
            'GetSystemPropertyResponse' => '\\SGCIS\\Struct\\GetSystemPropertyResponse',
            'SystemPropertyResponse' => '\\SGCIS\\Struct\\SystemPropertyResponse',
            'GetCurrentBill' => '\\SGCIS\\Struct\\GetCurrentBill',
            'BillingRequest' => '\\SGCIS\\Struct\\BillingRequest',
            'ArrayOfBillChargeDisplayItem' => '\\SGCIS\\Array\\ArrayOfBillChargeDisplayItem',
            'BillChargeDisplayItem' => '\\SGCIS\\Struct\\BillChargeDisplayItem',
            'Bill' => '\\SGCIS\\Struct\\Bill',
            'ArrayOfBillServicePoint' => '\\SGCIS\\Array\\ArrayOfBillServicePoint',
            'BillServicePoint' => '\\SGCIS\\Struct\\BillServicePoint',
            'ArrayOfBillServicePointCharge' => '\\SGCIS\\Array\\ArrayOfBillServicePointCharge',
            'BillServicePointCharge' => '\\SGCIS\\Struct\\BillServicePointCharge',
            'ArrayOfBillServicePointChargeDetail' => '\\SGCIS\\Array\\ArrayOfBillServicePointChargeDetail',
            'BillServicePointChargeDetail' => '\\SGCIS\\Struct\\BillServicePointChargeDetail',
            'ArrayOfCCHGroupTax' => '\\SGCIS\\Array\\ArrayOfCCHGroupTax',
            'CCHGroupTax' => '\\SGCIS\\Struct\\CCHGroupTax',
            'ArrayOfCCHGroupTaxDetail' => '\\SGCIS\\Array\\ArrayOfCCHGroupTaxDetail',
            'CCHGroupTaxDetail' => '\\SGCIS\\Struct\\CCHGroupTaxDetail',
            'ArrayOfBillServicePointChargeCharge' => '\\SGCIS\\Array\\ArrayOfBillServicePointChargeCharge',
            'BillServicePointChargeCharge' => '\\SGCIS\\Struct\\BillServicePointChargeCharge',
            'ArrayOfBillServicePointMeteredUsage' => '\\SGCIS\\Array\\ArrayOfBillServicePointMeteredUsage',
            'BillServicePointMeteredUsage' => '\\SGCIS\\Struct\\BillServicePointMeteredUsage',
            'ArrayOfBillServicePointBillingException' => '\\SGCIS\\Array\\ArrayOfBillServicePointBillingException',
            'BillServicePointBillingException' => '\\SGCIS\\Struct\\BillServicePointBillingException',
            'ArrayOfRate' => '\\SGCIS\\Array\\ArrayOfRate',
            'ArrayOfBillServicePointContractDetail' => '\\SGCIS\\Array\\ArrayOfBillServicePointContractDetail',
            'BillServicePointContractDetail' => '\\SGCIS\\Struct\\BillServicePointContractDetail',
            'ArrayOfBillUserNote' => '\\SGCIS\\Array\\ArrayOfBillUserNote',
            'BillUserNote' => '\\SGCIS\\Struct\\BillUserNote',
            'ArrayOfBillStatusHistory' => '\\SGCIS\\Array\\ArrayOfBillStatusHistory',
            'BillStatusHistory' => '\\SGCIS\\Struct\\BillStatusHistory',
            'ArrayOfBillPaymentAdjustment' => '\\SGCIS\\Array\\ArrayOfBillPaymentAdjustment',
            'BillPaymentAdjustment' => '\\SGCIS\\Struct\\BillPaymentAdjustment',
            'ArrayOfBillPaymentAdjustmentDetail' => '\\SGCIS\\Array\\ArrayOfBillPaymentAdjustmentDetail',
            'BillPaymentAdjustmentDetail' => '\\SGCIS\\Struct\\BillPaymentAdjustmentDetail',
            'BillLevelizedBillSummary' => '\\SGCIS\\Struct\\BillLevelizedBillSummary',
            'ArrayOfBudgetBillMonthlyAmount' => '\\SGCIS\\Array\\ArrayOfBudgetBillMonthlyAmount',
            'BudgetBillMonthlyAmount' => '\\SGCIS\\Struct\\BudgetBillMonthlyAmount',
            'ArrayOfBill' => '\\SGCIS\\Array\\ArrayOfBill',
            'BillApprovalQueryParameters' => '\\SGCIS\\Struct\\BillApprovalQueryParameters',
            'TransactionsNotImportedQueryParameters' => '\\SGCIS\\Struct\\TransactionsNotImportedQueryParameters',
            'GetCurrentBillResponse' => '\\SGCIS\\Struct\\GetCurrentBillResponse',
            'BillingResponse' => '\\SGCIS\\Struct\\BillingResponse',
            'ArrayOfEDIBill' => '\\SGCIS\\Array\\ArrayOfEDIBill',
            'EDIBill' => '\\SGCIS\\Struct\\EDIBill',
            'ArrayOfBillStatusCount' => '\\SGCIS\\Array\\ArrayOfBillStatusCount',
            'BillStatusCount' => '\\SGCIS\\Struct\\BillStatusCount',
            'ArrayOfBillConvertedHeader' => '\\SGCIS\\Array\\ArrayOfBillConvertedHeader',
            'BillConvertedHeader' => '\\SGCIS\\Struct\\BillConvertedHeader',
            'ArrayOfTransactionAssociateAccount' => '\\SGCIS\\Array\\ArrayOfTransactionAssociateAccount',
            'TransactionAssociateAccount' => '\\SGCIS\\Struct\\TransactionAssociateAccount',
            'ArrayOfTransactionNotImported' => '\\SGCIS\\Array\\ArrayOfTransactionNotImported',
            'TransactionNotImported' => '\\SGCIS\\Struct\\TransactionNotImported',
            'CurrentBill' => '\\SGCIS\\Struct\\CurrentBill',
            'ArrayOfBillBalance' => '\\SGCIS\\Array\\ArrayOfBillBalance',
            'BillBalance' => '\\SGCIS\\Struct\\BillBalance',
            'GetBillHistory' => '\\SGCIS\\Struct\\GetBillHistory',
            'GetBillHistoryResponse' => '\\SGCIS\\Struct\\GetBillHistoryResponse',
            'ProcessAccountTransferServiceLocation' => '\\SGCIS\\Struct\\ProcessAccountTransferServiceLocation',
            'TransferServiceLocationRequest' => '\\SGCIS\\Struct\\TransferServiceLocationRequest',
            'ProcessAccountTransferServiceLocationResponse' => '\\SGCIS\\Struct\\ProcessAccountTransferServiceLocationResponse',
            'FindServiceLocations' => '\\SGCIS\\Struct\\FindServiceLocations',
            'ServiceLocationSearchRequest' => '\\SGCIS\\Struct\\ServiceLocationSearchRequest',
            'ArrayOfServiceLocationSearch' => '\\SGCIS\\Array\\ArrayOfServiceLocationSearch',
            'ServiceLocationSearch' => '\\SGCIS\\Struct\\ServiceLocationSearch',
            'FindServiceLocationsResponse' => '\\SGCIS\\Struct\\FindServiceLocationsResponse',
            'ServiceLocationSearchResponse' => '\\SGCIS\\Struct\\ServiceLocationSearchResponse',
            'CaptureLead' => '\\SGCIS\\Struct\\CaptureLead',
            'SalesForceLeadRequest' => '\\SGCIS\\Struct\\SalesForceLeadRequest',
            'SalesForceLead' => '\\SGCIS\\Struct\\SalesForceLead',
            'CaptureLeadResponse' => '\\SGCIS\\Struct\\CaptureLeadResponse',
            'SalesForceLeadResponse' => '\\SGCIS\\Struct\\SalesForceLeadResponse',
            'GetWebProducts' => '\\SGCIS\\Struct\\GetWebProducts',
            'ProductLookupRequest' => '\\SGCIS\\Struct\\ProductLookupRequest',
            'GetWebProductsResponse' => '\\SGCIS\\Struct\\GetWebProductsResponse',
            'ProductLookupResponse' => '\\SGCIS\\Struct\\ProductLookupResponse',
            'ArrayOfWebProduct' => '\\SGCIS\\Array\\ArrayOfWebProduct',
            'WebProduct' => '\\SGCIS\\Struct\\WebProduct',
            'GetAccountTransactionSummary' => '\\SGCIS\\Struct\\GetAccountTransactionSummary',
            'GetAccountTransactionSummaryResponse' => '\\SGCIS\\Struct\\GetAccountTransactionSummaryResponse',
            'GetCustomFields' => '\\SGCIS\\Struct\\GetCustomFields',
            'CustomFieldRequest' => '\\SGCIS\\Struct\\CustomFieldRequest',
            'CustomField' => '\\SGCIS\\Struct\\CustomField',
            'GetCustomFieldsResponse' => '\\SGCIS\\Struct\\GetCustomFieldsResponse',
            'CustomFieldResponse' => '\\SGCIS\\Struct\\CustomFieldResponse',
            'ArrayOfCustomField' => '\\SGCIS\\Array\\ArrayOfCustomField',
            'GetAccountCustomFields' => '\\SGCIS\\Struct\\GetAccountCustomFields',
            'AccountCustomFieldRequest' => '\\SGCIS\\Struct\\AccountCustomFieldRequest',
            'GetAccountCustomFieldsResponse' => '\\SGCIS\\Struct\\GetAccountCustomFieldsResponse',
            'AccountCustomFieldResponse' => '\\SGCIS\\Struct\\AccountCustomFieldResponse',
            'SaveAccountCustomFields' => '\\SGCIS\\Struct\\SaveAccountCustomFields',
            'SaveAccountCustomFieldsResponse' => '\\SGCIS\\Struct\\SaveAccountCustomFieldsResponse',
            'GetUserCharacteristics' => '\\SGCIS\\Struct\\GetUserCharacteristics',
            'UserCharacteristicRequest' => '\\SGCIS\\Struct\\UserCharacteristicRequest',
            'GetUserCharacteristicsResponse' => '\\SGCIS\\Struct\\GetUserCharacteristicsResponse',
            'UserCharacteristicResponse' => '\\SGCIS\\Struct\\UserCharacteristicResponse',
            'GetZipCodeWeather' => '\\SGCIS\\Struct\\GetZipCodeWeather',
            'ZipCodeWeatherRequest' => '\\SGCIS\\Struct\\ZipCodeWeatherRequest',
            'GetZipCodeWeatherResponse' => '\\SGCIS\\Struct\\GetZipCodeWeatherResponse',
            'ZipCodeWeatherResponse' => '\\SGCIS\\Struct\\ZipCodeWeatherResponse',
            'ExternalAuthenticateUser' => '\\SGCIS\\Struct\\ExternalAuthenticateUser',
            'ExternalAuthenticateUserResponse' => '\\SGCIS\\Struct\\ExternalAuthenticateUserResponse',
            'AuthenticateAppUserResponse' => '\\SGCIS\\Struct\\AuthenticateAppUserResponse',
            'ExternalRecoverPassword' => '\\SGCIS\\Struct\\ExternalRecoverPassword',
            'ExternalRecoverPasswordResponse' => '\\SGCIS\\Struct\\ExternalRecoverPasswordResponse',
        );
    }
}
