<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfZipCodeWeather Array
 * @subpackage Arrays
 */
class ArrayOfZipCodeWeather extends AbstractStructArrayBase
{
    /**
     * The ZipCodeWeather
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ZipCodeWeather[]
     */
    public $ZipCodeWeather;
    /**
     * Constructor method for ArrayOfZipCodeWeather
     * @uses ArrayOfZipCodeWeather::setZipCodeWeather()
     * @param \SGCIS\Struct\ZipCodeWeather[] $zipCodeWeather
     */
    public function __construct(array $zipCodeWeather = array())
    {
        $this
            ->setZipCodeWeather($zipCodeWeather);
    }
    /**
     * Get ZipCodeWeather value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ZipCodeWeather[]|null
     */
    public function getZipCodeWeather()
    {
        return isset($this->ZipCodeWeather) ? $this->ZipCodeWeather : null;
    }
    /**
     * Set ZipCodeWeather value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ZipCodeWeather[] $zipCodeWeather
     * @return \SGCIS\Array\ArrayOfZipCodeWeather
     */
    public function setZipCodeWeather(array $zipCodeWeather = array())
    {
        foreach ($zipCodeWeather as $arrayOfZipCodeWeatherZipCodeWeatherItem) {
            // validation for constraint: itemType
            if (!$arrayOfZipCodeWeatherZipCodeWeatherItem instanceof \SGCIS\Struct\ZipCodeWeather) {
                throw new \InvalidArgumentException(sprintf('The ZipCodeWeather property can only contain items of \SGCIS\Struct\ZipCodeWeather, "%s" given', is_object($arrayOfZipCodeWeatherZipCodeWeatherItem) ? get_class($arrayOfZipCodeWeatherZipCodeWeatherItem) : gettype($arrayOfZipCodeWeatherZipCodeWeatherItem)), __LINE__);
            }
        }
        if (is_null($zipCodeWeather) || (is_array($zipCodeWeather) && empty($zipCodeWeather))) {
            unset($this->ZipCodeWeather);
        } else {
            $this->ZipCodeWeather = $zipCodeWeather;
        }
        return $this;
    }
    /**
     * Add item to ZipCodeWeather value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ZipCodeWeather $item
     * @return \SGCIS\Array\ArrayOfZipCodeWeather
     */
    public function addToZipCodeWeather(\SGCIS\Struct\ZipCodeWeather $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ZipCodeWeather) {
            throw new \InvalidArgumentException(sprintf('The ZipCodeWeather property can only contain items of \SGCIS\Struct\ZipCodeWeather, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ZipCodeWeather[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ZipCodeWeather|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ZipCodeWeather|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ZipCodeWeather|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ZipCodeWeather|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ZipCodeWeather|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ZipCodeWeather
     */
    public function getAttributeName()
    {
        return 'ZipCodeWeather';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfZipCodeWeather
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
