<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUserCharacteristic Array
 * @subpackage Arrays
 */
class ArrayOfUserCharacteristic extends AbstractStructArrayBase
{
    /**
     * The UserCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\UserCharacteristic[]
     */
    public $UserCharacteristic;
    /**
     * Constructor method for ArrayOfUserCharacteristic
     * @uses ArrayOfUserCharacteristic::setUserCharacteristic()
     * @param \SGCIS\Struct\UserCharacteristic[] $userCharacteristic
     */
    public function __construct(array $userCharacteristic = array())
    {
        $this
            ->setUserCharacteristic($userCharacteristic);
    }
    /**
     * Get UserCharacteristic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\UserCharacteristic[]|null
     */
    public function getUserCharacteristic()
    {
        return isset($this->UserCharacteristic) ? $this->UserCharacteristic : null;
    }
    /**
     * Set UserCharacteristic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\UserCharacteristic[] $userCharacteristic
     * @return \SGCIS\Array\ArrayOfUserCharacteristic
     */
    public function setUserCharacteristic(array $userCharacteristic = array())
    {
        foreach ($userCharacteristic as $arrayOfUserCharacteristicUserCharacteristicItem) {
            // validation for constraint: itemType
            if (!$arrayOfUserCharacteristicUserCharacteristicItem instanceof \SGCIS\Struct\UserCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The UserCharacteristic property can only contain items of \SGCIS\Struct\UserCharacteristic, "%s" given', is_object($arrayOfUserCharacteristicUserCharacteristicItem) ? get_class($arrayOfUserCharacteristicUserCharacteristicItem) : gettype($arrayOfUserCharacteristicUserCharacteristicItem)), __LINE__);
            }
        }
        if (is_null($userCharacteristic) || (is_array($userCharacteristic) && empty($userCharacteristic))) {
            unset($this->UserCharacteristic);
        } else {
            $this->UserCharacteristic = $userCharacteristic;
        }
        return $this;
    }
    /**
     * Add item to UserCharacteristic value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\UserCharacteristic $item
     * @return \SGCIS\Array\ArrayOfUserCharacteristic
     */
    public function addToUserCharacteristic(\SGCIS\Struct\UserCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\UserCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The UserCharacteristic property can only contain items of \SGCIS\Struct\UserCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserCharacteristic[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\UserCharacteristic|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\UserCharacteristic|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\UserCharacteristic|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\UserCharacteristic|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\UserCharacteristic|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UserCharacteristic
     */
    public function getAttributeName()
    {
        return 'UserCharacteristic';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfUserCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
