<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUser Array
 * @subpackage Arrays
 */
class ArrayOfUser extends AbstractStructArrayBase
{
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\User[]
     */
    public $User;
    /**
     * Constructor method for ArrayOfUser
     * @uses ArrayOfUser::setUser()
     * @param \SGCIS\Struct\User[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\User[]|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\User[] $user
     * @return \SGCIS\Array\ArrayOfUser
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $arrayOfUserUserItem) {
            // validation for constraint: itemType
            if (!$arrayOfUserUserItem instanceof \SGCIS\Struct\User) {
                throw new \InvalidArgumentException(sprintf('The User property can only contain items of \SGCIS\Struct\User, "%s" given', is_object($arrayOfUserUserItem) ? get_class($arrayOfUserUserItem) : gettype($arrayOfUserUserItem)), __LINE__);
            }
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Add item to User value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\User $item
     * @return \SGCIS\Array\ArrayOfUser
     */
    public function addToUser(\SGCIS\Struct\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\User) {
            throw new \InvalidArgumentException(sprintf('The User property can only contain items of \SGCIS\Struct\User, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->User[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\User|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\User|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\User|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\User|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\User|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string User
     */
    public function getAttributeName()
    {
        return 'User';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
