<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUsageChargeTier Array
 * @subpackage Arrays
 */
class ArrayOfUsageChargeTier extends AbstractStructArrayBase
{
    /**
     * The UsageChargeTier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\UsageChargeTier[]
     */
    public $UsageChargeTier;
    /**
     * Constructor method for ArrayOfUsageChargeTier
     * @uses ArrayOfUsageChargeTier::setUsageChargeTier()
     * @param \SGCIS\Struct\UsageChargeTier[] $usageChargeTier
     */
    public function __construct(array $usageChargeTier = array())
    {
        $this
            ->setUsageChargeTier($usageChargeTier);
    }
    /**
     * Get UsageChargeTier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\UsageChargeTier[]|null
     */
    public function getUsageChargeTier()
    {
        return isset($this->UsageChargeTier) ? $this->UsageChargeTier : null;
    }
    /**
     * Set UsageChargeTier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\UsageChargeTier[] $usageChargeTier
     * @return \SGCIS\Array\ArrayOfUsageChargeTier
     */
    public function setUsageChargeTier(array $usageChargeTier = array())
    {
        foreach ($usageChargeTier as $arrayOfUsageChargeTierUsageChargeTierItem) {
            // validation for constraint: itemType
            if (!$arrayOfUsageChargeTierUsageChargeTierItem instanceof \SGCIS\Struct\UsageChargeTier) {
                throw new \InvalidArgumentException(sprintf('The UsageChargeTier property can only contain items of \SGCIS\Struct\UsageChargeTier, "%s" given', is_object($arrayOfUsageChargeTierUsageChargeTierItem) ? get_class($arrayOfUsageChargeTierUsageChargeTierItem) : gettype($arrayOfUsageChargeTierUsageChargeTierItem)), __LINE__);
            }
        }
        if (is_null($usageChargeTier) || (is_array($usageChargeTier) && empty($usageChargeTier))) {
            unset($this->UsageChargeTier);
        } else {
            $this->UsageChargeTier = $usageChargeTier;
        }
        return $this;
    }
    /**
     * Add item to UsageChargeTier value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\UsageChargeTier $item
     * @return \SGCIS\Array\ArrayOfUsageChargeTier
     */
    public function addToUsageChargeTier(\SGCIS\Struct\UsageChargeTier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\UsageChargeTier) {
            throw new \InvalidArgumentException(sprintf('The UsageChargeTier property can only contain items of \SGCIS\Struct\UsageChargeTier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UsageChargeTier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\UsageChargeTier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\UsageChargeTier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\UsageChargeTier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\UsageChargeTier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\UsageChargeTier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UsageChargeTier
     */
    public function getAttributeName()
    {
        return 'UsageChargeTier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfUsageChargeTier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
