<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransactionSummaryItem Array
 * @subpackage Arrays
 */
class ArrayOfTransactionSummaryItem extends AbstractStructArrayBase
{
    /**
     * The TransactionSummaryItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\TransactionSummaryItem[]
     */
    public $TransactionSummaryItem;
    /**
     * Constructor method for ArrayOfTransactionSummaryItem
     * @uses ArrayOfTransactionSummaryItem::setTransactionSummaryItem()
     * @param \SGCIS\Struct\TransactionSummaryItem[] $transactionSummaryItem
     */
    public function __construct(array $transactionSummaryItem = array())
    {
        $this
            ->setTransactionSummaryItem($transactionSummaryItem);
    }
    /**
     * Get TransactionSummaryItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\TransactionSummaryItem[]|null
     */
    public function getTransactionSummaryItem()
    {
        return isset($this->TransactionSummaryItem) ? $this->TransactionSummaryItem : null;
    }
    /**
     * Set TransactionSummaryItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TransactionSummaryItem[] $transactionSummaryItem
     * @return \SGCIS\Array\ArrayOfTransactionSummaryItem
     */
    public function setTransactionSummaryItem(array $transactionSummaryItem = array())
    {
        foreach ($transactionSummaryItem as $arrayOfTransactionSummaryItemTransactionSummaryItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransactionSummaryItemTransactionSummaryItemItem instanceof \SGCIS\Struct\TransactionSummaryItem) {
                throw new \InvalidArgumentException(sprintf('The TransactionSummaryItem property can only contain items of \SGCIS\Struct\TransactionSummaryItem, "%s" given', is_object($arrayOfTransactionSummaryItemTransactionSummaryItemItem) ? get_class($arrayOfTransactionSummaryItemTransactionSummaryItemItem) : gettype($arrayOfTransactionSummaryItemTransactionSummaryItemItem)), __LINE__);
            }
        }
        if (is_null($transactionSummaryItem) || (is_array($transactionSummaryItem) && empty($transactionSummaryItem))) {
            unset($this->TransactionSummaryItem);
        } else {
            $this->TransactionSummaryItem = $transactionSummaryItem;
        }
        return $this;
    }
    /**
     * Add item to TransactionSummaryItem value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TransactionSummaryItem $item
     * @return \SGCIS\Array\ArrayOfTransactionSummaryItem
     */
    public function addToTransactionSummaryItem(\SGCIS\Struct\TransactionSummaryItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\TransactionSummaryItem) {
            throw new \InvalidArgumentException(sprintf('The TransactionSummaryItem property can only contain items of \SGCIS\Struct\TransactionSummaryItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransactionSummaryItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\TransactionSummaryItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\TransactionSummaryItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\TransactionSummaryItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\TransactionSummaryItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\TransactionSummaryItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransactionSummaryItem
     */
    public function getAttributeName()
    {
        return 'TransactionSummaryItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfTransactionSummaryItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
