<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTicketField Array
 * @subpackage Arrays
 */
class ArrayOfTicketField extends AbstractStructArrayBase
{
    /**
     * The TicketField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\TicketField[]
     */
    public $TicketField;
    /**
     * Constructor method for ArrayOfTicketField
     * @uses ArrayOfTicketField::setTicketField()
     * @param \SGCIS\Struct\TicketField[] $ticketField
     */
    public function __construct(array $ticketField = array())
    {
        $this
            ->setTicketField($ticketField);
    }
    /**
     * Get TicketField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\TicketField[]|null
     */
    public function getTicketField()
    {
        return isset($this->TicketField) ? $this->TicketField : null;
    }
    /**
     * Set TicketField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketField[] $ticketField
     * @return \SGCIS\Array\ArrayOfTicketField
     */
    public function setTicketField(array $ticketField = array())
    {
        foreach ($ticketField as $arrayOfTicketFieldTicketFieldItem) {
            // validation for constraint: itemType
            if (!$arrayOfTicketFieldTicketFieldItem instanceof \SGCIS\Struct\TicketField) {
                throw new \InvalidArgumentException(sprintf('The TicketField property can only contain items of \SGCIS\Struct\TicketField, "%s" given', is_object($arrayOfTicketFieldTicketFieldItem) ? get_class($arrayOfTicketFieldTicketFieldItem) : gettype($arrayOfTicketFieldTicketFieldItem)), __LINE__);
            }
        }
        if (is_null($ticketField) || (is_array($ticketField) && empty($ticketField))) {
            unset($this->TicketField);
        } else {
            $this->TicketField = $ticketField;
        }
        return $this;
    }
    /**
     * Add item to TicketField value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketField $item
     * @return \SGCIS\Array\ArrayOfTicketField
     */
    public function addToTicketField(\SGCIS\Struct\TicketField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\TicketField) {
            throw new \InvalidArgumentException(sprintf('The TicketField property can only contain items of \SGCIS\Struct\TicketField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketField[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\TicketField|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\TicketField|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\TicketField|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\TicketField|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\TicketField|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TicketField
     */
    public function getAttributeName()
    {
        return 'TicketField';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfTicketField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
