<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemRoleApplicationSearchEntityView Array
 * @subpackage Arrays
 */
class ArrayOfSystemRoleApplicationSearchEntityView extends AbstractStructArrayBase
{
    /**
     * The SystemRoleApplicationSearchEntityView
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemRoleApplicationSearchEntityView[]
     */
    public $SystemRoleApplicationSearchEntityView;
    /**
     * Constructor method for ArrayOfSystemRoleApplicationSearchEntityView
     * @uses ArrayOfSystemRoleApplicationSearchEntityView::setSystemRoleApplicationSearchEntityView()
     * @param \SGCIS\Struct\SystemRoleApplicationSearchEntityView[] $systemRoleApplicationSearchEntityView
     */
    public function __construct(array $systemRoleApplicationSearchEntityView = array())
    {
        $this
            ->setSystemRoleApplicationSearchEntityView($systemRoleApplicationSearchEntityView);
    }
    /**
     * Get SystemRoleApplicationSearchEntityView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView[]|null
     */
    public function getSystemRoleApplicationSearchEntityView()
    {
        return isset($this->SystemRoleApplicationSearchEntityView) ? $this->SystemRoleApplicationSearchEntityView : null;
    }
    /**
     * Set SystemRoleApplicationSearchEntityView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationSearchEntityView[] $systemRoleApplicationSearchEntityView
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView
     */
    public function setSystemRoleApplicationSearchEntityView(array $systemRoleApplicationSearchEntityView = array())
    {
        foreach ($systemRoleApplicationSearchEntityView as $arrayOfSystemRoleApplicationSearchEntityViewSystemRoleApplicationSearchEntityViewItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemRoleApplicationSearchEntityViewSystemRoleApplicationSearchEntityViewItem instanceof \SGCIS\Struct\SystemRoleApplicationSearchEntityView) {
                throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationSearchEntityView property can only contain items of \SGCIS\Struct\SystemRoleApplicationSearchEntityView, "%s" given', is_object($arrayOfSystemRoleApplicationSearchEntityViewSystemRoleApplicationSearchEntityViewItem) ? get_class($arrayOfSystemRoleApplicationSearchEntityViewSystemRoleApplicationSearchEntityViewItem) : gettype($arrayOfSystemRoleApplicationSearchEntityViewSystemRoleApplicationSearchEntityViewItem)), __LINE__);
            }
        }
        if (is_null($systemRoleApplicationSearchEntityView) || (is_array($systemRoleApplicationSearchEntityView) && empty($systemRoleApplicationSearchEntityView))) {
            unset($this->SystemRoleApplicationSearchEntityView);
        } else {
            $this->SystemRoleApplicationSearchEntityView = $systemRoleApplicationSearchEntityView;
        }
        return $this;
    }
    /**
     * Add item to SystemRoleApplicationSearchEntityView value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationSearchEntityView $item
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView
     */
    public function addToSystemRoleApplicationSearchEntityView(\SGCIS\Struct\SystemRoleApplicationSearchEntityView $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemRoleApplicationSearchEntityView) {
            throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationSearchEntityView property can only contain items of \SGCIS\Struct\SystemRoleApplicationSearchEntityView, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemRoleApplicationSearchEntityView[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemRoleApplicationSearchEntityView
     */
    public function getAttributeName()
    {
        return 'SystemRoleApplicationSearchEntityView';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationSearchEntityView
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
